<?php
/**
 * 404 page file
 *
 * @package    WordPress
 * @subpackage Nitech
 * @author     YogsThemes <admin@yogsthemes.com>
 * @version    1.0
 */

$allowed_html = wp_kses_allowed_html( 'post' );
?>
<?php get_header();
$data = \NITECH\Includes\Classes\Common::instance()->data( '404' )->get();
do_action( 'nitech_banner', $data );
$options = nitech_WSH()->option();
if ( class_exists( '\Elementor\Plugin' ) AND $data->get( 'tpl-type' ) == 'e' AND $data->get( 'tpl-elementor' ) ) {
	echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $data->get( 'tpl-elementor' ) );
} else {
	
	
	?>
    
    <!-- Error Section -->
    <section class="error-section">
    	<div class="auto-container">
        	<div class="content">
            	<h1>
				<?php 
                    if( $options->get( '404_page_title' ) ){
                        echo wp_kses( $options->get( '404_page_title' ), true );
                    }else{
                        esc_html_e( '404', 'nitech' );
                    }
                ?>
                </h1>
                <h2>
                <?php 
					if( $options->get( '404_page_subtitle' ) ){
						echo wp_kses( $options->get( '404_page_subtitle' ), true );
					}else{
						esc_html_e( 'Oops! That page can’t be found', 'nitech' );
					}
				?>
                </h2>
                <div class="text">
                <?php 
					if( $options->get( '404_page_text' ) ){
						echo wp_kses( $options->get( '404_page_text' ), true );
					}else{
						esc_html_e( 'Sorry, but the page you are looking for does not existing', 'nitech' );
					}
				?>
                </div>
                <?php if ( $options->get( 'back_home_btn', true ) ) : ?>
                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="theme-btn btn-style-one">
                <span class="txt">
                	<?php 
						if( $options->get( 'back_home_btn_label' ) ){
							echo wp_kses( $options->get( 'back_home_btn_label' ), true );
						}else{
							esc_html_e( 'Go To Home Page', 'nitech' );
						}
					?>
                </span>
                </a>
                <?php endif; ?>
            </div>
        </div>
    </section>
    <!-- End Error Section -->
            
<?php
}
get_footer(); ?>
