<?php
/**
 * Blog Main File.
 *
 * @package NITECH
 * @author  YogsThemes
 * @version 1.0
 */

get_header();
global $wp_query;
$data  = \NITECH\Includes\Classes\Common::instance()->data( 'author' )->get();
$layout = $data->get( 'layout' );
$sidebar = $data->get( 'sidebar' );
$layout = ( $layout ) ? $layout : 'right';
$sidebar = ( $sidebar ) ? $sidebar : 'default-sidebar';
if (is_active_sidebar( $sidebar )) {$layout = 'right';} else{$layout = 'full';}
$class = ( !$layout || $layout == 'full' ) ? 'col-xs-12 col-sm-12 col-md-12' : 'col-xs-12 col-sm-12 col-md-12 col-lg-8';
if ( class_exists( '\Elementor\Plugin' ) AND $data->get( 'tpl-type' ) == 'e' AND $data->get( 'tpl-elementor' ) ) {
	echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $data->get( 'tpl-elementor' ) );
} else {
?>
	
    <?php if ( class_exists( '\Elementor\Plugin' )):?>
		<?php do_action( 'nitech_banner', $data );?>
    <?php else:?>
	<!-- Page Title -->
    <section class="page-title-two">
        <div class="pattern-layer-one" style="background-image: url(<?php echo esc_url(get_template_directory_uri());?>/assets/images/background/pattern-34.png)"></div>
        <div class="pattern-layer-two" style="background-image: url(<?php echo esc_url(get_template_directory_uri());?>/assets/images/background/pattern-35.png)"></div>
        <div class="auto-container">
            <h2><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h2>
            <ul class="page-breadcrumb">
                <?php echo nitech_the_breadcrumb(); ?>
            </ul>
        </div>
    </section>
    <!-- End Page Title -->
    <?php endif;?>
    
	<!-- Sidebar Page Container -->
    <div class="sidebar-page-container">
    	<div class="auto-container">
        	<div class="row clearfix">
                <?php
                        if ( $data->get( 'layout' ) == 'left' ) {
                            do_action( 'nitech_sidebar', $data );
                        }
                ?>
                <div class="content-side <?php echo esc_attr( $class ); ?>">
                    <div class="blog-classic">
                    	<div class="thm-unit-test">
                        
							<?php
                                while ( have_posts() ) :
                                    the_post();
                                    nitech_template_load( 'templates/blog/blog.php', compact( 'data' ) );
                                endwhile;
                                wp_reset_postdata();
                            ?>
                    	
                        </div>
                    
                        <!--Pagination-->
                        <div class="styled-pagination style-two text-center">
                            <?php nitech_the_pagination( $wp_query->max_num_pages );?>
                        </div>
                	</div>    
                </div>
                <?php
                    if ( $data->get( 'layout' ) == 'right' ) {
                        do_action( 'nitech_sidebar', $data );
                    }
                ?>
            </div>
        </div>
    </div> 
    <!--End blog area--> 
	<?php
}
get_footer();
