<?php

return array(
	'title'      => esc_html__( 'Footer Setting', 'nitech' ),
	'id'         => 'footer_setting',
	'desc'       => '',
	'subsection' => false,
	'fields'     => array(
		array(
			'id'      => 'footer_source_type',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Footer Source Type', 'nitech' ),
			'options' => array(
				'd' => esc_html__( 'Default', 'nitech' ),
				'e' => esc_html__( 'Elementor', 'nitech' ),
			),
			'default' => 'd',
		),
		array(
			'id'       => 'footer_elementor_template',
			'type'     => 'select',
			'title'    => __( 'Template', 'nitech' ),
			'data'     => 'posts',
			'args'     => [
				'post_type' => [ 'elementor_library' ],
				'posts_per_page'	=> -1
			],
			'required' => [ 'footer_source_type', '=', 'e' ],
		),
		array(
			'id'       => 'footer_style_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Footer Settings', 'nitech' ),
			'required' => array( 'footer_source_type', '=', 'd' ),
		),
		array(
		    'id'       => 'footer_style_settings',
		    'type'     => 'image_select',
		    'title'    => esc_html__( 'Choose Footer Styles', 'nitech' ),
		    'subtitle' => esc_html__( 'Choose Footer Styles', 'nitech' ),
		    'options'  => array(

			    'footer_v1'  => array(
				    'alt' => esc_html__( 'Footer Style One', 'nitech' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/footer/footer1.png',
			    ),
			    'footer_v2'  => array(
				    'alt' => esc_html__( 'Footer Style Two', 'nitech' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/footer/footer2.png',
			    ),
			    'footer_v3'  => array(
				    'alt' => esc_html__( 'Footer Style Three', 'nitech' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/footer/footer3.png',
			    ),
				'footer_v4'  => array(
				    'alt' => esc_html__( 'Footer Style Four', 'nitech' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/footer/footer4.png',
			    ),
			),
			'required' => array( 'footer_source_type', '=', 'd' ),
			'default' => 'footer_v4',
	    ),
		
		
		/***********************************************************************
								Footer Version 1 Start
		************************************************************************/
		array(
			'id'       => 'footer_v1_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Footer Style One Settings', 'nitech' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v1' ),
		),
		array(
            'id' => 'show_bg_pattern_v1',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Footer BG Pattern Images', 'nitech'),
            'required' => array( 'footer_style_settings', '=', 'footer_v1' ),
			'default' => true,
        ),
		array(
			'id'      => 'copyright_text_v1',
			'type'    => 'textarea',
			'title'   => __( 'Copyright Text', 'nitech' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v1' ),
		),
		array(
            'id' 	  => 'menu_text_v1',
            'type' 	  => 'textarea',
            'title'   => esc_html__("Bottom Footer Menu", 'nitech'),
            'required' => array( 'footer_style_settings', '=', 'footer_v1' ),
        ),
		
		/***********************************************************************
								Footer Version 2 Start
		************************************************************************/
		array(
			'id'       => 'footer_v2_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Footer Style Two Settings', 'nitech' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v2' ),
		),
		array(
            'id' => 'show_bg_pattern_v2',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Footer BG Pattern Images', 'nitech'),
            'required' => array( 'footer_style_settings', '=', 'footer_v2' ),
			'default' => true,
        ),
		array(
			'id'      => 'copyright_text_v2',
			'type'    => 'textarea',
			'title'   => __( 'Copyright Text', 'nitech' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v2' ),
		),
		array(
            'id' 	  => 'menu_text_v2',
            'type' 	  => 'textarea',
            'title'   => esc_html__("Bottom Footer Menu", 'nitech'),
            'required' => array( 'footer_style_settings', '=', 'footer_v2' ),
        ),
		

		/***********************************************************************
								Footer Version 3 Start
		************************************************************************/
		array(
			'id'       => 'footer_v3_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Footer Style Three Settings', 'nitech' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v3' ),
		),
		array(
            'id'       => 'footer_bg_image',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Footer BG Pattern Image', 'nitech' ),
            'subtitle' => esc_html__( 'Insert Footer BG Pattern Image', 'nitech' ),
            'default'  => array( 'url' => get_template_directory_uri() . '/assets/images/background/pattern-31.png' ),
            'required' => array( 'footer_style_settings', '=', 'footer_v3' ),
        ),
		array(
            'id' => 'upper_footer_v3',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Contact Info Area', 'nitech'),
            'default' => true,
            'required' => array( 'footer_style_settings', '=', 'footer_v3' ),
        ),
		array(
			'id'      => 'footer_address_v3',
			'type'    => 'text',
			'title'   => __( 'Address', 'nitech' ),
			'required' => array( 'upper_footer_v3', '=', true ),
		),
		array(
			'id'      => 'footer_phone_v3',
			'type'    => 'text',
			'title'   => __( 'Phone Number', 'nitech' ),
			'required' => array( 'upper_footer_v3', '=', true ),
		),
		array(
			'id'      => 'footer_email_v3',
			'type'    => 'text',
			'title'   => __( 'Email Address', 'nitech' ),
			'required' => array( 'upper_footer_v3', '=', true ),
		),
		array(
			'id'      => 'copyright_text_v3',
			'type'    => 'textarea',
			'title'   => __( 'Copyright Text', 'nitech' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v3' ),
		),
		array(
            'id' 	  => 'menu_text_v3',
            'type' 	  => 'textarea',
            'title'   => esc_html__("Bottom Footer Menu", 'nitech'),
            'required' => array( 'footer_style_settings', '=', 'footer_v3' ),
        ),
		
		/***********************************************************************
								Footer Version 4 Start
		************************************************************************/
		array(
			'id'       => 'footer_v4_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Footer Style Four Settings', 'nitech' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v4' ),
		),
		array(
            'id'       => 'footer_bg_image_v4',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Footer BG Pattern Image', 'nitech' ),
            'subtitle' => esc_html__( 'Insert Footer BG Pattern Image', 'nitech' ),
            'default'  => array( 'url' => get_template_directory_uri() . '/assets/images/background/pattern-31.png' ),
            'required' => array( 'footer_style_settings', '=', 'footer_v4' ),
        ),
		array(
			'id'      => 'copyright_text_v4',
			'type'    => 'textarea',
			'title'   => __( 'Copyright Text', 'nitech' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v4' ),
		),
		array(
            'id' 	  => 'menu_text_v4',
            'type' 	  => 'textarea',
            'title'   => esc_html__("Bottom Footer Menu", 'nitech'),
            'required' => array( 'footer_style_settings', '=', 'footer_v4' ),
        ),
		
		/***********************************************************************
								Footer Section End
		************************************************************************/
		array(
			'id'       => 'footer_default_ed',
			'type'     => 'section',
			'indent'   => false,
			'required' => [ 'footer_source_type', '=', 'd' ],
		),
	),
);
