<?php
/**
 * Blog Post Main File.
 *
 * @package NITECH
 * @author  YogsThemes
 * @version 1.0
 */

get_header();
$data    = \NITECH\Includes\Classes\Common::instance()->data( 'single' )->get();
$layout = $data->get( 'layout' );
$sidebar = $data->get( 'sidebar' );
if (is_active_sidebar( $sidebar )) {$layout = 'right';} else{$layout = 'full';}
$class = ( !$layout || $layout == 'full' ) ? 'col-xs-12 col-sm-12 col-md-12' : 'col-xs-12 col-sm-12 col-md-12 col-lg-8';
$options = nitech_WSH()->option();

if ( class_exists( '\Elementor\Plugin' ) && $data->get( 'tpl-type' ) == 'e') {
	
	while(have_posts()) {
	   the_post();
	   the_content();
    }

} else {
?>

<?php if ( class_exists( '\Elementor\Plugin' )):?>
	<?php do_action( 'nitech_banner', $data );?>
<?php else:?>
<!-- Page Title -->
<section class="page-title-two">
    <div class="pattern-layer-one" style="background-image: url(<?php echo esc_url(get_template_directory_uri());?>/assets/images/background/pattern-34.png)"></div>
    <div class="pattern-layer-two" style="background-image: url(<?php echo esc_url(get_template_directory_uri());?>/assets/images/background/pattern-35.png)"></div>
    <div class="auto-container">
        <h2><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h2>
        <ul class="page-breadcrumb">
            <?php echo nitech_the_breadcrumb(); ?>
        </ul>
    </div>
</section>
<!-- End Page Title -->
<?php endif;?>

<!-- Sidebar Page Container -->
<div class="sidebar-page-container">
    <div class="auto-container">
        <div class="row clearfix">
        	<?php
				if ( $data->get( 'layout' ) == 'left' ) {
					do_action( 'nitech_sidebar', $data );
				}
			?>
            <div class="content-side <?php echo esc_attr( $class ); ?>">
            	
				<?php while ( have_posts() ) : the_post(); ?>
				
                <div class="blog-detail">
                	
                    <div class="thm-unit-test">    
                        
                        <div class="inner-box">
                            <?php if(has_post_thumbnail()){ ?>
                            <div class="image">
                                <?php the_post_thumbnail('nitech_1170x450'); ?>
                                <?php if( $options->get( 'single_post_date' ) ){ ?><div class="post-date"><?php echo esc_attr(get_the_date()); ?></div><?php } ?>
                            </div>
                            <?php } ?>
                            <div class="lower-content">
                                <?php if( $options->get( 'single_post_author' ) || $options->get( 'single_post_comments' )){ ?>
                                <ul class="post-meta">
                                    <?php if( $options->get( 'single_post_author' ) ){ ?><li><span class="icon fa fa-user"></span> <?php the_author(); ?></li><?php } ?>
                                    <?php if( $options->get( 'single_post_comments' ) ){ ?><li><span class="icon fa fa-comments"></span> <?php comments_number( wp_kses(__('0 Comments' , 'nitech'), true), wp_kses(__('1 Comment' , 'nitech'), true), wp_kses(__('% Comments' , 'nitech'), true)); ?></li><?php } ?>
                                </ul>
                                <?php } ?>
                                
                                <div class="text">
									<?php the_content(); ?>
                                    <div class="clearfix"></div>
                                    <?php wp_link_pages(array('before'=>'<div class="paginate-links">'.esc_html__('Pages: ', 'nitech'), 'after' => '</div>', 'link_before'=>'<span>', 'link_after'=>'</span>')); ?>
                                </div>
                                
                                <?php if(function_exists('bunch_share_us_two') || has_tag()):?>
                                <!-- Post Share Options-->
                                <div class="post-share-options">
                                    <div class="post-share-inner clearfix">
                                        <?php if(has_tag()){ ?><div class="pull-left tags"><?php the_tags( '', '', '' ); ?></div><?php } ?>
                                        
                                        <?php if(function_exists('bunch_share_us_two')):?>
										<?php echo wp_kses(bunch_share_us_two(get_the_id(),$post->post_name ), true);?>
                                        <?php endif;?>
                                        
                                    </div>
                                </div>
                                <?php endif;?>
                            </div>
                        </div>
    					
						<?php if((get_previous_post()) || (get_next_post())): ?>
                        <!-- Blog New Posts -->
                        <div class="blog-new-posts">
                            <div class="clearfix">
                                <?php global $post; $prev_post = get_previous_post();
								if (!empty($prev_post)): 
								$post_thumbnail_id = get_post_thumbnail_id($prev_post->ID);
								$post_thumbnail_url = wp_get_attachment_url( $post_thumbnail_id );
								?>
                                <div class="pull-left prev-post">
                                    <a class="prev" style="background-image:url(<?php echo esc_url($post_thumbnail_url);?>);" href="<?php echo esc_url(get_permalink($prev_post->ID)); ?>">
                                        <span><?php echo wp_kses_post($prev_post->post_title); ?></span> 
                                        <div class="cus-btn"><i class="fa fa-angle-double-left"></i> <?php esc_html_e('Previous', 'nitech'); ?></div>
                                    </a>
                                </div>
                                <?php endif ?>
    
								<?php global $post; $next_post = get_next_post();
                                if (!empty($next_post)): 
                                $post_thumbnail_id2 = get_post_thumbnail_id($next_post->ID);
                                $post_thumbnail_url2 = wp_get_attachment_url( $post_thumbnail_id2 );
                                ?>
                                <div class="pull-right next">
                                    <a href="<?php echo esc_url(get_permalink($next_post->ID)); ?>" style="background-image:url(<?php echo esc_url($post_thumbnail_url2);?>);" class="next-post">
                                        <span><?php echo wp_kses_post($next_post->post_title); ?></span> 
                                        <div class="cus-btn"><?php esc_html_e('Next', 'nitech'); ?> <i class="fa fa-angle-double-right"></i></div>
                                    </a>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <!--End post-details-->
                        <?php comments_template(); ?>
                    
                	</div>
					<!--End thm-unit-test-->
                </div>
                <!--End blog-content-->
				<?php endwhile; ?>
                
            </div>
        	<?php
				if ( $data->get( 'layout' ) == 'right' ) {
					do_action( 'nitech_sidebar', $data );
				}
			?>
        </div>
    </div>
</div>
<!--End blog area--> 

<?php
}
get_footer();
