<?php

/**
 * Blog Content Template
 *
 * @package    WordPress
 * @subpackage NITECH
 * @author     YogsThemes
 * @version    1.0
 */

if ( class_exists( 'Nitech_Resizer' ) ) {
	$img_obj = new Nitech_Resizer();
} else {
	$img_obj = array();
}
$allowed_tags = wp_kses_allowed_html('post');
global $post;
$options = nitech_WSH()->option();
?>

<div <?php post_class(); ?>>
    
    <!-- News Block Five -->
    <div class="news-block-five">
        <div class="inner-box">
            <?php if(has_post_thumbnail()){ ?>
            <div class="image">
                <?php the_post_thumbnail('nitech_1170x450'); ?>
                <?php if( has_category() ){?><div class="post-date"><?php the_category( ', ' );?></div><?php } ?>
                <!-- Overlay Box -->
                <div class="overlay-box">
                    <div class="overlay-inner">
                        <div class="content">
                            <a href="<?php echo esc_url(the_permalink(get_the_id())); ?>" class="icon flaticon-unlink"></a>
                        </div>
                    </div>
                </div>
            </div>
            <?php } ?>
            <div class="lower-content">
                
                <h3 class="m-t0"><a href="<?php echo esc_url(the_permalink(get_the_id())); ?>"><?php the_title(); ?></a></h3>
                <div class="text"><?php echo the_excerpt();?></div>
                <div class="d-flex cus-flex-two">
                    <div class="btn-box">
                        <a href="<?php echo esc_url(the_permalink(get_the_id())); ?>" class="theme-btn btn-style-one"><span class="txt"><?php esc_html_e('Read More', 'nitech'); ?></span></a>
                    </div>
                    <?php if( $options->get( 'blog_post_author' ) || $options->get( 'blog_post_comments' )){ ?>
                    <ul class="post-meta">
                        <?php if( $options->get( 'blog_post_author' ) ){ ?><li><span class="icon fa fa-user"></span> <?php the_author(); ?></li><?php } ?>
                        <li><span class="icon fa fa-calendar"></span><?php echo esc_attr(get_the_date()); ?></li>
                        <?php if( $options->get( 'blog_post_comments' ) ){ ?><li><span class="icon fa fa-comments"></span> <?php comments_number( wp_kses(__('0 Comments' , 'nitech'), true), wp_kses(__('1 Comment' , 'nitech'), true), wp_kses(__('% Comments' , 'nitech'), true)); ?></li><?php } ?>
                    </ul>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>

</div>
