<?php
/**
 * Footer Template  File
 *
 * @package NITECH
 * @author  YogsThemes
 * @version 1.0
 */

$options = nitech_WSH()->option();
$allowed_html = wp_kses_allowed_html( 'post' );

$footer_bg = $options->get( 'footer_bg_image' );
$footer_bg = nitech_set( $footer_bg, 'url', NITECH_URI . 'assets/images/background/pattern-31.png' );

?>

	<footer class="footer-style-two" id="contact">
		<?php if($footer_bg){ ?><div class="map-layer" style="background-image: url(<?php echo esc_url($footer_bg); ?>)"></div><?php } ?>
		
		<?php if( $options->get( 'upper_footer_v3' ) ):?>
		<div class="upper-box">
			<div class="auto-container">
				<div class="row clearfix">
					
					<!-- Info Box -->
					<div class="info-box col-lg-4 col-md-6 col-sm-12">
						<div class="inner-box">
							<div class="icon-box"><span class="flaticon-send"></span></div>
							<ul>
								<li><strong><?php esc_html_e('Address', 'nitech'); ?></strong></li>
								<li><?php echo wp_kses($options->get('footer_address_v3'), $allowed_html);?></li>
							</ul>
						</div>
					</div>
					
					<!-- Info Box -->
					<div class="info-box col-lg-4 col-md-6 col-sm-12">
						<div class="inner-box">
							<div class="icon-box"><span class="flaticon-telephone"></span></div>
							<ul>
								<li><strong><?php esc_html_e('Phone:', 'nitech'); ?></strong></li>
								<li><a href="tel:<?php echo esc_url($options->get('footer_phone_v3'));?>"><?php echo wp_kses($options->get('footer_phone_v3'), $allowed_html);?></a></li>
							</ul>
						</div>
					</div>
					
					<!-- Info Box -->
					<div class="info-box col-lg-4 col-md-6 col-sm-12">
						<div class="inner-box">
							<div class="icon-box"><span class="flaticon-email"></span></div>
							<ul>
								<li><strong><?php esc_html_e('Email:', 'nitech'); ?></strong></li>
								<li><a href="mailto:<?php echo esc_url($options->get('footer_email_v3'));?>"><?php echo wp_kses($options->get('footer_email_v3'), $allowed_html);?></a></li>
							</ul>
						</div>
					</div>
					
				</div>
			</div>
		</div>
		<?php endif; ?>
		<!--Waves end-->

		<?php if ( is_active_sidebar( 'footer-sidebar2' ) ):?>
		<div class="auto-container">
        	<!--Widgets Section-->
            <div class="widgets-section">
            	<div class="row clearfix">
					<?php dynamic_sidebar( 'footer-sidebar2' ); ?>
				</div>
			</div>
		</div>
		<?php endif; ?>
		
        <!-- Footer Bottom -->
		<div class="footer-bottom">
			<div class="auto-container">
				<div class="row clearfix">
					<!-- Column -->
					<div class="column col-lg-6 col-md-12 col-sm-12">
						<?php if(($options->get('copyright_text_v3'))):?>
						<div class="copyright"><?php echo wp_kses($options->get('copyright_text_v3', 'Copyright © 2021 Nitech All Rights Reserved.'), $allowed_html); ?></div>
						<?php endif; ?>
					</div>
					
					<!-- Column -->
					<div class="column col-lg-6 col-md-12 col-sm-12">
						<ul class="footer-nav">
							<?php if(($options->get('menu_text_v3'))):?>
							<?php echo wp_kses($options->get('menu_text_v3'), $allowed_html);?>
							<?php endif; ?>
						</ul>
					</div>
					
				</div>
			</div>
		</div>
	</footer>
	<!-- End Main Footer -->