<?php

require_once get_template_directory() . '/includes/loader.php';

add_action( 'after_setup_theme', 'nitech_setup_theme' );
add_action( 'after_setup_theme', 'nitech_load_default_hooks' );


function nitech_setup_theme() {

	load_theme_textdomain( 'nitech', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );
	add_theme_support( 'custom-header' );
	add_theme_support( 'custom-background' );
	add_theme_support( 'woocommerce' );
	add_theme_support( 'wc-product-gallery-lightbox' );
	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'align-wide' );
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'editor-styles' );
	add_theme_support( 'post', 'page-attributes' );
	add_theme_support( 'post-formats', array('quote' ));

	// Set the default content width.
	$GLOBALS['content_width'] = 525;
	
	/*---------- Register image sizes ----------*/
	
	//Register image sizes
    add_image_size( 'nitech_320x405', 320, 405, true ); //nitech_320x405 Our service
	add_image_size( 'nitech_70x70', 70, 70, true ); //nitech_70x70 Our Testimonials
	add_image_size( 'nitech_370x250', 370, 250, true ); //nitech_370x250 Latest News V1
	add_image_size( 'nitech_270x220', 270, 220, true ); //nitech_270x220 Our Team
	add_image_size( 'nitech_270x338', 270, 338, true ); //nitech_270x338 Our Team V2
	add_image_size( 'nitech_370x463', 370, 463, true ); //nitech_370x463 Our Team Details
	add_image_size( 'nitech_333x450', 333, 450, true ); //nitech_333x450 Our Project V1
	add_image_size( 'nitech_1050x697', 1050, 697, true ); //nitech_1050x697 Our Project V2
	add_image_size( 'nitech_84x84', 84, 84, true ); //nitech_84x84 Our Testimonials V2
	add_image_size( 'nitech_370x320', 370, 320, true ); //nitech_370x320 Our Project V3
	add_image_size( 'nitech_370x450', 370, 450, true ); //nitech_370x450 Our Project V5
	add_image_size( 'nitech_370x270', 370, 270, true ); //nitech_370x270 Our Project V5
	add_image_size( 'nitech_1170x450', 1170, 450, true ); //nitech_1170x450 Blog Classic
	
	/*---------- Register image sizes ends ----------*/



	// This theme uses wp_nav_menu() in two locations.
	register_nav_menus( array(
		'main_menu' => esc_html__( 'Main Menu', 'nitech' ),
		'onepage_menu' => esc_html__( 'One Page Menu', 'nitech' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	// Add theme support for Custom Logo.
	add_theme_support( 'custom-logo', array(
		'width'      => 250,
		'height'     => 250,
		'flex-width' => true,
	) );

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	/*
	 * This theme styles the visual editor to resemble the theme style,
	 * specifically font, colors, and column width.
 	 */
	add_editor_style();
	add_action( 'admin_init', 'nitech_admin_init', 2000000 );
}

/**
 * [nitech_admin_init]
 *
 * @param  array $data [description]
 *
 * @return [type]       [description]
 */


function nitech_admin_init() {
	remove_action( 'admin_notices', array( 'ReduxFramework', '_admin_notices' ), 99 );
}

/*---------- Sidebar settings ----------*/

/**
 * [nitech_widgets_init]
 *
 * @param  array $data [description]
 *
 * @return [type]       [description]
 */
function nitech_widgets_init() {

	global $wp_registered_sidebars;

	$theme_options = get_theme_mod( 'nitech' . '_options-mods' );

	register_sidebar( array(
		'name'          => esc_html__( 'Default Sidebar', 'nitech' ),
		'id'            => 'default-sidebar',
		'description'   => esc_html__( 'Widgets in this area will be shown on the right-hand side.', 'nitech' ),
		'before_widget' => '<div id="%1$s" class="widget sidebar-widget single-sidebar %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="widget-title"><h3>',
		'after_title'   => '</h3></div>',
	) );
	register_sidebar(array(
		'name' => esc_html__('Footer Widget', 'nitech'),
		'id' => 'footer-sidebar',
		'description' => esc_html__('Widgets in this area will be shown in Footer Area.', 'nitech'),
		'before_widget'=>'<div class="col-lg-3 col-md-6 col-sm-12 footer-column"><div id="%1$s" class="footer-widget %2$s">',
		'after_widget'=>'</div></div>',
		'before_title' => '<h3>',
		'after_title' => '</h3>'
	));	
	if ( class_exists( '\Elementor\Plugin' )){
	register_sidebar(array(
		'name' => esc_html__('Footer Widget Two', 'nitech'),
		'id' => 'footer-sidebar2',
		'description' => esc_html__('Widgets in this area will be shown in Footer Area.', 'nitech'),
		'before_widget'=>'<div class="col-lg-4 col-md-6 col-sm-12 footer-column"><div id="%1$s" class="footer-widget %2$s">',
		'after_widget'=>'</div></div>',
		'before_title' => '<h3>',
		'after_title' => '</h3>'
	));	
	register_sidebar(array(
		'name' => esc_html__('Services Widget', 'nitech'),
		'id' => 'service-sidebar',
		'description' => esc_html__('Widgets in this area will be shown in Services Area.', 'nitech'),
		'before_widget'=>'<div id="%1$s" class="service-widget sidebar-widget %2$s">',
		'after_widget'=>'</div>',
		'before_title' => '<h3>',
		'after_title' => '</h3>'
	));
	}
	register_sidebar(array(
	  'name' => esc_html__( 'Blog Listing', 'nitech' ),
	  'id' => 'blog-sidebar',
	  'description' => esc_html__( 'Widgets in this area will be shown on the right-hand side.', 'nitech' ),
	  'before_widget'=>'<div id="%1$s" class="widget sidebar-widget %2$s">',
	  'after_widget'=>'</div>',
	  'before_title' => '<div class="sidebar-title"><h3>',
	  'after_title' => '</h3></div>'
	));
	if ( ! is_object( nitech_WSH() ) ) {
		return;
	}

	$sidebars = nitech_set( $theme_options, 'custom_sidebar_name' );

	foreach ( array_filter( (array) $sidebars ) as $sidebar ) {

		if ( nitech_set( $sidebar, 'topcopy' ) ) {
			continue;
		}

		$name = $sidebar;
		if ( ! $name ) {
			continue;
		}
		$slug = str_replace( ' ', '_', $name );

		register_sidebar( array(
			'name'          => $name,
			'id'            => sanitize_title( $slug ),
			'before_widget' => '<div id="%1$s" class="%2$s widget ">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
			'before_title'  => '<div class="widget">',
			'after_title'   => '</div>',
		) );
	}

	update_option( 'wp_registered_sidebars', $wp_registered_sidebars );
}

add_action( 'widgets_init', 'nitech_widgets_init' );

/*---------- Sidebar settings ends ----------*/

/*---------- Gutenberg settings ----------*/

function nitech_gutenberg_editor_palette_styles() {
    add_theme_support( 'editor-color-palette', array(
        array(
            'name' => esc_html__( 'strong yellow', 'nitech' ),
            'slug' => 'strong-yellow',
            'color' => '#f7bd00',
        ),
        array(
            'name' => esc_html__( 'strong white', 'nitech' ),
            'slug' => 'strong-white',
            'color' => '#fff',
        ),
		array(
            'name' => esc_html__( 'light black', 'nitech' ),
            'slug' => 'light-black',
            'color' => '#242424',
        ),
        array(
            'name' => esc_html__( 'very light gray', 'nitech' ),
            'slug' => 'very-light-gray',
            'color' => '#797979',
        ),
        array(
            'name' => esc_html__( 'very dark black', 'nitech' ),
            'slug' => 'very-dark-black',
            'color' => '#000000',
        ),
    ) );
	
	add_theme_support( 'editor-font-sizes', array(
		array(
			'name' => esc_html__( 'Small', 'nitech' ),
			'size' => 10,
			'slug' => 'small'
		),
		array(
			'name' => esc_html__( 'Normal', 'nitech' ),
			'size' => 15,
			'slug' => 'normal'
		),
		array(
			'name' => esc_html__( 'Large', 'nitech' ),
			'size' => 24,
			'slug' => 'large'
		),
		array(
			'name' => esc_html__( 'Huge', 'nitech' ),
			'size' => 36,
			'slug' => 'huge'
		)
	) );
	
}
add_action( 'after_setup_theme', 'nitech_gutenberg_editor_palette_styles' );

/*---------- Gutenberg settings ends ----------*/

/*---------- Enqueue Styles and Scripts ----------*/

function nitech_enqueue_scripts() {
	//styles
    wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/assets/css/bootstrap.css' );
	wp_enqueue_style( 'font-awesome-icon', get_template_directory_uri() . '/assets/css/font-awesome.css' );
	wp_enqueue_style( 'flaticon', get_template_directory_uri() . '/assets/css/flaticon.css' );
	wp_enqueue_style( 'animate', get_template_directory_uri() . '/assets/css/animate.css' );
    wp_enqueue_style( 'custom-animate', get_template_directory_uri() . '/assets/css/custom-animate.css' );
	wp_enqueue_style( 'owl', get_template_directory_uri() . '/assets/css/owl.css' );
	wp_enqueue_style( 'slick', get_template_directory_uri() . '/assets/css/slick.css' );
	wp_enqueue_style( 'jquery-ui', get_template_directory_uri() . '/assets/css/jquery-ui.css' );
	wp_enqueue_style( 'animation', get_template_directory_uri() . '/assets/css/animation.css' );
	wp_enqueue_style( 'swiper', get_template_directory_uri() . '/assets/css/swiper.min.css' );
	wp_enqueue_style( 'jquery-fancybox', get_template_directory_uri() . '/assets/css/jquery.fancybox.min.css' );
	wp_enqueue_style( 'jquery-bootstrap-touchspin', get_template_directory_uri() . '/assets/css/jquery.bootstrap-touchspin.css' );
	wp_enqueue_style( 'jquery-mcustomscrollbar', get_template_directory_uri() . '/assets/css/jquery.mCustomScrollbar.min.css' );
	wp_enqueue_style( 'nitech-main', get_stylesheet_uri() );
	wp_enqueue_style( 'nitech-main-style', get_template_directory_uri() . '/assets/css/main.css' );
	wp_enqueue_style( 'nitech-color-switcher', get_template_directory_uri() . '/assets/css/color-switcher-design.css' );
    wp_enqueue_style( 'nitech-custom', get_template_directory_uri() . '/assets/css/custom.css' );
	wp_enqueue_style( 'nitech-responsive', get_template_directory_uri() . '/assets/css/responsive.css' );
	wp_enqueue_style( 'nitech-woocommerce', get_template_directory_uri() . '/assets/css/woocommerce.css' );
	wp_enqueue_style( 'nitech-color-switcher-design', get_template_directory_uri() . '/assets/css/color-switcher-design.css' );
	
	
    //scripts
	wp_enqueue_script( 'jquery-ui-core');
	wp_enqueue_script( 'popper', get_template_directory_uri().'/assets/js/popper.min.js', array(), false, true );
	wp_enqueue_script( 'jquery-scrollto', get_template_directory_uri().'/assets/js/jquery.scrollTo.js', array(), false, true );
	wp_enqueue_script( 'bootstrap', get_template_directory_uri().'/assets/js/bootstrap.min.js', array(), false, true );
	wp_enqueue_script( 'tilt-jquery', get_template_directory_uri().'/assets/js/tilt.jquery.min.js', array(), false, true );
	wp_enqueue_script( 'jquery-paroller', get_template_directory_uri().'/assets/js/jquery.paroller.min.js', array(), false, true );
	wp_enqueue_script( 'parallax', get_template_directory_uri().'/assets/js/parallax.min.js', array(), false, true );
	wp_enqueue_script( 'jquery-mcustomscrollbar', get_template_directory_uri().'/assets/js/jquery.mCustomScrollbar.concat.min.js', array(), false, true );
	wp_enqueue_script( 'jquery-fancybox', get_template_directory_uri().'/assets/js/jquery.fancybox.js', array(), false, true );
	wp_enqueue_script( 'appear', get_template_directory_uri().'/assets/js/appear.js', array(), false, true );
	wp_enqueue_script( 'owl', get_template_directory_uri().'/assets/js/owl.js', array(), false, true );
	wp_enqueue_script( 'wow', get_template_directory_uri().'/assets/js/wow.js', array(), false, true );
	wp_enqueue_script( 'isotope', get_template_directory_uri().'/assets/js/isotope.js', array(), false, true );
	wp_enqueue_script( 'element-in-view', get_template_directory_uri().'/assets/js/element-in-view.js', array(), false, true );
	wp_enqueue_script( 'swiper', get_template_directory_uri().'/assets/js/swiper.min.js', array(), false, true );
	wp_enqueue_script( 'pagenav', get_template_directory_uri().'/assets/js/pagenav.js', array(), false, true );
	wp_enqueue_script( 'nav-tool', get_template_directory_uri().'/assets/js/nav-tool.js', array(), false, true );
	wp_enqueue_script( 'jquery-ui', get_template_directory_uri().'/assets/js/jquery-ui.js', array(), false, true );
	wp_enqueue_script( 'jquery-countdown', get_template_directory_uri().'/assets/js/jquery.countdown.js', array(), false, true );
	wp_enqueue_script( 'nitech-main-script', get_template_directory_uri().'/assets/js/script.js', array(), false, true );
	wp_enqueue_script( 'nitech-color-settings', get_template_directory_uri().'/assets/js/color-settings.js', array(), false, true );
	if( is_singular() ) wp_enqueue_script('comment-reply');
}
add_action( 'wp_enqueue_scripts', 'nitech_enqueue_scripts' );

/*---------- Enqueue styles and scripts ends ----------*/

/*---------- Google fonts ----------*/

function nitech_fonts_url() {
	
	$fonts_url = '';

		$font_families['Arimo']   = 'Arimo:400,500,600,700';
		$font_families['Raleway']    = 'Raleway:100,200,300,400,500,600,700,800,900';

		$font_families = apply_filters( 'NITECH/includes/classes/header_enqueue/font_families', $font_families );

		$query_args = array(
			'family' => urlencode( implode( '|', $font_families ) ),
			'subset' => urlencode( 'latin,latin-ext' ),
		);

		$protocol  = is_ssl() ? 'https' : 'http';
		$fonts_url = add_query_arg( $query_args, $protocol . '://fonts.googleapis.com/css' );

		return esc_url_raw($fonts_url);

}

function nitech_theme_styles() {
    wp_enqueue_style( 'nitech-theme-fonts', nitech_fonts_url(), array(), null );
}

add_action( 'wp_enqueue_scripts', 'nitech_theme_styles' );
add_action( 'admin_enqueue_scripts', 'nitech_theme_styles' );

/*---------- Google fonts ends ----------*/

/*---------- More functions ----------*/

// 1) nitech_set function

/**
 * [nitech_set description]
 *
 * @param  array $data [description]
 *
 * @return [type]       [description]
 */
if ( ! function_exists( 'nitech_set' ) ) {
	function nitech_set( $var, $key, $def = '' ) {
		//if( ! $var ) return false;

		if ( is_object( $var ) && isset( $var->$key ) ) {
			return $var->$key;
		} elseif ( is_array( $var ) && isset( $var[ $key ] ) ) {
			return $var[ $key ];
		} elseif ( $def ) {
			return $def;
		} else {
			return false;
		}
	}
}

// 2) nitech_add_editor_styles function

function nitech_add_editor_styles() {
    add_editor_style( 'editor-style.css' );
}
add_action( 'admin_init', 'nitech_add_editor_styles' );

// 3) Add specific CSS class by filter body class.

$options = nitech_WSH()->option(); 
if( nitech_set($options, 'boxed_wrapper') ){

add_filter( 'body_class', function( $classes ) {
    $classes[] = 'boxed_wrapper';
    return $classes;
} );
}
/*---------- More functions ends ----------*/
add_filter('doing_it_wrong_trigger_error', function () {return false;}, 10, 0);