<?php
return array(
	'title'      => esc_html__( 'Header Setting', 'nitech' ),
	'id'         => 'headers_setting',
	'desc'       => '',
	'subsection' => false,
	'fields'     => array(
		array(
			'id'      => 'header_source_type',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Header Source Type', 'nitech' ),
			'options' => array(
				'd' => esc_html__( 'Default', 'nitech' ),
				'e' => esc_html__( 'Elementor', 'nitech' ),
			),
			'default' => 'd',
		),
		array(
			'id'       => 'header_elementor_template',
			'type'     => 'select',
			'title'    => __( 'Template', 'nitech' ),
			'data'     => 'posts',
			'args'     => [
				'post_type' => [ 'elementor_library' ],
				'posts_per_page'	=> -1
			],
			'required' => [ 'header_source_type', '=', 'e' ],
		),
		array(
			'id'       => 'header_style_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Settings', 'nitech' ),
			'required' => array( 'header_source_type', '=', 'd' ),
		),

		//Header Settings
		array(
		    'id'       => 'header_style_settings',
		    'type'     => 'image_select',
		    'title'    => esc_html__( 'Choose Header Styles', 'nitech' ),
		    'subtitle' => esc_html__( 'Choose Header Styles', 'nitech' ),
		    'options'  => array(

			    'header_v1'  => array(
				    'alt' => esc_html__( 'Header Style One', 'nitech' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/header/header1.png',
			    ),
			    'header_v2'  => array(
				    'alt' => esc_html__( 'Header Style Two', 'nitech' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/header/header2.png',
			    ),
			    'header_v3'  => array(
				    'alt' => esc_html__( 'Header Style Three', 'nitech' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/header/header3.png',
			    ),
			    'header_v4'  => array(
				    'alt' => esc_html__( 'One Page Header Style 1', 'nitech' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/header/header4.png',
			    ),
			    'header_v5'  => array(
				    'alt' => esc_html__( 'One Page Header Style 2', 'nitech' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/header/header5.png',
			    ),
			    'header_v6'  => array(
				    'alt' => esc_html__( 'One Page Header Style 3', 'nitech' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/header/header6.png',
			    ),
			),
			'required' => array( 'header_source_type', '=', 'd' ),
			'default' => 'header_v3',
	    ),

		/***********************************************************************
								Header Version 1 Start
		************************************************************************/
		array(
			'id'       => 'header_v1_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Style One Settings', 'nitech' ),
			'required' => array( 'header_style_settings', '=', 'header_v1' ),
		),
		array(
            'id' => 'show_topbar_v1',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Header Top Bar', 'nitech'),
            'default' => true,
            'required' => array( 'header_style_settings', '=', 'header_v1' ),
        ),
		array(
            'id' => 'phone_text_v1',
            'type' => 'text',
            'title' => esc_html__("Phone Title", 'nitech'),
            'required' => array( 'show_topbar_v1', '=', true ),
        ),
		array(
            'id' => 'phone_no_v1',
            'type' => 'text',
            'title' => esc_html__("Phone Number", 'nitech'),
            'required' => array( 'show_topbar_v1', '=', true ),
        ),
		array(
            'id' => 'address_v1',
            'type' => 'textarea',
            'title' => esc_html__("Address", 'nitech'),
            'required' => array( 'show_topbar_v1', '=', true ),
        ),
		array(
            'id' => 'hiring_text_v1',
            'type' => 'text',
            'title' => esc_html__("Hiring Text", 'nitech'),
            'required' => array( 'show_topbar_v1', '=', true ),
        ),
		array(
            'id' => 'topbar_menu_v1',
            'type' => 'textarea',
            'title' => esc_html__("Header Topbar Menu Raw Html", 'nitech'),
            'required' => array( 'show_topbar_v1', '=', true ),
        ),
        array(
            'id'    => 'header_v1_social_share',
            'type'  => 'social_media',
            'title' => esc_html__( 'Social Media', 'nitech' ),
            'required' => array( 'show_topbar_v1', '=', true ),
        ),
		array(
		    'id'       => 'cart_box_switcher_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Cart Icon', 'nitech' ),
		    'desc'     => esc_html__( 'Enable/Disable Cart Icon.', 'nitech' ),
			'default'  => 'true',
		    'required' => array( 'header_style_settings', '=', 'header_v1' ),
	    ),
		array(
		    'id'       => 'search_form_switcher_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Search Form Icon', 'nitech' ),
		    'desc'     => esc_html__( 'Enable/Disable Search Form Icon.', 'nitech' ),
			'default'  => 'true',
		    'required' => array( 'header_style_settings', '=', 'header_v1' ),
	    ),
		array(
            'id' => 'sidebar_switcher_v1',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Sidebar Icon', 'nitech'),
			'desc'     => esc_html__( 'Enable/Disable Sidebar Icon.', 'nitech' ),
            'default' => true,
            'required' => array( 'header_style_settings', '=', 'header_v1' ),
        ),
		array(
            'id' => 'sidebar_title',
            'type' => 'text',
            'title' => esc_html__("Sidebar Title", 'nitech'),
             'required' => array( 'sidebar_switcher_v1', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_text',
            'type' => 'textarea',
            'title' => esc_html__("Sidebar Text", 'nitech'),
             'required' => array( 'sidebar_switcher_v1', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_btn_title1',
            'type' => 'text',
            'title' => esc_html__("Button Title", 'nitech'),
             'required' => array( 'sidebar_switcher_v1', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_btn_link1',
            'type' => 'text',
            'title' => esc_html__("Button URL", 'nitech'),
             'required' => array( 'sidebar_switcher_v1', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_contact_title_v1',
            'type' => 'text',
            'title' => esc_html__("Sidebar Sub Heading", 'nitech'),
             'required' => array( 'sidebar_switcher_v1', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_address_v1',
            'type' => 'textarea',
            'title' => esc_html__("Sidebar Address", 'nitech'),
             'required' => array( 'sidebar_switcher_v1', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_phone_v1',
            'type' => 'text',
            'title' => esc_html__("Sidebar Phone Number", 'nitech'),
             'required' => array( 'sidebar_switcher_v1', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_email_v1',
            'type' => 'text',
            'title' => esc_html__("Sidebar Email Address", 'nitech'),
             'required' => array( 'sidebar_switcher_v1', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_working_days_v1',
            'type' => 'textarea',
            'title' => esc_html__("Sidebar Working Hours", 'nitech'),
             'required' => array( 'sidebar_switcher_v1', '=', true ),
			'label_block' => true,
        ),
        array(
            'id'    => 'sidebar_header_v1_social_share',
            'type'  => 'social_media',
            'title' => esc_html__( 'Social Media', 'nitech' ),
            'required' => array( 'sidebar_switcher_v1', '=', true ),
        ),
		array(
		    'id'       => 'Button_switcher_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Get A Quote Button', 'nitech' ),
		    'desc'     => esc_html__( 'Enable/Disable Get A Quote Button', 'nitech' ),
			'default'  => 'true',
		    'required' => array( 'header_style_settings', '=', 'header_v1' ),
	    ),
		array(
            'id' => 'btn_title',
            'type' => 'text',
            'title' => esc_html__("Button Title", 'nitech'),
             'required' => array( 'Button_switcher_v1', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'btn_link',
            'type' => 'text',
            'title' => esc_html__("Button URL", 'nitech'),
             'required' => array( 'Button_switcher_v1', '=', true ),
			'label_block' => true,
        ),
		
		
		/***********************************************************************
								Header Version 2 Start
		************************************************************************/
		array(
			'id'       => 'header_v2_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Style Two Settings', 'nitech' ),
			'required' => array( 'header_style_settings', '=', 'header_v2' ),
		),
		array(
            'id' => 'show_topbar_v2',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Header Top Bar', 'nitech'),
            'default' => true,
            'required' => array( 'header_style_settings', '=', 'header_v2' ),
        ),
		array(
            'id' => 'phone_text_v2',
            'type' => 'text',
            'title' => esc_html__("Phone Title", 'nitech'),
            'required' => array( 'show_topbar_v2', '=', true ),
        ),
		array(
            'id' => 'phone_no_v2',
            'type' => 'text',
            'title' => esc_html__("Phone Number", 'nitech'),
            'required' => array( 'show_topbar_v2', '=', true ),
        ),
		array(
            'id' => 'address_v2',
            'type' => 'text',
            'title' => esc_html__("Address", 'nitech'),
            'required' => array( 'show_topbar_v2', '=', true ),
        ),
        array(
            'id'    => 'header_v2_social_share',
            'type'  => 'social_media',
            'title' => esc_html__( 'Social Media', 'nitech' ),
            'required' => array( 'show_topbar_v2', '=', true ),
        ),
		array(
            'id' => 'search_form_switcher_v2',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Search Icon', 'nitech'),
            'default' => true,
            'required' => array( 'header_style_settings', '=', 'header_v2' ),
        ),
		array(
            'id' => 'sidebar_switcher_v2',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Sidebar Icon', 'nitech'),
			'desc'     => esc_html__( 'Enable/Disable Sidebar Icon.', 'nitech' ),
            'default' => true,
            'required' => array( 'header_style_settings', '=', 'header_v2' ),
        ),
		array(
            'id' => 'sidebar_title_v2',
            'type' => 'text',
            'title' => esc_html__("Sidebar Title", 'nitech'),
             'required' => array( 'sidebar_switcher_v2', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_text_v2',
            'type' => 'textarea',
            'title' => esc_html__("Sidebar Text", 'nitech'),
             'required' => array( 'sidebar_switcher_v2', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_btn_title_v2',
            'type' => 'text',
            'title' => esc_html__("Button Title", 'nitech'),
             'required' => array( 'sidebar_switcher_v2', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_btn_link_v2',
            'type' => 'text',
            'title' => esc_html__("Button URL", 'nitech'),
             'required' => array( 'sidebar_switcher_v2', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_contact_title',
            'type' => 'text',
            'title' => esc_html__("Sidebar Sub Heading", 'nitech'),
             'required' => array( 'sidebar_switcher_v2', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_address_v2',
            'type' => 'textarea',
            'title' => esc_html__("Sidebar Address", 'nitech'),
             'required' => array( 'sidebar_switcher_v2', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_phone_v2',
            'type' => 'text',
            'title' => esc_html__("Sidebar Phone Number", 'nitech'),
             'required' => array( 'sidebar_switcher_v2', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_email_v2',
            'type' => 'text',
            'title' => esc_html__("Sidebar Email Address", 'nitech'),
             'required' => array( 'sidebar_switcher_v2', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_working_days_v2',
            'type' => 'textarea',
            'title' => esc_html__("Sidebar Working Hours", 'nitech'),
             'required' => array( 'sidebar_switcher_v2', '=', true ),
			'label_block' => true,
        ),
        array(
            'id'    => 'sidebar_header_v2_social_share',
            'type'  => 'social_media',
            'title' => esc_html__( 'Social Media', 'nitech' ),
            'required' => array( 'sidebar_switcher_v2', '=', true ),
        ),
		
		/***********************************************************************
								Header Version 3 Start
		************************************************************************/
		array(
			'id'       => 'header_v3_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Style Three Settings', 'nitech' ),
			'required' => array( 'header_style_settings', '=', 'header_v3' ),
		),
		array(
            'id' => 'show_topbar_v3',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Header Top Bar', 'nitech'),
            'default' => true,
            'required' => array( 'header_style_settings', '=', 'header_v3' ),
        ),
		array(
            'id' => 'hiring_text_v3',
            'type' => 'text',
            'title' => esc_html__("Hiring Text", 'nitech'),
            'required' => array( 'show_topbar_v3', '=', true ),
        ),
        array(
            'id'    => 'header_v3_social_share',
            'type'  => 'social_media',
            'title' => esc_html__( 'Social Media', 'nitech' ),
            'required' => array( 'show_topbar_v3', '=', true ),
        ),
		array(
            'id' => 'address1_v3',
            'type' => 'textarea',
            'title' => esc_html__("Address", 'nitech'),
             'required' => array( 'header_style_settings', '=', 'header_v3' ),
			'label_block' => true,
        ),
		array(
            'id' => 'working_hours_v3',
            'type' => 'textarea',
            'title' => esc_html__("Working Hours", 'nitech'),
             'required' => array( 'header_style_settings', '=', 'header_v3' ),
			'label_block' => true,
        ),
		array(
            'id' => 'make_call_v3',
            'type' => 'text',
            'title' => esc_html__("Phone Number", 'nitech'),
             'required' => array( 'header_style_settings', '=', 'header_v3' ),
			'label_block' => true,
        ),
		array(
            'id' => 'button_switcher_v3',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Button', 'nitech'),
			'desc'     => esc_html__( 'Enable/Disable Get A Quote Button', 'nitech' ),
            'default' => true,
            'required' => array( 'header_style_settings', '=', 'header_v3' ),
        ),
		array(
            'id' => 'btn_title_v3',
            'type' => 'text',
            'title' => esc_html__("Button Title", 'nitech'),
             'required' => array( 'button_switcher_v3', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'btn_link_v3',
            'type' => 'text',
            'title' => esc_html__("Button URL", 'nitech'),
             'required' => array( 'button_switcher_v3', '=', true ),
			'label_block' => true,
        ),
		
				
		/***********************************************************************
							One Page Header Style One Start
		************************************************************************/
		array(
			'id'       => 'header_v4_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'One Page Header Style One Settings', 'nitech' ),
			'required' => array( 'header_style_settings', '=', 'header_v4' ),
		),
		array(
            'id' => 'show_topbar_v4',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Header Top Bar', 'nitech'),
            'default' => true,
            'required' => array( 'header_style_settings', '=', 'header_v4' ),
        ),
		array(
            'id' => 'phone_text_v4',
            'type' => 'text',
            'title' => esc_html__("Phone Title", 'nitech'),
            'required' => array( 'show_topbar_v4', '=', true ),
        ),
		array(
            'id' => 'phone_no_v4',
            'type' => 'text',
            'title' => esc_html__("Phone Number", 'nitech'),
            'required' => array( 'show_topbar_v4', '=', true ),
        ),
		array(
            'id' => 'address_v4',
            'type' => 'textarea',
            'title' => esc_html__("Address", 'nitech'),
            'required' => array( 'show_topbar_v4', '=', true ),
        ),
		array(
            'id' => 'hiring_text_v4',
            'type' => 'text',
            'title' => esc_html__("Hiring Text", 'nitech'),
            'required' => array( 'show_topbar_v4', '=', true ),
        ),
		array(
            'id' => 'topbar_menu_v4',
            'type' => 'textarea',
            'title' => esc_html__("Header Topbar Menu Raw Html", 'nitech'),
            'required' => array( 'show_topbar_v4', '=', true ),
        ),
        array(
            'id'    => 'header_v4_social_share',
            'type'  => 'social_media',
            'title' => esc_html__( 'Social Media', 'nitech' ),
            'required' => array( 'show_topbar_v4', '=', true ),
        ),
		array(
		    'id'       => 'cart_box_switcher_v4',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Cart Icon', 'nitech' ),
		    'desc'     => esc_html__( 'Enable/Disable Cart Icon.', 'nitech' ),
			'default'  => 'true',
		    'required' => array( 'header_style_settings', '=', 'header_v4' ),
	    ),
		array(
		    'id'       => 'search_form_switcher_v4',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Search Form Icon', 'nitech' ),
		    'desc'     => esc_html__( 'Enable/Disable Search Form Icon.', 'nitech' ),
			'default'  => 'true',
		    'required' => array( 'header_style_settings', '=', 'header_v4' ),
	    ),
		array(
            'id' => 'sidebar_switcher_v4',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Sidebar Icon', 'nitech'),
			'desc'     => esc_html__( 'Enable/Disable Sidebar Icon.', 'nitech' ),
            'default' => true,
            'required' => array( 'header_style_settings', '=', 'header_v4' ),
        ),
		array(
            'id' => 'sidebar_title_v4',
            'type' => 'text',
            'title' => esc_html__("Sidebar Title", 'nitech'),
             'required' => array( 'sidebar_switcher_v4', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_text_v4',
            'type' => 'textarea',
            'title' => esc_html__("Sidebar Text", 'nitech'),
             'required' => array( 'sidebar_switcher_v4', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_btn_title1_v4',
            'type' => 'text',
            'title' => esc_html__("Button Title", 'nitech'),
             'required' => array( 'sidebar_switcher_v4', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_btn_link1_v4',
            'type' => 'text',
            'title' => esc_html__("Button URL", 'nitech'),
             'required' => array( 'sidebar_switcher_v4', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_contact_title_v4',
            'type' => 'text',
            'title' => esc_html__("Sidebar Sub Heading", 'nitech'),
             'required' => array( 'sidebar_switcher_v4', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_address_v4',
            'type' => 'textarea',
            'title' => esc_html__("Sidebar Address", 'nitech'),
             'required' => array( 'sidebar_switcher_v4', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_phone_v4',
            'type' => 'text',
            'title' => esc_html__("Sidebar Phone Number", 'nitech'),
             'required' => array( 'sidebar_switcher_v4', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_email_v4',
            'type' => 'text',
            'title' => esc_html__("Sidebar Email Address", 'nitech'),
             'required' => array( 'sidebar_switcher_v4', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_working_days_v4',
            'type' => 'textarea',
            'title' => esc_html__("Sidebar Working Hours", 'nitech'),
             'required' => array( 'sidebar_switcher_v4', '=', true ),
			'label_block' => true,
        ),
        array(
            'id'    => 'sidebar_header_v4_social_share',
            'type'  => 'social_media',
            'title' => esc_html__( 'Social Media', 'nitech' ),
            'required' => array( 'sidebar_switcher_v4', '=', true ),
        ),
		array(
		    'id'       => 'Button_switcher_v4',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Get A Quote Button', 'nitech' ),
		    'desc'     => esc_html__( 'Enable/Disable Get A Quote Button', 'nitech' ),
			'default'  => 'true',
		    'required' => array( 'header_style_settings', '=', 'header_v4' ),
	    ),
		array(
            'id' => 'btn_title_v4',
            'type' => 'text',
            'title' => esc_html__("Button Title", 'nitech'),
             'required' => array( 'Button_switcher_v4', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'btn_link_v4',
            'type' => 'text',
            'title' => esc_html__("Button URL", 'nitech'),
             'required' => array( 'Button_switcher_v4', '=', true ),
			'label_block' => true,
        ),
		
		
		/***********************************************************************
						One Page Header Style Two Start
		************************************************************************/
		array(
			'id'       => 'header_v5_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'One Page Header Style Two Settings', 'nitech' ),
			'required' => array( 'header_style_settings', '=', 'header_v5' ),
		),
		array(
            'id' => 'show_topbar_v5',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Header Top Bar', 'nitech'),
            'default' => true,
            'required' => array( 'header_style_settings', '=', 'header_v5' ),
        ),
		array(
            'id' => 'phone_text_v5',
            'type' => 'text',
            'title' => esc_html__("Phone Title", 'nitech'),
            'required' => array( 'show_topbar_v5', '=', true ),
        ),
		array(
            'id' => 'phone_no_v5',
            'type' => 'text',
            'title' => esc_html__("Phone Number", 'nitech'),
            'required' => array( 'show_topbar_v5', '=', true ),
        ),
		array(
            'id' => 'address_v5',
            'type' => 'text',
            'title' => esc_html__("Address", 'nitech'),
            'required' => array( 'show_topbar_v5', '=', true ),
        ),
        array(
            'id'    => 'header_v5_social_share',
            'type'  => 'social_media',
            'title' => esc_html__( 'Social Media', 'nitech' ),
            'required' => array( 'show_topbar_v5', '=', true ),
        ),
		array(
            'id' => 'search_form_switcher_v5',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Search Icon', 'nitech'),
            'default' => true,
            'required' => array( 'header_style_settings', '=', 'header_v5' ),
        ),
		array(
            'id' => 'sidebar_switcher_v5',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Sidebar Icon', 'nitech'),
			'desc'     => esc_html__( 'Enable/Disable Sidebar Icon.', 'nitech' ),
            'default' => true,
            'required' => array( 'header_style_settings', '=', 'header_v5' ),
        ),
		array(
            'id' => 'sidebar_title_v5',
            'type' => 'text',
            'title' => esc_html__("Sidebar Title", 'nitech'),
             'required' => array( 'sidebar_switcher_v5', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_text_v5',
            'type' => 'textarea',
            'title' => esc_html__("Sidebar Text", 'nitech'),
             'required' => array( 'sidebar_switcher_v5', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_btn_title_v5',
            'type' => 'text',
            'title' => esc_html__("Button Title", 'nitech'),
             'required' => array( 'sidebar_switcher_v5', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_btn_link_v5',
            'type' => 'text',
            'title' => esc_html__("Button URL", 'nitech'),
             'required' => array( 'sidebar_switcher_v5', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_contact_title_v5',
            'type' => 'text',
            'title' => esc_html__("Sidebar Sub Heading", 'nitech'),
             'required' => array( 'sidebar_switcher_v5', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_address_v5',
            'type' => 'textarea',
            'title' => esc_html__("Sidebar Address", 'nitech'),
             'required' => array( 'sidebar_switcher_v5', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_phone_v5',
            'type' => 'text',
            'title' => esc_html__("Sidebar Phone Number", 'nitech'),
             'required' => array( 'sidebar_switcher_v5', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_email_v5',
            'type' => 'text',
            'title' => esc_html__("Sidebar Email Address", 'nitech'),
             'required' => array( 'sidebar_switcher_v5', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'sidebar_working_days_v5',
            'type' => 'textarea',
            'title' => esc_html__("Sidebar Working Hours", 'nitech'),
             'required' => array( 'sidebar_switcher_v5', '=', true ),
			'label_block' => true,
        ),
        array(
            'id'    => 'sidebar_header_v5_social_share',
            'type'  => 'social_media',
            'title' => esc_html__( 'Social Media', 'nitech' ),
            'required' => array( 'sidebar_switcher_v5', '=', true ),
        ),
		
		/***********************************************************************
						One Page Header Style Three Start
		************************************************************************/
		array(
			'id'       => 'header_v6_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'One Page Header Style Three Settings', 'nitech' ),
			'required' => array( 'header_style_settings', '=', 'header_v6' ),
		),
		array(
            'id' => 'show_topbar_v6',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Header Top Bar', 'nitech'),
            'default' => true,
            'required' => array( 'header_style_settings', '=', 'header_v6' ),
        ),
		array(
            'id' => 'hiring_text_v6',
            'type' => 'text',
            'title' => esc_html__("Hiring Text", 'nitech'),
            'required' => array( 'show_topbar_v6', '=', true ),
        ),
        array(
            'id'    => 'header_v6_social_share',
            'type'  => 'social_media',
            'title' => esc_html__( 'Social Media', 'nitech' ),
            'required' => array( 'show_topbar_v6', '=', true ),
        ),
		array(
            'id' => 'address1_v6',
            'type' => 'textarea',
            'title' => esc_html__("Address", 'nitech'),
             'required' => array( 'header_style_settings', '=', 'header_v6' ),
			'label_block' => true,
        ),
		array(
            'id' => 'working_hours_v6',
            'type' => 'text',
            'title' => esc_html__("Working Hours", 'nitech'),
             'required' => array( 'header_style_settings', '=', 'header_v6' ),
			'label_block' => true,
        ),
		array(
            'id' => 'make_call_v6',
            'type' => 'text',
            'title' => esc_html__("Phone Number", 'nitech'),
             'required' => array( 'header_style_settings', '=', 'header_v6' ),
			'label_block' => true,
        ),
		array(
            'id' => 'button_switcher_v6',
            'type' => 'switch',
            'title' => esc_html__('Enable/Disable Button', 'nitech'),
			'desc'     => esc_html__( 'Enable/Disable Get A Quote Button', 'nitech' ),
            'default' => true,
            'required' => array( 'header_style_settings', '=', 'header_v6' ),
        ),
		array(
            'id' => 'btn_title_v6',
            'type' => 'text',
            'title' => esc_html__("Button Title", 'nitech'),
             'required' => array( 'button_switcher_v6', '=', true ),
			'label_block' => true,
        ),
		array(
            'id' => 'btn_link_v6',
            'type' => 'text',
            'title' => esc_html__("Button URL", 'nitech'),
             'required' => array( 'button_switcher_v6', '=', true ),
			'label_block' => true,
        ),
		
		array(
			'id'       => 'header_style_section_end',
			'type'     => 'section',
			'indent'      => false,
			'required' => [ 'header_source_type', '=', 'd' ],
		),
	),
);
