<?php

return array(
	'title'      => esc_html__( 'Single Post Settings', 'nitech' ),
	'id'         => 'single_post_setting',
	'desc'       => '',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'      => 'single_source_type',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Single Post Source Type', 'nitech' ),
			'options' => array(
				'd' => esc_html__( 'Default', 'nitech' ),
				'e' => esc_html__( 'Elementor', 'nitech' ),
			),
			'default' => 'd',
		),

		array(
			'id'       => 'single_default_st',
			'type'     => 'section',
			'title'    => esc_html__( 'Post Default', 'nitech' ),
			'indent'   => true,
			'required' => [ 'single_source_type', '=', 'd' ],
		),
		array(
			'id'      => 'single_post_date',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Date', 'nitech' ),
			'desc'    => esc_html__( 'Enable to show post publish date on posts detail page', 'nitech' ),
			'default' => true,
		),
		array(
			'id'      => 'single_post_author',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Author', 'nitech' ),
			'desc'    => esc_html__( 'Enable to show author on posts detail page', 'nitech' ),
			'default' => true,
		),

		array(
			'id'      => 'single_post_comments',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Comments', 'nitech' ),
			'desc'    => esc_html__( 'Enable to show number of comments on posts single page', 'nitech' ),
			'default' => true,
		),
		array(
			'id'      => 'facebook_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Facebook Post Share', 'nitech' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Facebook', 'nitech' ),
			'default' => false,
		),
		array(
			'id'      => 'twitter_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Twitter Post Share', 'nitech' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Twitter', 'nitech' ),
			'default' => false,
		),
		array(
			'id'      => 'linkedin_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Linkedin Post Share', 'nitech' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Linkedin', 'nitech' ),
			'default' => false,
		),
		array(
			'id'      => 'pinterest_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Pinterest Post Share', 'nitech' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Pinterest', 'nitech' ),
			'default' => false,
		),
		array(
			'id'      => 'reddit_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Reddit Post Share', 'nitech' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Reddit', 'nitech' ),
			'default' => false,
		),
		array(
			'id'      => 'tumblr_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Tumblr Post Share', 'nitech' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Tumblr', 'nitech' ),
			'default' => false,
		),
		array(
			'id'      => 'digg_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Digg Post Share', 'nitech' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Digg', 'nitech' ),
			'default' => false,
		),
		array(
			'id'       => 'single_section_default_ed',
			'type'     => 'section',
			'indent'   => false,
			'required' => [ 'single_source_type', '=', 'd' ],
		),
	),
);





