<?php
/**
 * Footer Template  File
 *
 * @package NITECH
 * @author  YogsThemes
 * @version 1.0
 */

$options = nitech_WSH()->option();
$allowed_html = wp_kses_allowed_html( 'post' );


?>

	<!-- Main Footer -->
    <footer class="main-footer" id="contact">
		<?php if($options->get( 'show_bg_pattern_v1' )){ ?>
        <div class="pattern-layer-one" style="background-image: url(<?php echo esc_url(get_template_directory_uri());?>/assets/images/background/footer-pattern-1.png)"></div>
		<div class="pattern-layer-two" style="background-image: url(<?php echo esc_url(get_template_directory_uri());?>/assets/images/background/footer-pattern-2.png)"></div>
		<div class="pattern-layer-three" style="background-image: url(<?php echo esc_url(get_template_directory_uri());?>/assets/images/background/footer-pattern-3.png)"></div>
		<!--Waves end-->
		<?php } ?>
    	<div class="auto-container">
			<?php if ( is_active_sidebar( 'footer-sidebar' ) ):?>
        	<!--Widgets Section-->
            <div class="widgets-section">
            	<div class="row clearfix">
                	<?php dynamic_sidebar( 'footer-sidebar' ); ?>
				</div>
			</div>
			<?php endif; ?>
			
			<!-- Footer Bottom -->
			<div class="footer-bottom">
				<div class="row clearfix">
                    <!-- Column -->
                    <div class="column col-lg-6 col-md-12 col-sm-12">
                        <?php if(($options->get('copyright_text_v1'))):?>
                        <div class="copyright"><?php echo wp_kses($options->get('copyright_text_v1', 'Copyright &copy; 2021 Nitech All Rights Reserved.'), true); ?></div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Column -->
                    <div class="column col-lg-6 col-md-12 col-sm-12">
                        <ul class="footer-nav">
                            <?php if(($options->get('menu_text_v1'))):?>
                            <?php echo wp_kses($options->get('menu_text_v1'), true);?>
                            <?php endif; ?>
                        </ul>
                    </div>
                    
                </div>
			</div>
		</div>
	</footer>
	
    <!-- End Main Footer -->

   