<?php
$options = nitech_WSH()->option();
$allowed_html = wp_kses_allowed_html( 'post' );

//Logo Settings
$image_logo = $options->get( 'image_normal_logo' );
$logo_dimension = $options->get( 'normal_logo_dimension' );
$image_logo2 = $options->get( 'image_normal_logo2' );
$logo_dimension2 = $options->get( 'normal_logo_dimension2' );

$mobile_image_logo = $options->get( 'mobile_image_normal_logo' );
$mobile_logo_dimension = $options->get( 'mobile_normal_logo_dimension' );

$logo_type = '';
$logo_text = '';
$logo_typography = ''; ?>

 	
    <!-- Preloader -->
	<?php if( $options->get( 'theme_preloader' ) ):?>
	<div class="preloader"></div>
	<?php endif; ?>
 	
    <!-- Main Header / Hedare Style Two -->
    <header class="main-header header-style-two">
    	
		<!-- Header Top Two -->
		<?php if( $options->get( 'show_topbar_v5' ) ):?>
        <div class="header-top-two">
            <div class="auto-container">
                <div class="clearfix">
				
					<!-- Top Left -->
					
					<div class="top-left pull-left clearfix">
						
						<!-- Info List -->
                        <ul class="info-list">
							<?php if(($options->get('phone_text_v5')) || ($options->get('phone_no_v5'))):?>
							<li><span class="icon flaticon-call-1"></span> <?php echo wp_kses($options->get('phone_text_v5'), $allowed_html);?><a href="tel:<?php echo phone_number($options->get('phone_no_v5'));?>"><?php echo wp_kses($options->get('phone_no_v5'), $allowed_html);?></a></li>
							<?php endif; ?>
							<?php if(($options->get('address_v5'))):?>
							<li><span class="icon flaticon-placeholder-3"></span><?php echo wp_kses($options->get('address_v5'), $allowed_html);?></li>
							<?php endif; ?>
						</ul>
						
					</div>
                    
					<!-- Top Right -->
                    <div class="top-right pull-right clearfix">
					
						<!-- Social Box -->
						<?php
							$icons = $options->get( 'header_v5_social_share' );
							if ( ! empty( $icons ) ) :
						?>
                        <ul class="social-box">
						<?php
							foreach ( $icons as $h_icon ) :
							$header_social_icons = json_decode( urldecode( nitech_set( $h_icon, 'data' ) ) );
							if ( nitech_set( $header_social_icons, 'enable' ) == '' ) {
								continue;
							}
							$icon_class = explode( '-', nitech_set( $header_social_icons, 'icon' ) );
							?>
							<li><a href="<?php echo esc_url(nitech_set( $header_social_icons, 'url' )); ?>" style="color: <?php echo esc_attr(nitech_set( $header_social_icons, 'color' )); ?>" class="fa <?php echo esc_attr( nitech_set( $header_social_icons, 'icon' ) ); ?>"></a></li>
						<?php endforeach; ?>
                        </ul>
						<?php endif; ?>
						
                    </div>
					
                </div>
            </div>
        </div>
		<?php endif; ?>
		
    	<!-- Header Upper -->
        <div class="header-upper">
        	<div class="auto-container">
            	<div class="inner-container clearfix">
                	
					<!-- Logo Box -->
                	<div class="pull-left logo-box">
                    	<div class="logo"><?php echo nitech_logo( $logo_type, $image_logo2, $logo_dimension2, $logo_text, $logo_typography ); ?></div>
                    </div>
                   	
					<!-- Nav Outer -->
                   	<div class="nav-outer clearfix">
						
						<!-- Mobile Navigation Toggler For Mobile -->
						<div class="mobile-nav-toggler"><span class="icon flaticon-menu"></span></div>
						<!-- End Mobile Navigation Toggler For Mobile -->
						
						<!-- Main Menu -->
						<nav class="main-menu navbar-expand-md">
							<div class="navbar-header">
								<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
									<span class="icon-bar"></span>
									<span class="icon-bar"></span>
									<span class="icon-bar"></span>
								</button>
							</div>

							<div class="navbar-collapse collapse scroll-nav clearfix" id="navbarSupportedContent">
								<ul class="navigation clearfix">
								<?php wp_nav_menu( array( 'theme_location' => 'onepage_menu', 'container_id' => 'navbar-collapse-1',
									'container_class'=>'navbar-collapse collapse navbar-right',
									'menu_class'=>'nav navbar-nav',
									'fallback_cb'=>false, 
									'items_wrap' => '%3$s', 
									'container'=>false,
									'depth'=>'3',
									'walker'=> new Bootstrap_walker()  
								) ); ?>
                                </ul>
							</div>
							
						</nav>
						
						<!-- Main Menu End-->
						<div class="outer-box clearfix">
							
							<!-- Search Btn -->
							
							<?php if($options->get('search_form_switcher_v5')):?>
								<div class="search-box-btn search-box-outer"><span class="icon flaticon-search"></span></div>
							<?php endif; ?>
							
							<!-- Nav Btn -->
							
							<?php if($options->get('sidebar_switcher_v5')):?>
								<div class="nav-btn navSidebar-button"><span class="icon flaticon-menu-4"></span></div>
							<?php endif; ?>
						</div>
					
					</div>
                   
                </div>
            </div>
        </div>
        <!--End Header Upper-->
        
        <!-- Sticky Header  -->
        <div class="sticky-header">
            <div class="auto-container clearfix">
                <div class="inner-container clearfix">
                    <!--Logo-->
                    <div class="logo pull-left">
                        <?php echo nitech_logo( $logo_type, $image_logo, $logo_dimension, $logo_text, $logo_typography ); ?>
                    </div>
                    <!--Right Col-->
                    <div class="pull-right">
                    
                        <!-- Main Menu -->
                        <nav class="main-menu">
                            <!--Keep This Empty / Menu will come through Javascript-->
                        </nav>
                        <!-- Main Menu End-->
                        
                    </div>
                </div>
            </div>
        </div><!-- End Sticky Menu -->
        
		<!-- Mobile Menu  -->
        <div class="mobile-menu">
            <div class="menu-backdrop"></div>
            <div class="close-btn"><span class="icon flaticon-cancel"></span></div>
            
            <!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header-->
            <nav class="menu-box">
            	<div class="nav-logo"><?php echo nitech_logo( $logo_type, $mobile_image_logo, $mobile_logo_dimension, $logo_text, $logo_typography ); ?></div>
                
                <div class="menu-outer"><!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header--></div>
            </nav>
        </div><!-- End Mobile Menu -->
		
    </header>
    <!--End Main Header -->
	
	
	<?php if($options->get('sidebar_switcher_v5')):?>
	<!-- Sidebar Cart Item -->
	<div class="xs-sidebar-group info-group">
		<div class="xs-overlay xs-bg-black"></div>
		<div class="xs-sidebar-widget">
			<div class="sidebar-widget-container">
				<div class="widget-heading">
					<a href="#" class="close-side-widget flaticon-cancel-1">
						
					</a>
				</div>
				<div class="sidebar-textwidget">
					
					<!-- Sidebar Info Content -->
					<div class="sidebar-info-contents">
						<div class="content-inner">
							<div class="logo">
								<?php echo nitech_logo( $logo_type, $image_logo2, $logo_dimension2, $logo_text, $logo_typography ); ?>
							</div>
							<div class="content-box">
								<?php if(($options->get('sidebar_title_v5'))):?><h2><?php echo wp_kses($options->get('sidebar_title_v5'), $allowed_html); ?></h2><?php endif; ?>
								<?php if(($options->get('sidebar_text_v5'))):?><p class="text"><?php echo wp_kses($options->get('sidebar_text_v5'), $allowed_html); ?></p><?php endif; ?>
								<?php if(($options->get('sidebar_btn_title_v5')) || ($options->get('sidebar_btn_link_v5'))):?>
								<a href="<?php echo esc_url($options->get('sidebar_btn_link_v5')); ?>" class="theme-btn btn-style-one"><span class="txt"><?php echo wp_kses($options->get('sidebar_btn_title_v5'), $allowed_html); ?></span></a>
								<?php endif; ?>
							</div>
							<div class="contact-info">
								<h2><?php echo wp_kses($options->get('sidebar_contact_title_v5'), $allowed_html); ?></h2>
								<ul class="list-style-one">
									<?php if(($options->get('sidebar_address_v5'))):?><li><span class="icon flaticon-maps-and-flags"></span><?php echo wp_kses($options->get('sidebar_address_v5'), $allowed_html); ?></li><?php endif; ?>
									<?php if(($options->get('sidebar_phone_v5'))):?><li><span class="icon flaticon-call-1"></span><?php echo wp_kses($options->get('sidebar_phone_v5'), $allowed_html); ?></li><?php endif; ?>
									<?php if(($options->get('sidebar_email_v5'))):?><li><span class="icon flaticon-chat-bubbles-with-ellipsis"></span><?php echo wp_kses($options->get('sidebar_email_v5'), $allowed_html); ?></li><?php endif; ?>
									<?php if(($options->get('sidebar_working_days_v5'))):?><li><span class="icon flaticon-wall-clock"></span><?php echo wp_kses($options->get('sidebar_working_days_v5'), $allowed_html); ?></li><?php endif; ?>
								</ul>
							</div>
							<!-- Social Box -->
							<?php
								$icons = $options->get( 'sidebar_header_v5_social_share' );
								if ( ! empty( $icons ) ) :
							?>
							<ul class="social-box">
							<?php
								foreach ( $icons as $h_icon ) :
								$header_social_icons = json_decode( urldecode( nitech_set( $h_icon, 'data' ) ) );
								if ( nitech_set( $header_social_icons, 'enable' ) == '' ) {
									continue;
								}
								$icon_class = explode( '-', nitech_set( $header_social_icons, 'icon' ) );
								?>
								<li><a href="<?php echo esc_url(nitech_set( $header_social_icons, 'url' )); ?>" style="color: <?php echo esc_attr(nitech_set( $header_social_icons, 'color' )); ?>" class="fa <?php echo esc_attr( nitech_set( $header_social_icons, 'icon' ) ); ?>"></a></li>
							<?php endforeach; ?>
							</ul>
							<?php endif; ?>
						</div>
					</div>
					
				</div>
			</div>
		</div>
	</div>
	<?php endif; ?>
	<!-- END sidebar widget item -->
   
	<?php if($options->get('search_form_switcher_v5')):?>
	<!-- Search Popup -->
	<div class="search-popup">
		<button class="close-search style-two"><span class="flaticon-cancel-1"></span></button>
		<button class="close-search"><span class="flaticon-up-arrow"></span></button>
		<?php echo esc_attr(get_template_part('searchform1')); ?>
	</div>
	<!-- End Header Search -->
	<?php endif; ?>
