<?php
$options = nitech_WSH()->option();
$allowed_html = wp_kses_allowed_html( 'post' );

//Logo Settings

$image_logo3 = $options->get( 'image_normal_logo3' );
$logo_dimension3 = $options->get( 'normal_logo_dimension3' );

$mobile_image_logo = $options->get( 'mobile_image_normal_logo' );
$mobile_logo_dimension = $options->get( 'mobile_normal_logo_dimension' );

$logo_type = '';
$logo_text = '';
$logo_typography = ''; ?>


	<!-- Preloader -->
	<?php if( $options->get( 'theme_preloader' ) ):?>
	<div class="preloader"></div>
	<?php endif; ?>	
 	
    <!-- Main Header / Hedare Style Three -->
    <header class="main-header header-style-three">
    	
		<!-- Header Top Three-->
		<?php if( $options->get( 'show_topbar_v6' ) ):?>
        <div class="header-top-three">
            <div class="auto-container">
                <div class="clearfix">
					<?php if($options->get('hiring_text_v6')):?>
					<!-- Top Left -->
					<div class="top-left pull-left clearfix">
						<div class="text"><?php echo wp_kses($options->get('hiring_text_v6'), $allowed_html);?></div>
					</div>
					<?php endif; ?>
					<!-- Top Right -->
                    <div class="top-right pull-right clearfix">
						
						<!-- Social Box -->
						<?php
							$icons = $options->get( 'header_v6_social_share' );
							if ( ! empty( $icons ) ) :
						?>
                        <ul class="social-box">
                            <?php
                                foreach ( $icons as $h_icon ) :
                                $header_social_icons = json_decode( urldecode( nitech_set( $h_icon, 'data' ) ) );
                                if ( nitech_set( $header_social_icons, 'enable' ) == '' ) {
                                    continue;
                                }
                                $icon_class = explode( '-', nitech_set( $header_social_icons, 'icon' ) );
                                ?>
                                <li><a href="<?php echo esc_url(nitech_set( $header_social_icons, 'url' )); ?>" style="color: <?php echo esc_attr(nitech_set( $header_social_icons, 'color' )); ?>" class="fa <?php echo esc_attr( nitech_set( $header_social_icons, 'icon' ) ); ?>"></a></li>
                            <?php endforeach; ?>
                        </ul>
						<?php endif; ?>
						
                    </div>
					
                </div>
            </div>
        </div>
		<?php endif; ?>
    	<!-- Header Upper -->
        <div class="header-upper">
            <div class="auto-container">
                <div class="inner-container clearfix">
                    
                    <div class="pull-left logo-box">
                        <div class="logo"><?php echo nitech_logo( $logo_type, $image_logo3, $logo_dimension3, $logo_text, $logo_typography ); ?></div>
                    </div>
                    
                    <div class="pull-right upper-right clearfix">
                        <?php if($options->get('address1_v6')){ ?>
                        <!--Info Box-->
                        <div class="upper-column info-box">
                            <div class="icon-box"><span class="flaticon-placeholder-3"></span></div>
                            <ul>
                                <li><strong><?php esc_html_e('Address', 'nitech'); ?></strong></li>
                                <li><?php echo wp_kses($options->get('address1_v6'), $allowed_html);?></li>
                            </ul>
                        </div>
                        <?php } ?>
                        <?php if($options->get('working_hours_v6')){ ?>
                        <!--Info Box-->
                        <div class="upper-column info-box">
                            <div class="icon-box"><span class="flaticon-send"></span></div>
                            <ul>
                                <li><strong><?php esc_html_e('Mon - Fri', 'nitech'); ?></strong></li>
                                <li><?php echo wp_kses($options->get('working_hours_v6'), $allowed_html);?></li>
                            </ul>
                        </div>
                        <?php } ?>
                        <?php if($options->get('make_call_v6')){ ?>
                        <!--Info Box-->
                        <div class="upper-column info-box">
                            <div class="icon-box"><span class="flaticon-telephone"></span></div>
                            <ul>
								<li><strong><?php esc_html_e('Make a Call', 'nitech'); ?></strong></li>
                                <li><?php echo wp_kses($options->get('make_call_v6'), $allowed_html);?></li>
                            </ul>
                        </div>
                        <?php } ?>
                    </div>
                    
                </div>
            </div>
        </div>
        <!-- End Header Upper -->
		
		<!-- Header Lower -->
        <div class="header-lower">
            
            <div class="auto-container">
                <!-- Nav Outer -->
				<div class="nav-outer clearfix">
					
					<!-- Mobile Navigation Toggler For Mobile -->
					<div class="mobile-nav-toggler"><span class="icon flaticon-menu"></span></div>
					<!-- End Mobile Navigation Toggler For Mobile -->
					
					<!-- Main Menu -->
					<nav class="main-menu navbar-expand-md">
						<div class="navbar-header">
							<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
								<span class="icon-bar"></span>
								<span class="icon-bar"></span>
								<span class="icon-bar"></span>
							</button>
						</div>

						<div class="navbar-collapse collapse scroll-nav clearfix" id="navbarSupportedContent">
							<ul class="navigation clearfix">
							<?php wp_nav_menu( array( 'theme_location' => 'onepage_menu', 'container_id' => 'navbar-collapse-1',
								'container_class'=>'navbar-collapse collapse navbar-right',
								'menu_class'=>'nav navbar-nav',
								'fallback_cb'=>false, 
								'items_wrap' => '%3$s', 
								'container'=>false,
								'depth'=>'3',
								'walker'=> new Bootstrap_walker()  
							) ); ?>
							</ul>
						</div>
						
					</nav>
					
					<!-- Main Menu End-->
					<div class="outer-box clearfix">
					
						<!-- Button Box -->
						<?php if($options->get('button_switcher_v6')):?>
						<div class="btn-box">
							<a href="<?php echo wp_kses($options->get('btn_link_v6'), $allowed_html);?>" class="theme-btn btn-style-one"><span class="txt"><?php echo wp_kses($options->get('btn_title_v6'), $allowed_html);?></span></a>
						</div>
						<?php endif; ?>
						<!-- End Button Box -->
						
					</div>
				
				</div>
            </div>
        </div>
        <!-- End Header Lower -->
        
		<!-- Mobile Menu  -->
        <div class="mobile-menu">
            <div class="menu-backdrop"></div>
            <div class="close-btn"><span class="icon flaticon-cancel"></span></div>
            
            <!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header-->
            <nav class="menu-box">
            	<div class="nav-logo"><?php echo nitech_logo( $logo_type, $mobile_image_logo, $mobile_logo_dimension, $logo_text, $logo_typography ); ?></div>
                
                <div class="menu-outer"><!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header--></div>
            </nav>
        </div><!-- End Mobile Menu -->
		
    </header>
    <!--End Main Header -->
   