<?php

namespace NITECHPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class About_Us extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'nitech_about_us';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'About Us', 'nitech' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'nitech' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'about_us',
				[
					'label' => esc_html__( 'About Us', 'nitech' ),
				]
		);
		$this->add_control(
			'about_us_image1',
			[
			  'label' => __( 'About Image V1', 'nitech' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
	    );
		$this->add_control(
			'about_us_image2',
			[
			  'label' => __( 'About Image V2', 'nitech' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
	    );
		$this->add_control(
            'video_link',
			[
				'label' => __( 'Video Url', 'nitech' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
        );
		$this->add_control(
			'story_text',
			[
				'label'       => __( 'Video Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Video story text', 'nitech' ),
			]
		);
		$this->add_control(
			'about_sub_title',
			[
				'label'       => __( 'Sub Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'nitech' ),
			]
		);
		$this->add_control(
			'about_title',
			[
				'label'       => __( 'Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'nitech' ),
			]
		);
		$this->add_control(
			'about_text',
			[
				'label'       => __( 'Text', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your text', 'nitech' ),
			]
		);
		$this->add_control(
            'slides', 
			  	[
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'default' => 
				[
					['block_text' => esc_html__('Expert Needed Worker', 'nitech')],
					['block_text' => esc_html__('Urgent Support For Clients', 'nitech')]
				],
			'fields' => 
				[
					[
						'name' => 'icons',
						'label' => esc_html__('Select Icon', 'nitech'),
						'label_block' => true,
						'type' => Controls_Manager::SELECT2,
						'options' => get_fontawesome_icons(),
					],
					[
						'name' => 'block_text',
						'label' => esc_html__('Title', 'nitech'),
						'label_block' => true,
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__('', 'nitech')
					],
				],
				'title_field' => '{{block_text}}',
            ]
        );
		$this->add_control(
			'comment_text',
			[
				'label'       => __( 'Quote Text', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Quote Text', 'nitech' ),
			]
		);
		$this->add_control(
			'author_img',
				[
				  'label' => __( 'Author Image', 'nitech' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
	    );
		$this->add_control(
			'signature_image',
				[
				  'label' => __( 'Signature Image', 'nitech' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
	    );
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>

	<!-- About Section -->
	<section class="about-section" id="about">
		<div class="auto-container">
			<div class="row clearfix">
			
				<!-- Image Column -->
				<div class="image-column col-lg-6 col-md-12 col-sm-12">
					<div class="inner-column">
						<?php if($settings['about_us_image1']['id']){ ?>
                        <div class="image">
							<img src="<?php echo esc_url(wp_get_attachment_url($settings['about_us_image1']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'nitech'); ?>" />
						</div>
						<?php } ?>
                        <?php if($settings['about_us_image2']['id'] || $settings['video_link']['url']){ ?> 
                        <div class="image-two wow animate__fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
							<?php if($settings['about_us_image2']['id']){ ?><img src="<?php echo esc_url(wp_get_attachment_url($settings['about_us_image2']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'nitech'); ?>" /><?php } ?>
							<?php if($settings['video_link']['url']){ ?> <a href="<?php echo esc_url($settings['video_link']['url']); ?>" class="lightbox-image video-box"><span class="fa fa-play"><i class="ripple"></i></span></a><?php } ?>
						</div>
						<?php } ?>
                        <?php if($settings['story_text']){ ?><div class="story"><?php echo wp_kses($settings['story_text'], true); ?></div><?php } ?>
					</div>
				</div>
				
				<!-- Content Column -->
				<div class="content-column col-lg-6 col-md-12 col-sm-12">
					<div class="inner-column">
						<?php if($settings['about_sub_title'] || $settings['about_title'] || $settings['about_text']){ ?>
                        <!-- Sec Title -->
						<div class="sec-title">
							<?php if($settings['about_sub_title']){ ?>
                            <div class="title">
								<span class="icon-box-left">
									<span class="color-one"></span>
									<span class="color-two"></span>
									<span class="color-three"></span>
								</span>
								<?php echo wp_kses($settings['about_sub_title'], true); ?>
							</div>
                            <?php } ?>
                            
							<?php if($settings['about_title']){ ?>
                            <h2><?php echo wp_kses($settings['about_title'], true); ?></h2>
                            <?php } ?>
							
							<?php if($settings['about_text']){ ?>
                            <div class="text"><?php echo wp_kses($settings['about_text'], true); ?></div>
                            <?php } ?>
						</div>
						<!-- End Sec Title -->
						<?php } ?>
						<!-- Blocks Outer -->
						<div class="blocks-outer">
							<div class="row clearfix">
							
								<?php foreach($settings['slides'] as $key => $item):?>
								<!-- Feature Block -->
								<div class="feature-block col-lg-6 col-md-6 col-sm-12">
									<div class="inner-box">
										<div class="check-icon flaticon-checked-1"></div>
										<div class="<?php echo esc_attr($item['icons']);?>"></div>
										<?php echo wp_kses($item['block_text'], true); ?>
									</div>
								</div>
								<?php endforeach;?>
							</div>
						</div>
						<!-- End Blocks Outer -->
						
						<!-- About Author Box -->
						<div class="about-author-box">
							<div class="box-inner">
								<?php if($settings['comment_text']){ ?>
                                <div class="comment">
									 <?php echo wp_kses($settings['comment_text'], true); ?>
								</div>
								<?php } ?>
                                <div class="lower-box">
									<div class="lower-inner">
										<?php if($settings['author_img']['id']){ ?>
                                        <div class="author-image">
											<img src="<?php echo esc_url(wp_get_attachment_url($settings['author_img']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'nitech'); ?>" />
										</div>
										<?php } ?>
                                        <?php if($settings['signature_image']['id']){ ?>
                                        <div class="signature"><img src="<?php echo esc_url(wp_get_attachment_url($settings['signature_image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'nitech'); ?>" /></div>
                                        <?php } ?>
									</div>
								</div>
							</div>
						</div>
						<!-- End About Author Box -->
						
					</div>
				</div>
				
			</div>
		</div>
	</section>
	
	<!-- End About Section -->
		
    <?php 
	
	}

}