<?php

namespace NITECHPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class About_Us_V2 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'nitech_about_us_v2';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'About Us V2', 'nitech' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'nitech' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'about_us_v2',
				[
					'label' => esc_html__( 'About Us V2', 'nitech' ),
				]
		);
		$this->add_control(
			'pattern_image1',
				[
				  'label' => __( 'Pattern Image One', 'nitech' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
	    );
		$this->add_control(
			'sub_title',
			[
				'label'       => __( 'Sub Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title Here', 'nitech' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'nitech' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Text', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text', 'nitech' ),
			]
		);
		$this->add_control(
			'pattern_image2',
				[
				  'label' => __( 'Pattern Image Two', 'nitech' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
	    );
		$this->add_control(
            'slides', 
			[
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'default' => 
					[
						['block_title' => esc_html__('Active Clients', 'nitech')],
						['block_title' => esc_html__('Projects Done', 'nitech')],
						['block_title' => esc_html__('Team Advisors', 'nitech')],
						['block_title' => esc_html__('Glorious Years', 'nitech')]
					],
				'fields' => 
				[
					
					[
						'name' => 'counter_start',
						'label' => esc_html__('Counter Start', 'nitech'),
						'label_block' => true,
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__('', 'nitech')
					],
					[
						'name' => 'counter_stop',
						'label' => esc_html__('Counter Stop', 'nitech'),
						'type' => Controls_Manager::TEXT,
						'label_block' => true,
						'default' => esc_html__('', 'nitech')
					],
					[
						'name' => 'alphabet_letter',
						'label' => esc_html__('Alphabet Letter', 'nitech'),
						'type' => Controls_Manager::TEXT,
						'label_block' => true,
						'default' => esc_html__('', 'nitech')
					],
					[
						'name' => 'block_title',
						'label' => esc_html__('Block Title', 'nitech'),
						'label_block' => true,
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__('', 'nitech')
					],
				],
				'title_field' => '{{block_title}}',
            ]
        );
		$this->add_control(
			'pattern_image3',
			[
			  'label' => __( 'Pattern Image Three', 'nitech' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
	    );
		$this->add_control(
			'about_us_image1',
			[
			  'label' => __( 'About Us Image One', 'nitech' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
	    );
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>


	<!-- About Section Two -->
	<section class="about-section-two" id="about">
		<?php if($settings['pattern_image1']['id']){ ?><div class="color-layer" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['pattern_image1']['id'])); ?>)"></div><?php } ?>
		<div class="auto-container">
			<?php if($settings['sub_title'] || $settings['title'] || $settings['text']){ ?>
            <!-- Sec Title / Style Two -->
			<div class="sec-title style-two">
				<div class="clearfix">
					<?php if($settings['sub_title'] || $settings['title']){ ?>
                    <div class="pull-left">
						<?php if($settings['sub_title']){ ?><div class="title"><?php echo wp_kses($settings['sub_title'], true); ?></div><?php } ?>
						<?php if($settings['title']){ ?><h2><?php echo wp_kses($settings['title'], true); ?></h2><?php } ?>
					</div>
                    <?php } ?>
                    <?php if($settings['text']){ ?>
					<div class="pull-right">
						<div class="text"><?php echo wp_kses($settings['text'], true); ?></div>
					</div>
                    <?php } ?>
				</div>
			</div>
            <?php } ?>
			<div class="row clearfix">
			
				<!-- Counter Column -->
				<div class="counte-column col-lg-6 col-md-12 col-sm-12">
					<div class="inner-column" <?php if($settings['pattern_image2']['id']){ ?>style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['pattern_image2']['id'])); ?>)"<?php } ?>>
						<div class="separate-one"></div>
						<div class="separate-two"></div>
						
						<!-- Fact Counter / Style Two -->
						<div class="fact-counter style-two">
							<div class="row clearfix">

								<?php foreach($settings['slides'] as $key => $item): ?>
								<!-- Column -->
								<div class="column counter-column col-lg-6 col-md-6 col-sm-12">
									<div class="inner wow fadeInLeft" data-wow-delay="900ms" data-wow-duration="1500ms">
										<div class="content">
											<div class="count-outer count-box">
												<span class="count-text" data-speed="3500" data-stop="<?php echo esc_attr($item['counter_stop']);?>"><?php echo esc_attr($item['counter_start']);?></span><?php echo esc_attr($item['alphabet_letter']);?>
											</div>
											<h4 class="counter-title"><?php echo wp_kses($item['block_title'], true); ?></h4>
										</div>
									</div>
								</div>
								<?php endforeach; ?>
							</div>
						</div>
						
					</div>
				</div>
				<?php if($settings['pattern_image3']['id'] || $settings['about_us_image1']['id']){ ?>
				<!-- Image Column -->
				<div class="image-column col-lg-6 col-md-12 col-sm-12">
					<div class="inner-column">
						<?php if($settings['pattern_image3']['id']){ ?><div class="pattern-layer" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['pattern_image3']['id'])); ?>)"></div><?php } ?>
						<?php if($settings['about_us_image1']['id']){ ?>
                        <div class="image">
							<img src="<?php echo esc_url(wp_get_attachment_url($settings['about_us_image1']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'nitech'); ?>" />
						</div>
                        <?php } ?>
					</div>
				</div>
				<?php } ?>
			</div>
		</div>
	</section>
	
	<!-- End About Section Two -->
		
    <?php 
	
	}

}