<?php

namespace NITECHPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class About_Us_V3 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'nitech_about_us_v3';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'About Us V3', 'nitech' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'nitech' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'about_us_v3',
				[
					'label' => esc_html__( 'About Us V3', 'nitech' ),
				]
		);
		$this->add_control(
			'sub_title',
			[
				'label'       => __( 'Sub Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title Here', 'nitech' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'nitech' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Text', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text', 'nitech' ),
			]
		);
		$this->add_control(
			'skills_title',
			[
				'label'       => __( 'Skill Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'nitech' ),
			]
		);
		$this->add_control(
			'counter_start',
			[
				'label'       => __( 'Counter Start', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( '', 'nitech' ),
			]
		);
		$this->add_control(
			'counter_stop',
			[
				'label'       => __( 'Counter Stop', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( '', 'nitech' ),
			]
		);
		$this->add_control(
			'features_list',
			[
				'label'       => __( 'Feature List', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Feature List', 'nitech' ),
			]
		);
		$this->add_control(
			'signature_img',
				[
				  'label' => __( 'Signature Image', 'nitech' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
	    );
		$this->add_control(
			'icons2',
			[
				'label' => esc_html__('Select Icon', 'nitech'),
				'label_block' => true,
				'type' => Controls_Manager::SELECT2,
				'options' => get_fontawesome_icons(),
			]
	    );
		$this->add_control(
			'counter_start1',
			[
				'label'       => __( 'Counter Start', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( '', 'nitech' ),
			]
		);
		$this->add_control(
			'counter_stop1',
			[
				'label'       => __( 'Counter Stop', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( '', 'nitech' ),
			]
		);
		$this->add_control(
			'since_text',
			[
				'label'       => __( 'Since Text', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text', 'nitech' ),
			]
		);
		$this->add_control(
            'slides', 
			[
				'type' => Controls_Manager::REPEATER,
				'separator' => 'before',
				'default' => 
					[
						['block_title' => esc_html__('Website Development', 'nitech')],
						['block_title' => esc_html__('Internet Networking', 'nitech')]
					],
				'fields' => 
				[
					[
						'name' => 'icons',
						'label' => esc_html__('Select Icon', 'nitech'),
						'label_block' => true,
						'type' => Controls_Manager::SELECT2,
						'options' => get_fontawesome_icons(),
					],
					[
						'name' => 'block_title',
						'label' => esc_html__('Block Title', 'nitech'),
						'label_block' => true,
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__('Enter Title Here', 'nitech')
					],
					[
						'name' => 'block_text',
						'label' => esc_html__('Block Text', 'nitech'),
						'label_block' => true,
						'type' => Controls_Manager::TEXTAREA,
						'default' => esc_html__('Enter Text Here', 'nitech')
					],
				],
				'title_field' => '{{block_title}}',
            ]
        );
		$this->add_control(
			'about_image1',
				[
				  'label' => __( 'About Image', 'nitech' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
	    );
		$this->add_control(
			'pattern_image1',
				[
				  'label' => __( 'Pattern Image', 'nitech' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
	    );
		
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>

	<!-- About Section Three -->
	<section class="about-section-three" id="about">
		<div class="auto-container">
			<div class="row clearfix">
				<!-- Content Column -->
				<div class="content-column col-lg-6 col-md-12 col-sm-12">
					<div class="inner-column">
						<?php if($settings['sub_title'] || $settings['title'] || $settings['text']){ ?>
                        <!-- Sec Title / Style Three -->
						<div class="sec-title style-three">
							<?php if($settings['sub_title']){ ?><div class="title"><?php echo wp_kses($settings['sub_title'], true); ?></div><?php } ?>
							<?php if($settings['title']){ ?><h2><?php echo wp_kses($settings['title'], true); ?></h2><?php } ?>
							<?php if($settings['text']){ ?><div class="text"><?php echo wp_kses($settings['text'], true); ?></div><?php } ?>
						</div>
						<?php } ?>
						
                        <?php if($settings['skills_title']){ ?>
                        <!-- Skills / Style Two -->
						<div class="skills style-two">

							<!-- Skill Item -->
							<div class="skill-item">
								<div class="skill-header clearfix">
									<div class="skill-title"><?php echo wp_kses($settings['skills_title'], true); ?></div>
								</div>
								<div class="skill-bar">
									<div class="bar-inner">
										<div class="bar progress-line" data-width="<?php echo esc_attr($settings['counter_stop']);?>"></div>
									</div>
								</div>
								<div class="skill-percentage"><div class="count-box"><span class="count-text" data-speed="2000" data-stop="<?php echo esc_attr($settings['counter_stop']);?>"><?php echo esc_attr($settings['counter_start']);?></span><?php esc_html_e('%', 'nitech'); ?></div></div>
							</div>
						</div>
						<?php } ?>
                        
						<?php $features_list = $settings['features_list'];
                            if(!empty($features_list)){
                            $features_list = explode("\n", ($features_list)); 
                        ?>
                        <ul class="list-style-two">
                        	<?php foreach($features_list as $features): ?>
                            <li><?php echo wp_kses($features, true); ?></li>
                        	<?php endforeach; ?>
                        </ul>
                        <?php } ?>
						<?php if($settings['signature_img']['id']){ ?>
						<!-- Signature -->
						<div class="signature">
							<img src="<?php echo esc_url(wp_get_attachment_url($settings['signature_img']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'nitech'); ?>">
						</div>
						<?php } ?>
						
                        <?php if($settings['icons2']){ ?>
                        <!-- Year Box Outer -->
						<div class="year-box-outer">
							<div class="icon-box">
								<div class="icon <?php echo wp_kses(str_replace( "icon ",  "", $settings['icons2']), true); ?>"></div>
							</div>
							<div class="year-box-inner">
								<div class="year-count-outer year-count-box count-box">
									<span class="count-text year-count-text" data-speed="4000" data-stop="<?php echo esc_attr($settings['counter_stop1']);?>"><?php echo esc_attr($settings['counter_start1']);?></span>
									<?php echo wp_kses($settings['since_text'], true); ?>
								</div>
							</div>
						</div>
						<!-- End Year Box Outer -->
						<?php } ?>
					</div>
				</div>
				<!-- Image Column -->
				<div class="image-column col-lg-6 col-md-12 col-sm-12">
					<div class="inner-column">
						<!-- Blocks Outer -->
						<div class="blocks-outer">
							<div class="row clearfix">
								<?php foreach($settings['slides'] as $key => $item):?>
								<!-- Feature Block Two -->
								<div class="feature-block-two col-lg-6 col-md-6 col-sm-12">
									<div class="inner-box">
										<div class="<?php echo esc_attr($item['icons']);?>"></div>
										<h6><?php echo wp_kses($item['block_title'], true); ?></h6>
										<div class="text"><?php echo wp_kses($item['block_text'], true); ?></div>
									</div>
								</div>
								<?php endforeach;?>
							</div>
						</div>
						<?php if($settings['about_image1']['id'] || $settings['pattern_image1']['id']){ ?>
                        <!-- End Blocks Outer -->
						<div class="image">
							<?php if($settings['about_image1']['id']){ ?><img src="<?php echo esc_url(wp_get_attachment_url($settings['about_image1']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'nitech'); ?>"><?php } ?>
							<?php if($settings['pattern_image1']['id']){ ?><div class="pattern-layer" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['pattern_image1']['id'])); ?>)"></div><?php } ?>
						</div>
                        <?php } ?>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- End About Section Three -->
		
    <?php 
	
	}

}