<?php

namespace NITECHPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Coming_Soon extends Widget_Base
{

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'nitech_coming_soon';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title()
    {
        return esc_html__('Coming Soon', 'nitech');
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'eicon-library-open';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return [ 'nitech' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls()
    {
        $this->start_controls_section(
            'coming_soon',
            [
                'label' => esc_html__('Coming Soon', 'nitech'),
            ]
        );
		$this->add_control(
			'bg_img',
				[
				  'label' => __( 'Background Image', 'nitech' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
	    );
		$this->add_control(
			'logo_img',
				[
				  'label' => __( 'Logo Image', 'nitech' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
	    );
		$this->add_control(
			'counter_value',
			[
				'label'       => __( 'Counter Value', 'nitech' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Counter Value', 'nitech' ),
				'default' => esc_html__('2022/12/1', 'nitech'),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'nitech' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Text', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text', 'nitech' ),
			]
		);
		$this->add_control(
			'form_id',
			[
				'label'       => __( 'MailChimp Form Url', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your MailChimp Form Url', 'nitech' )
			]
		);
		$this->add_control(
              'social_icon', 
			  	[
            		'type' => Controls_Manager::REPEATER,
            		'seperator' => 'before',
            		'default' => 
						[
                			['social_link' => esc_html__('https://www.facebook.com/', 'nitech')],
                			['social_link' => esc_html__('https://www.twitter.com/', 'nitech')],
                			['social_link' => esc_html__('https://www.linkedin.com/', 'nitech')]
            			],
            		'fields' => 
						[
                			[
                    			'name' => 'icons',
                    			'label' => esc_html__('Enter The icons', 'nitech'),
								'label_block' => true,
                    			'type' => Controls_Manager::SELECT2,
                    			'options'  => get_fontawesome_icons(),
                			],
							[
                    			'name' => 'social_link',
								'label' => __( 'Social Url', 'nitech' ),
							    'type' => Controls_Manager::URL,
							    'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
							    'show_external' => true,
							    'default' => ['url' => '','is_external' => true,'nofollow' => true,],
                			],
            			],
            	    'title_field' => '{{social_link}}',
                 ]
        );
		$this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post'); ?>
		
        <!-- Coming Soon -->
        <section class="coming-soon" <?php if($settings['bg_img']['id']) { ?>style="background-image: url(<?php echo wp_get_attachment_url($settings['bg_img']['id']);?>);"<?php } ?>>
            <div class="content">
                <div class="content-inner">
                    <div class="auto-container">
                        <?php if($settings['logo_img']['id']) { ?><div class="logo"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo wp_get_attachment_url($settings['logo_img']['id']);?>" alt="<?php esc_attr_e('Awesome Image', 'nitech'); ?>" /></a></div><?php } ?>
                        <div class="sec-title"><h2><?php esc_html_e('Coming Soon', 'nitech'); ?></h2></div>
                        <div class="time-counter">
                            <!-- Time Countdown -->
                            <div class="time-countdown clearfix" data-countdown="<?php echo esc_attr( $settings['counter_value'] );?>"></div>
    
                            <!-- Clock / Bg Clock -->
                            <div class="clock-wrapper">
                                <div class="clock-base">
                                    <div class="click-indicator">
                                        <div><span></span></div>
                                        <div><span></span></div>
                                        <div><span></span></div>
                                        <div><span></span></div>
                                        <div><span></span></div>
                                        <div><span></span></div>
                                        <div><span></span></div>
                                        <div><span></span></div>
                                        <div><span></span></div>
                                        <div><span></span></div>
                                        <div><span></span></div>
                                        <div><span></span></div>
                                    </div>
                                    <div class="clock-hour"></div>
                                    <div class="clock-minute"></div>
                                    <div class="clock-second"></div>
                                    <div class="clock-center"></div>
                                </div>
                            </div>
                        </div>
                        <!--Emailed Form-->
                        <div class="emailed-form">
                            <h3><?php echo wp_kses( $settings['title'], true );?></h3>
                            <div class="text"><?php echo wp_kses( $settings['text'], true );?></div>
                            <?php echo do_shortcode( $settings['form_id'] );?>
                        </div>
                        <ul class="social-box">
                            <?php foreach($settings['social_icon'] as $item):?>
                            <li><a href="<?php echo esc_url($item['social_link']['url']); ?>" class="fab <?php echo esc_attr($item['icons']); ?>"></a></li>
                            <?php endforeach;?>
                        </ul>
                    </div>
                </div>
            </div>
        </section>
        <!-- End Coming Soon -->
                                        
		<?php
    }
}
