<?php

namespace NITECHPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Contact_Info extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'nitech_contact_info';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Contact Info', 'nitech' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'nitech' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'contact_info',
				[
					'label' => esc_html__( 'Contact Info', 'nitech' ),
				]
		);
		$this->add_control(
			'sub_title',
			[
				'label'       => __( 'Sub Title', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title Here', 'nitech' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'nitech' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Text', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text Here', 'nitech' ),
			]
		);
		$this->add_control(
                'slides', 
				[
						'type' => Controls_Manager::REPEATER,
						'separator' => 'before',
						'default' => 
					[
						['block_title' => esc_html__('Address:', 'nitech')],
						['block_title' => esc_html__('Phone:', 'nitech')],
						['block_title' => esc_html__('Email:', 'nitech')]
					],
				'fields' => 
					[
						[
							'name' => 'icons',
							'label' => esc_html__('Select Icon', 'nitech'),
							'label_block' => true,
							'type' => Controls_Manager::SELECT2,
							'options' => get_fontawesome_icons(),
						],
						[
							'name' => 'block_title',
							'label' => esc_html__('Block Title', 'nitech'),
							'label_block' => true,
							'type' => Controls_Manager::TEXT,
							'default' => esc_html__('', 'nitech')
						],
						[
							'name' => 'block_text',
							'label' => esc_html__('Block Text', 'nitech'),
							'label_block' => true,
							'type' => Controls_Manager::TEXTAREA,
							'default' => esc_html__('', 'nitech')
						],
					],
					'title_field' => '{{block_title}}',
				]	
        );
		$this->add_control(
			'chat_text',
			[
				'label'       => __( 'Section Bottom Description', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'nitech' ),
			]
		);
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>

	<!-- Contact Page Section -->
	<section class="contact-page-section">
		<div class="auto-container">
			<?php if($settings['sub_title'] || $settings['title'] || $settings['text']){ ?>
            <!-- Sec Title / Style Four -->
			<div class="sec-title style-four centered">
				<?php if($settings['sub_title']){ ?><div class="title"><?php echo wp_kses($settings['sub_title'], true); ?></div><?php } ?>
				<?php if($settings['title']){ ?><h2><?php echo wp_kses($settings['title'], true); ?></h2><?php } ?>
				<?php if($settings['text']){ ?><div class="text"><?php echo wp_kses($settings['text'], true); ?></div><?php } ?>
			</div>
            <?php } ?>
			<div class="row clearfix">
				
				<?php foreach($settings['slides'] as $key => $item): ?>
				<!-- Info Column -->
				<div class="info-column col-lg-4 col-md-6 col-sm-12">
					<div class="inner-column">
						<div class="content">
							<div class="icon <?php echo esc_attr(str_replace( "icon ",  "", $item['icons']));?>"></div>
							<strong><?php echo wp_kses($item['block_title'], true); ?>:</strong>
							<div class="text"><?php echo wp_kses($item['block_text'], true); ?></div>
						</div>
					</div>
				</div>
				<?php endforeach; ?>
			</div>
			<?php if($settings['chat_text']){ ?>
            <!-- Lower Text -->
			<div class="lower-text"><?php echo wp_kses($settings['chat_text'], true); ?></div>
			<?php } ?>
		</div>
	</section>
	
	<!-- End Contact Page Section -->
		
    <?php 
	
	}

}