<?php

namespace NITECHPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Contact_Us extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'nitech_contact_us';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Contact Us', 'nitech' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'nitech' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'contact_us',
				[
					'label' => esc_html__( 'Contact Us', 'nitech' ),
				]
		);
		$this->add_control(
			'contact_image',
				[
				  'label' => __( 'Contact Form Image', 'nitech' ),
				  'type' => Controls_Manager::MEDIA,
				  'label_block' => true,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
	    );
		$this->add_control(
			'pattern_image',
				[
				  'label' => __( 'Contact Form Pattern Image', 'nitech' ),
				  'type' => Controls_Manager::MEDIA,
				  'label_block' => true,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
	    );
		$this->add_control(
			'sub_title',
			[
				'label'       => __( 'Sub Title', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Tilte Here', 'nitech' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Tilte Here', 'nitech' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Text', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text Here', 'nitech' ),
			]
		);
		$this->add_control(
			'author_image',
				[
				  'label' => __( 'Author Image', 'nitech' ),
				  'type' => Controls_Manager::MEDIA,
				  'label_block' => true,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
	    );
		$this->add_control(
			'question_text',
			[
				'label'       => __( 'Question Text', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Question Text Here', 'nitech' ),
			]
		);
		$this->add_control(
			'phone_no',
			[
				'label'       => __( 'Phone Number', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your phone no. Here', 'nitech' ),
			]
		);
		$this->add_control(
			'working_hours',
			[
				'label'       => __( 'Working Time', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your working day Here', 'nitech' ),
			]
		);
		$this->add_control(
			'call_back',
			[
				'label'       => __( 'Call Back', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Call Back Here', 'nitech' ),
			]
		);
		$this->add_control(
            'call_back_link',
			[
				'label' => __( 'External Url', 'nitech' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
        );
		$this->add_control(
			'contact_sub_title',
			[
				'label'       => __( 'Form Sub Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Form Sub Tilte Here', 'nitech' ),
			]
		);
		$this->add_control(
			'contact_title',
			[
				'label'       => __( 'Form Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Form Title Here', 'nitech' ),
			]
		);
		$this->add_control(
           'contact_us_form3',
			[
				'label'       => __( 'Contact Form 7 Url', 'nitech' ),
                'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
                'active' => true,
				],
                'placeholder' => __( 'Enter your Contact Form 7 Url', 'nitech' )
			]
		);
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>

	<!-- Contact Form Section -->
	<section class="contact-form-section" <?php if($settings['contact_image']['id']){ ?>style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['contact_image']['id'])); ?>)"<?php } ?>>
		<?php if($settings['pattern_image']['id']){ ?><div class="pattern-layer" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['pattern_image']['id'])); ?>)"></div><?php } ?>
		<div class="auto-container">
			<div class="row clearfix">
			
				<!-- Info Column -->
				<div class="info-column col-lg-6 col-md-12 col-sm-12">
					<div class="inner-column">
						<?php if($settings['sub_title'] || $settings['title'] || $settings['text']){ ?>
                        <!-- Sec Title / Style Four -->
						<div class="sec-title style-four">
							<?php if($settings['sub_title']){ ?><div class="title"><?php echo wp_kses($settings['sub_title'], true); ?></div><?php } ?>
							<?php if($settings['title']){ ?><h2><?php echo wp_kses($settings['title'], true); ?></h2><?php } ?>
							<?php if($settings['text']){ ?><div class="text"><?php echo wp_kses($settings['text'], true); ?></div><?php } ?>
						</div>
						<?php } ?>
                        <!-- Phone Box -->
						<div class="phone-box">
							<div class="box-inner">
								<?php if($settings['author_image']['id']){ ?>
                                <div class="author-image">
									<img src="<?php echo esc_url(wp_get_attachment_url($settings['author_image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'nitech'); ?>" />
								</div>
								<?php } ?>
								
								<?php echo wp_kses($settings['question_text'], true); ?><br>
								
								<?php if($settings['phone_no']){ ?>
                                <a href="tel:<?php echo esc_attr($settings['phone_no']);?>"><?php echo wp_kses($settings['phone_no'], true); ?></a>
								<?php } ?>
                            </div>
						</div>
                        
						<?php if($settings['working_hours']){ ?>
						<div class="timing"><?php echo wp_kses($settings['working_hours'], true); ?></div>
                        <?php } ?>
						
						<?php if($settings['call_back_link']['url']){ ?>
						<a href="<?php echo esc_url($settings['call_back_link']['url']); ?>" class="call-back"><?php echo wp_kses($settings['call_back'], true); ?></a>
                        <?php } ?>
					</div>
				</div>
				
				<!-- Form Column -->
				<div class="form-column col-lg-6 col-md-12 col-sm-12">
					<div class="inner-column">
						<?php if($settings['contact_sub_title'] || $settings['contact_title']){ ?>
                        <!-- Sec Title / Style Three -->
						<div class="sec-title style-three">
							<?php if($settings['contact_sub_title']){ ?><div class="title"><?php echo wp_kses($settings['contact_sub_title'], true); ?></div><?php } ?>
							<?php if($settings['contact_title']){ ?><h2><?php echo wp_kses($settings['contact_title'], true); ?></h2><?php } ?>
						</div>
						<?php } ?>
                        <?php if($settings['contact_us_form3']){ ?>
                        <!-- Default Form / Style Two -->
						<div class="default-form style-two contact-form">
							<?php echo do_shortcode( $settings['contact_us_form3'] );?>
                        </div>
                        <?php } ?>
					</div>
				</div>
				
			</div>
		</div>
	</section>
	<!-- End Contact Form Section -->
		
    <?php 
	
	}

}