<?php

namespace NITECHPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Contact_Us_V2 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'nitech_contact_us_v2';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Contact Us V2', 'nitech' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'nitech' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'contact_us_v2',
				[
					'label' => esc_html__( 'Contact Us V2', 'nitech' ),
				]
		);
		$this->add_control(
			'contact_image',
				[
				  'label' => __( 'Contact Form Image', 'nitech' ),
				  'type' => Controls_Manager::MEDIA,
				  'label_block' => true,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
	    );
		$this->add_control(
			'contact_sub_title',
			[
				'label'       => __( 'Contact Sub Title', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Contact Sub Tilte Here', 'nitech' ),
			]
		);
		$this->add_control(
			'contact_title',
			[
				'label'       => __( 'Contact Title', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Contact Title Here', 'nitech' ),
			]
		);
		$this->add_control(
           'contact_us_form4',
			[
				'label'       => __( 'Contact Form 7 Url', 'nitech' ),
                'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
                'active' => true,
				],
                'placeholder' => __( 'Enter your Contact Form 7 Url', 'nitech' )
			]
		);
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>

	<!-- Contact Form Section Two -->
	<section class="contact-form-section-two">
		<?php if($settings['contact_image']['id']){ ?><div class="pattern-layer" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['contact_image']['id'])); ?>)"></div><?php } ?>
		<div class="auto-container">
			
			<!-- Form Column -->
			<div class="form-boxed">
				<?php if($settings['contact_sub_title'] || $settings['contact_title']){ ?>
				<!-- Sec Title / Style Three -->
				<div class="sec-title style-three">
					<?php if($settings['contact_sub_title']){ ?><div class="title"><?php echo wp_kses($settings['contact_sub_title'], true); ?></div><?php } ?>
					<?php if($settings['contact_title']){ ?><h2><?php echo wp_kses($settings['contact_title'], true); ?></h2><?php } ?>
				</div>
                <?php } ?>
                <?php if($settings['contact_us_form4']){ ?>
				<!-- Default Form / Style Two -->
				<div class="default-form style-two contact-form">
					<?php echo do_shortcode( $settings['contact_us_form4'] );?>
				</div>
				<?php } ?>
			</div>
			
		</div>
	</section>
	
	<!-- End Contact Form Section -->
		
    <?php 
	
	}

}