<?php
namespace NITECHPLUGIN\Element;
use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;
/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Default_Section extends Widget_Base {
	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'nitech_default_section';
	}
	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Default Section', 'nitech' );
	}
	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}
	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'nitech' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'default_section',
			[
				'label' => esc_html__( 'Default Section', 'nitech' ),
			]
		);
		$this->add_control(
			'sub_title',
			[
				'label'       => __( 'Sub Title', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'nitech' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'nitech' ),
			]
		);
		$this->add_control(
			'signature_image',
				[
				  'label' => __( 'Signature Image', 'nitech' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
	    );
		$this->add_control(
			'text',
			[
				'label'       => __( 'Text', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text Here', 'nitech' ),
			]
		);
		$this->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'nitech' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 4,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'nitech' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'nitech' ),
					'title'      => esc_html__( 'Title', 'nitech' ),
					'menu_order' => esc_html__( 'Menu Order', 'nitech' ),
					'rand'       => esc_html__( 'Random', 'nitech' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'nitech' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESC' => esc_html__( 'DESC', 'nitech' ),
					'ASC'  => esc_html__( 'ASC', 'nitech' ),
				),
			]
		);
		$this->add_control(
            'query_category', 
				[
				  'type' => Controls_Manager::SELECT,
				  'label' => esc_html__('Category', 'nitech'),
				  'label_block' => true,
				  'options' => get_testimonials_categories()
				]
		);
		$this->add_control(
			'form_sub_title',
			[
				'label'       => __( 'Form Sub Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Form Sub Tilte Here', 'nitech' ),
			]
		);
		$this->add_control(
			'form_title',
			[
				'label'       => __( 'Form Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Form Title Here', 'nitech' ),
			]
		);
		$this->add_control(
           'contact_us_form2',
			[
				'label'       => __( 'Contact Form 7 Url', 'nitech' ),
                'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
                'active' => true,
				],
                'placeholder' => __( 'Enter your Contact Form 7 Url', 'nitech' )
			]
		);
		$this->end_controls_section();
	}
	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		
        $paged = nitech_set($_POST, 'paged') ? esc_attr($_POST['paged']) : 1;
		
		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-nitech' );
		$args = array(
			'post_type'      =>  'testimonials',
			'posts_per_page' => nitech_set( $settings, 'query_number' ),
			'orderby'        => nitech_set( $settings, 'query_orderby' ),
			'order'          => nitech_set( $settings, 'query_order' ),
			'paged'         => $paged
		);
		if( nitech_set( $settings, 'query_category' ) ) $args['testimonials_cat'] = nitech_set( $settings, 'query_category' );
		$query = new \WP_Query( $args );
		if ( $query->have_posts() ) 
		{ ?>


	<!-- Default Section -->
	<section class="default-section" style="background-image:url(<?php echo esc_url(get_template_directory_uri());?>/assets/images/background/pattern-26.png)">
		<div class="pattern-layer" style="background-image:url(<?php echo esc_url(get_template_directory_uri());?>/assets/images/background/pattern-27.png)"></div>
		<div class="auto-container">
			<div class="row clearfix">
			
				<!-- Carousel Column -->
				<div class="carousel-column col-lg-6 col-md-12 col-sm-12">
					<div class="inner-column">
						<?php if($settings['sub_title'] || $settings['title'] || $settings['signature_image']['id']){ ?>
                        <!-- Sec Title / Style Three -->
						<div class="sec-title style-three">
							<?php if($settings['sub_title']){ ?><div class="title"><?php echo wp_kses($settings['sub_title'], true); ?></div><?php } ?>
							<?php if($settings['title']){ ?><h2><?php echo wp_kses($settings['title'], true); ?></h2><?php } ?>
							<?php if($settings['signature_image']['id']){ ?><div class="signature"><img src="<?php echo esc_url(wp_get_attachment_url($settings['signature_image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'nitech'); ?>"></div><?php } ?>
						</div>
                        <?php } ?>
						<?php if($settings['text']){ ?><div class="bold-text"><?php echo wp_kses($settings['text'], true); ?></div><?php } ?>
						<div class="single-item-carousel owl-carousel owl-theme">
							<?php while ( $query->have_posts() ) : $query->the_post(); ?>
							<!-- Testimonial Block Two -->
							<div class="testimonial-block-two">
								<div class="inner-box">
									<div class="pattern-layer-two" style="background-image:url(<?php echo esc_url(get_template_directory_uri());?>/assets/images/background/pattern-28.png)"></div>
									<div class="pattern-layer-three" style="background-image:url(<?php echo esc_url(get_template_directory_uri());?>/assets/images/background/pattern-29.png)"></div>
									<div class="quote-icon flaticon-quote"></div>
									<div class="author-thumb">
										<?php the_post_thumbnail('nitech_84x84'); ?>
									</div>
									<div class="text"><?php echo wp_kses(nitech_trim(get_the_content(), $settings['text_limit']), true); ?></div>
									<div class="designation"><?php echo (get_post_meta( get_the_id(), 'designation', true ));?></div>
								</div>
							</div>
							<?php endwhile; ?>
						</div>
					</div>
				</div>
				
				<!-- Form Column -->
				<div class="form-column col-lg-6 col-md-12 col-sm-12">
					<div class="inner-column">
						<?php if($settings['form_sub_title'] || $settings['form_title']){ ?>
                        <!-- Sec Title / Style Three -->
						<div class="sec-title style-three">
							<?php if($settings['form_sub_title']){ ?><div class="title"><?php echo wp_kses($settings['form_sub_title'], true); ?></div><?php } ?>
							<?php if($settings['form_title']){ ?><h2><?php echo wp_kses($settings['form_title'], true); ?></h2><?php } ?>
						</div>
                        <?php } ?>
                        <?php if($settings['contact_us_form2']){ ?>
						<!-- Default Form / Style Two -->
						<div class="default-form style-two">
							<?php echo do_shortcode( $settings['contact_us_form2'] );?>
                        </div>
                        <?php } ?>
					</div>
				</div>
				
			</div>
		</div>
	</section>
	<!-- End Default Section -->
      	
		<?php }
		wp_reset_postdata();
	}
}