<?php namespace NITECHPLUGIN\Element;

class Elementor {
	static $widgets = array(
	
		//Home Page 01
		'slider_v1',
		'about_us',
		'services_v1',
		'call_to_action',
		'our_projects_v1',
		'our_testimonials_v1',
		'technology_section',
		'our_team',
		'funfacts',
		'latest_news_v1',
		'our_clients',
		'call_to_action_v2',
		
		//Home Page 02
		'slider_v2',
		'about_us_v2',
		'services_v2',
		'business_section',
		'call_to_action_v3',
		'our_projects_v2',
		'faq_section',
		'pricing_section',
		'latest_news_v2',
		'quote_form_info',
		'call_to_action_v5',
		
		//Home Page 03
		'slider_v3',
		'about_us_v3',
		'funfacts_v2',
		'services_v3',
		'our_team_v2',
		'default_section',
		'latest_news_v3',
		'software_section',
		
		//Inner Pages		
		'pricing_section_v2',
		'call_to_action_v4',
		'faq_section_v2',
		'team_details',
		'our_testimonials_v2',
		'coming_soon',
		'services_v4',
		'services_single',
		'our_projects_v3',
		'our_projects_v4',
		'our_projects_v5',
		'project_detail',
		'latest_news_v4',
		'contact_info',
		'contact_us',
		'google_map',
		'contact_us_v2',
		'map_contact_info',
		'team_details_v2',
		'project_detail_v1',
		
		
	);

	static function init() {
		add_action( 'elementor/init', array( __CLASS__, 'loader' ) );
		add_action( 'elementor/elements/categories_registered', array( __CLASS__, 'register_cats' ) );
	}

	static function loader() {

		foreach ( self::$widgets as $widget ) {

			$file = NITECHPLUGIN_PLUGIN_PATH . '/elementor/' . $widget . '.php';
			if ( file_exists( $file ) ) {
				require_once $file;
			}

			add_action( 'elementor/widgets/widgets_registered', array( __CLASS__, 'register' ) );
		}
	}

	static function register( $elemntor ) {
		foreach ( self::$widgets as $widget ) {
			$class = '\\NITECHPLUGIN\\Element\\' . ucwords( $widget );

			if ( class_exists( $class ) ) {
				$elemntor->register_widget_type( new $class );
			}
		}
	}

	static function register_cats( $elements_manager ) {

		$elements_manager->add_category(
			'nitech',
			[
				'title' => esc_html__( 'Nitech', 'nitech' ),
				'icon'  => 'fa fa-plug',
			]
		);
		$elements_manager->add_category(
			'templatepath',
			[
				'title' => esc_html__( 'Template Path', 'nitech' ),
				'icon'  => 'fa fa-plug',
			]
		);

	}
}

Elementor::init();