<?php

namespace NITECHPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;
/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Faq_Section extends Widget_Base {
	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'nitech_faq_section';
	}
	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Faq Section', 'nitech' );
	}
	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}
	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'nitech' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'faq_section',
			[
				'label' => esc_html__( 'FAQ Section', 'nitech' ),
			]
		);
		$this->add_control(
			'faq_image1',
				[
				  'label' => __( 'FAQ Image One', 'nitech' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
	    );
		$this->add_control(
			'pattern_image',
				[
				  'label' => __( 'Pattern Image', 'nitech' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
	    );
		$this->add_control(
			'faq_image2',
				[
				  'label' => __( 'FAQ Image Two', 'nitech' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
	    );
		$this->add_control(
			'sub_title',
			[
				'label'       => __( 'Sub Title', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'nitech' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'nitech' ),
			]
		);
		$this->add_control(
                'slides', 
				[
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'default' => 
					[
						['faq_title' => esc_html__('What does you do?', 'nitech')],
						['faq_title' => esc_html__('What industries covered?', 'nitech')],
						['faq_title' => esc_html__('How long does IT Solution takes to complete?', 'nitech')],
						['faq_title' => esc_html__('How do you price?', 'nitech')]
					],
				'fields' => 
					[

						[
							'name' => 'faq_title',
							'label' => esc_html__('FAQ Title', 'nitech'),
							'label_block' => true,
							'type' => Controls_Manager::TEXTAREA,
							'default' => esc_html__('', 'nitech')
						],
						[
							'name' => 'faq_text',
							'label' => esc_html__('FAQ Text', 'nitech'),
							'label_block' => true,
							'type' => Controls_Manager::TEXTAREA,
							'default' => esc_html__('', 'nitech')
						],
					],
					'title_field' => '{{faq_title}}',
				]
        );
		
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>


	<!-- Faq Section -->
	<section class="faq-section">
		<div class="auto-container">
			<div class="row clearfix">
				<?php if($settings['faq_image1']['id'] || $settings['faq_image2']['id']){ ?>
				<!-- Image Column -->
				<div class="image-column col-lg-6 col-md-12 col-sm-12">
					<div class="inner-column">
						<?php if($settings['faq_image1']['id']){ ?>
                        <div class="image">
							<img src="<?php echo esc_url(wp_get_attachment_url($settings['faq_image1']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'nitech'); ?>" />
							<div class="pattern-layer" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['pattern_image']['id'])); ?>)"></div>
						</div>
                        <?php } ?>
                        <?php if($settings['faq_image2']['id']){ ?>
						<div class="image-two">
							<img src="<?php echo esc_url(wp_get_attachment_url($settings['faq_image2']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'nitech'); ?>" />
						</div>
                        <?php } ?>
					</div>
				</div>
				<?php } ?>
                
				<!-- Accordion Column -->
				<div class="accordion-column col-lg-6 col-md-12 col-sm-12">
					<div class="inner-column">
						<?php if($settings['sub_title'] || $settings['title']){ ?>
                        <!-- Sec Title / Style Two -->
						<div class="sec-title style-two">
							<?php if($settings['sub_title']){ ?><div class="title"><?php echo wp_kses($settings['sub_title'], true); ?></div><?php } ?>
							<?php if($settings['title']){ ?><h2><?php echo wp_kses($settings['title'], true); ?></h2><?php } ?>
						</div>
						<?php } ?>
						<!-- Accordian Box -->
						<ul class="accordion-box">
							<?php
								$count = 1; 
								foreach($settings['slides'] as $key => $item):
							?>
							<!--Block-->
							<li class="accordion block <?php if($count == 2) echo 'active-block'?>">
								<div class="acc-btn <?php if($count == 2) echo 'active'?>"><div class="icon-outer"><span class="icon icon-plus fa fa-plus"></span> <span class="icon icon-minus fa fa-minus"></span></div><?php echo wp_kses($item['faq_title'], true); ?></div>
								<div class="acc-content <?php if($count == 2) echo 'current'?>">
									<div class="content">
										<div class="text"><?php echo wp_kses($item['faq_text'], true); ?></div>
									</div>
								</div>
							</li>
							<?php $count++; endforeach;?>
						</ul>
						
					</div>
				</div>
				
			</div>
		</div>
	</section>
	
	<!-- End Faq Section -->
		
    <?php 
	
	}

}