<?php

namespace NITECHPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;
/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Faq_Section_V2 extends Widget_Base {
	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'nitech_faq_section_v2';
	}
	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Faq Section V2', 'nitech' );
	}
	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}
	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'nitech' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'faq_section_v2',
			[
				'label' => esc_html__( 'FAQ Section V2', 'nitech' ),
			]
		);
		$this->add_control(
			'icons',
			[
				'label' => esc_html__('Select Icon', 'nitech'),
				'label_block' => true,
				'type' => Controls_Manager::SELECT2,
				'options' => get_fontawesome_icons(),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'nitech' ),
			]
		);
		$this->add_control(
            'sow_search_form',
			[
				'label' => __( 'Enable/Disable Search Form', 'nitech' ),
				'type'     => Controls_Manager::SWITCHER,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enable/Disable Search Form', 'nitech' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Text and Phone No.', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text and Phone No.', 'nitech' ),
			]
		);
		$this->add_control(
                'slides1', 
				[
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'default' => 
					[
						['faq_title1' => esc_html__('How do you answer information technology questions?', 'nitech')],
						['faq_title1' => esc_html__('What are some questions about technology?', 'nitech')],
						['faq_title1' => esc_html__('What is information technology very short answer?', 'nitech')],
						['faq_title1' => esc_html__('What is information technology PDF?', 'nitech')]
					],
				'fields' => 
					[
						[
							'name' => 'faq_title1',
							'label' => esc_html__('FAQ Title', 'nitech'),
							'label_block' => true,
							'type' => Controls_Manager::TEXTAREA,
							'default' => esc_html__('', 'nitech')
						],
						[
							'name' => 'faq_text1',
							'label' => esc_html__('FAQ Text', 'nitech'),
							'label_block' => true,
							'type' => Controls_Manager::TEXTAREA,
							'default' => esc_html__('', 'nitech')
						],
					],
					'title_field' => '{{faq_title1}}',
				]
        );
		$this->add_control(
		'slides2', 
				[
				'type' => Controls_Manager::REPEATER,
				'separator' => 'before',
				'default' => 
				[
					['faq_title2' => esc_html__('What are the basics of information technology?', 'nitech')],
					['faq_title2' => esc_html__('What are IT basics?', 'nitech')],
					['faq_title2' => esc_html__('What are IT basic skills?', 'nitech')],
					['faq_title2' => esc_html__('What are the IT skills?', 'nitech')]
				],
			'fields' => 
				[
					[
						'name' => 'faq_title2',
						'label' => esc_html__('FAQ Title', 'nitech'),
						'label_block' => true,
						'type' => Controls_Manager::TEXTAREA,
						'default' => esc_html__('', 'nitech')
					],
					[
						'name' => 'faq_text2',
						'label' => esc_html__('FAQ Text', 'nitech'),
						'label_block' => true,
						'type' => Controls_Manager::TEXTAREA,
						'default' => esc_html__('', 'nitech')
					],
				],
				'title_field' => '{{faq_title2}}',
			]
        );
		
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>

	<!-- Faq Page Section -->
	<section class="faq-page-section">
		<div class="auto-container">
			<!-- Upper Box -->
			<div class="upper-box">
				<?php if($settings['icons']){ ?><div class="icon <?php echo wp_kses(str_replace( "icon ",  "", $settings['icons']), true); ?>"></div><?php } ?>
				<?php if($settings['title']){ ?><h2><?php echo wp_kses($settings['title'], true); ?></h2><?php } ?>
				<?php if($settings['sow_search_form']){ ?>
                <!-- Faq Form -->
				<div class="faq-form">
					<form action="<?php echo esc_url( home_url( '/' ) ); ?>" method="get">
						<div class="form-group">
							<input type="text" name="s" value="<?php echo esc_attr(get_search_query()); ?>" placeholder="<?php echo esc_attr__( 'Search...', 'nitech' ); ?>" required>
							<button type="submit"><span class="flaticon-search"></span></button>
						</div>
					</form>
				</div>
                <?php } ?>
				<?php if($settings['text']){ ?><div class="question"><?php echo wp_kses($settings['text'], true); ?> </div><?php } ?>
			</div>
			<!-- End Upper Box -->
			<div class="row clearfix">
				
				<!-- Column -->
				<div class="column col-lg-6 col-md-12 col-sm-12">
					
					<!-- Accordian Box / Style Two -->
					<ul class="accordion-box style-two">
						<?php 
							$count = 1; 
							foreach($settings['slides1'] as $keys => $items):
						?>
						<!--Block-->
						<li class="accordion block <?php if($count == 2) echo 'active-block'?>">
							<div class="acc-btn <?php if($count == 2) echo 'active'?>"><div class="icon-outer"><span class="icon icon-plus fa fa-plus"></span> <span class="icon icon-minus fa fa-minus"></span></div><?php echo wp_kses($items['faq_title1'], true); ?></div>
							<div class="acc-content <?php if($count == 2) echo 'current'?>">
								<div class="content">
									<div class="text"><?php echo wp_kses($items['faq_text1'], true); ?></div>
								</div>
							</div>
						</li>
						<?php $count++; endforeach;?>
					</ul>
					
				</div>
				
				<!-- Column -->
				<div class="column col-lg-6 col-md-12 col-sm-12">
					<!-- Accordian Box / Style Two -->
					<ul class="accordion-box style-two">
						<?php foreach($settings['slides2'] as $key => $item):?>
						<!--Block-->
						<li class="accordion block">
							<div class="acc-btn"><div class="icon-outer"><span class="icon icon-plus fa fa-plus"></span> <span class="icon icon-minus fa fa-minus"></span></div><?php echo wp_kses($item['faq_title2'], true); ?></div>
							<div class="acc-content">
								<div class="content">
									<div class="text"><?php echo wp_kses($item['faq_text2'], true); ?></div>
								</div>
							</div>
						</li>
						<?php endforeach;?>
					</ul>
				</div>
				
			</div>
		</div>
	</section>
	
	<!-- End Faq Page Section -->
		
    <?php 
	
	}

}