<?php

namespace NITECHPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Funfacts_V2 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'nitech_funfacts_v2';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Funfacts V2', 'nitech' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'nitech' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'funfacts_v2',
				[
					'label' => esc_html__( 'Funfacts V2', 'nitech' ),
				]
		);
		$this->add_control(
			'funfact_bg_img1',
				[
				  'label' => __( 'Funfacts BG Image One', 'nitech' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
	    );
		$this->add_control(
			'sub_title',
			[
				'label'       => __( 'Sub Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title Here', 'nitech' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'nitech' ),
			]
		);
		$this->add_control(
                'slides', 
				[
						'type' => Controls_Manager::REPEATER,
						'separator' => 'before',
						'default' => 
					[
						['block_title' => esc_html__('Delivered Goods', 'nitech')],
						['block_title' => esc_html__('IT Consultant', 'nitech')],
						['block_title' => esc_html__('Project Complete', 'nitech')],
						['block_title' => esc_html__('Fully Launched', 'nitech')]
					],
				'fields' => 
					[
						[
							'name' => 'icons',
							'label' => esc_html__('Select Icon', 'nitech'),
							'label_block' => true,
							'type' => Controls_Manager::SELECT2,
							'options' => get_fontawesome_icons(),
						],
						[
							'name' => 'counter_start',
							'label' => esc_html__('Counter Start', 'nitech'),
							'label_block' => true,
							'type' => Controls_Manager::TEXT,
						],
						[
							'name' => 'counter_stop',
							'label' => esc_html__('Counter Stop', 'nitech'),
							'type' => Controls_Manager::TEXT,
							'label_block' => true,
						],
						[
							'name' => 'alphabet_letter',
							'label' => esc_html__('Alphabet Letter', 'nitech'),
							'type' => Controls_Manager::TEXT,
							'label_block' => true,
						],
						[
							'name' => 'block_title',
							'label' => esc_html__('Block Title', 'nitech'),
							'label_block' => true,
							'type' => Controls_Manager::TEXT,
							'default' => esc_html__('Enter Title Here', 'nitech')
						],
					],
            	'title_field' => '{{block_title}}',
			]
        );
		$this->add_control(
			'icons2',
			[
				'label' => esc_html__('Select Icon', 'nitech'),
				'label_block' => true,
				'type' => Controls_Manager::SELECT2,
				'options' => get_fontawesome_icons(),
			]
		);
		$this->add_control(
			'counter_start1',
			[
				'label'       => __( 'Counter Start', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( '', 'nitech' ),
			]
		);
		$this->add_control(
			'counter_stop1',
			[
				'label'       => __( 'Counter Stop', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( '', 'nitech' ),
			]
		);
		$this->add_control(
			'alphabet_letter1',
			[
				'label'       => __( 'Alphabet Letter', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( '', 'nitech' ),
			]
		);
		$this->add_control(
			'story_text',
			[
				'label'       => __( 'Story Text', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text', 'nitech' ),
			]
		);
		
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>

	<!-- Counter Section -->
	<section class="counter-section-two" <?php if($settings['funfact_bg_img1']['id']){ ?>style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['funfact_bg_img1']['id'])); ?>)"<?php } ?>>
		<div class="auto-container">
			<?php if($settings['sub_title'] || $settings['title']){ ?>
            <!-- Sec Title / Style Three -->
			<div class="sec-title style-three centered">
				<?php if($settings['sub_title']){ ?><div class="title"><?php echo wp_kses($settings['sub_title'], true); ?></div><?php } ?>
				<?php if($settings['title']){ ?><h2><?php echo wp_kses($settings['title'], true); ?></h2><?php } ?>
			</div>
            <?php } ?>
			<div class="row clearfix">
			
				<!-- Counter Column -->
				<div class="counter-column col-lg-8 col-md-12 col-sm-12">
					<div class="inner-column">
						
						<!-- Fact Counter Two -->
						<div class="fact-counter-two">
							<div class="row clearfix">
								<?php foreach($settings['slides'] as $key => $item): ?>
								<!-- Column -->
								<div class="column counter-column col-lg-6 col-md-6 col-sm-12">
									<div class="inner wow fadeInLeft">
										<div class="content">
											<div class="<?php echo esc_attr($item['icons']);?>"></div>
											<div class="count-outer count-box">
												<span class="count-text" data-speed="4000" data-stop="<?php echo esc_attr($item['counter_stop']);?>"><?php echo esc_attr($item['counter_start']);?></span><?php echo esc_attr($item['alphabet_letter']);?>
											</div>
											<h4 class="counter-title"><?php echo wp_kses($item['block_title'], true); ?></h4>
										</div>
									</div>
								</div>
								<?php endforeach; ?>
							</div>
						</div>
						
					</div>
				</div>
				
                <!-- Story Column -->
				<div class="story-column col-lg-4 col-md-12 col-sm-12">
					<div class="inner-column">
						<div class="icon <?php echo esc_attr(str_replace( "icon ",  "", $settings['icons2']));?>"></div>
						<div class="count-outer count-box">
							<span class="count-text" data-speed="4000" data-stop="<?php echo esc_attr($settings['counter_stop1']);?>"><?php echo esc_attr($settings['counter_start1']);?></span><i><?php echo esc_attr($settings['alphabet_letter1']);?></i>
						</div>
						<div class="text"><?php echo wp_kses($settings['story_text'], true); ?></div>
					</div>
				</div>
				
			</div>
		</div>
	</section>
	
	<!-- End Counter Section -->
		
    <?php 
	
	}

}