<?php

namespace NITECHPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;
/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Latest_News_V3 extends Widget_Base {
	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'nitech_latest_news_v3';
	}
	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Latest News V3', 'nitech' );
	}
	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}
	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'nitech' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'latest_news_v3',
			[
				'label' => esc_html__( 'Latest News V3', 'nitech' ),
			]
		);
		$this->add_control(
			'sub_title',
			[
				'label'       => __( 'Sub Title', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'nitech' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'nitech' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Text', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text Here', 'nitech' ),
			]
		);
		$this->add_control(
			'btn_title',
			[
				'label'       => __( 'Button Title', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Button Title', 'nitech' ),
			]
		);
		$this->add_control(
            'btn_link',
			[
				'label' => __( 'Button Url', 'nitech' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
        );
		$this->add_control(
			'text_limit',
			[
				'label'   => esc_html__( 'Text Limit', 'nitech' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'nitech' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 4,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'nitech' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'nitech' ),
					'title'      => esc_html__( 'Title', 'nitech' ),
					'menu_order' => esc_html__( 'Menu Order', 'nitech' ),
					'rand'       => esc_html__( 'Random', 'nitech' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'nitech' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESC' => esc_html__( 'DESC', 'nitech' ),
					'ASC'  => esc_html__( 'ASC', 'nitech' ),
				),
			]
		);
		$this->add_control(
            'query_category', 
			[
			  'type' => Controls_Manager::SELECT,
			  'label' => esc_html__('Category', 'nitech'),
			  'label_block' => true,
			  'options' => get_blog_categories(),
			]
		);
		$this->end_controls_section();
	}
	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		
        $paged = get_query_var('paged');
		$paged = nitech_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;
		
		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-nitech' );
		$args = array(
			'post_type'      => 'post',
			'posts_per_page' => nitech_set( $settings, 'query_number' ),
			'orderby'        => nitech_set( $settings, 'query_orderby' ),
			'order'          => nitech_set( $settings, 'query_order' ),
			'paged'         => $paged
		);
		if( nitech_set( $settings, 'query_category' ) ) $args['category_name'] = nitech_set( $settings, 'query_category' );
		$query = new \WP_Query( $args );
		
		if ( $query->have_posts() ) 
		{ ?>
		
        <!-- News Section Three -->
        <section class="news-section-three" id="blog">
            <div class="auto-container">
                <div class="row clearfix">
                
                    <!-- Title Column -->
                    <div class="title-column col-lg-4 col-md-12 col-sm-12">
                        <div class="inner-column">
                            <?php if($settings['sub_title'] || $settings['title']){ ?>
                            <!-- Sec Title / Style Three -->
                            <div class="sec-title style-three">
                                <?php if($settings['sub_title']){ ?><div class="title"><?php echo wp_kses($settings['sub_title'], true); ?></div><?php } ?>
                    			<?php if($settings['title']){ ?><h2><?php echo wp_kses($settings['title'], true); ?></h2><?php } ?>
                            </div>
                            <?php } ?>
                            <?php if($settings['text']){ ?>
                            <div class="text">
                                <?php echo wp_kses($settings['text'], true); ?>
                            </div>
                            <?php } ?>
                            
                            <?php if($settings['btn_link']['url'] and $settings['btn_title']){ ?>
                            <a href="<?php echo esc_url($settings['btn_link']['url']); ?>" class="theme-btn btn-style-six"><span class="txt"><?php echo wp_kses($settings['btn_title'], true); ?></span></a>
                            <?php } ?>
                        </div>
                    </div>
                    
                    <!-- News Column -->
                    <div class="news-column masonry-items-container-two col-lg-8 col-md-12 col-sm-12">
                        <div class="inner-column">
                            <div class="row clearfix">
                            	<?php 
									while ( $query->have_posts() ) : $query->the_post(); 
									$format = get_post_format(get_the_id());
								?>
								<?php if ($format == 'quote') : ?>
                                <!-- Column -->
                                <div class="column masonry-item col-lg-6 col-md-6 col-sm-12">
                                	<!-- News Block Three -->
                                    <div class="news-block-four">
                                        <div class="inner-box">
                                            <ul class="post-meta">
                                                <li><span class="icon fa fa-user"></span> <?php the_author(); ?></li>
                                                <li><span class="icon fa fa-comments"></span> <?php comments_number( wp_kses(__('0 Comments' , 'nitech'), true), wp_kses(__('1 Comment' , 'nitech'), true), wp_kses(__('% Comments' , 'nitech'), true)); ?></li>
                                            </ul>
                                            <h3><a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"><?php the_title(); ?></a></h3>
                                            <div class="text"><?php echo wp_kses(nitech_trim(get_the_content(), $settings['text_limit']), true); ?></div>
                                            <div class="clearfix">
                                                <div class="pull-left">
                                                    <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>" class="theme-btn read-more"><?php esc_html_e('Read More', 'nitech'); ?></a>
                                                </div>
                                                <div class="pull-left">
                                                    <div class="post-date"><?php echo esc_attr(get_the_date()); ?></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
								
								<?php else: ?>
                                
                                <div class="column masonry-item col-lg-6 col-md-6 col-sm-12">
                                    <!-- News Block Four -->
                                    <div class="news-block-three">
                                        <div class="inner-box">
                                            <div class="image">
                                                <?php the_post_thumbnail('nitech_370x250'); ?>
                                                <div class="post-date"><?php echo esc_attr(get_the_date()); ?></div>
                                                <!-- Overlay Box -->
                                                <div class="overlay-box">
                                                    <div class="overlay-inner">
                                                        <div class="content">
                                                            <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>" class="icon flaticon-unlink"></a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="lower-content">
                                                <div class="content">
                                                    <ul class="post-meta">
                                                        <li><span class="icon fa fa-user"></span> <?php the_author(); ?></li>
                                                        <li><span class="icon fa fa-comments"></span> <?php comments_number( wp_kses(__('0 Comments' , 'nitech'), true), wp_kses(__('1 Comment' , 'nitech'), true), wp_kses(__('% Comments' , 'nitech'), true)); ?></li>
                                                    </ul>
                                                    <h3><a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"><?php the_title(); ?></a></h3>
                                                    <div class="text"><?php echo wp_kses(nitech_trim(get_the_content(), $settings['text_limit']), true); ?></div>
                                                    <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>" class="theme-btn read-more"><?php esc_html_e('Read More', 'nitech'); ?></a>
                                                    <!-- End Social Outer Box -->
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php endif; endwhile; ?>
                            </div>
                        </div>
                    </div>
                    
                </div>
            </div>
        </section>
        <!-- End News Section Three -->
                
		<?php }
		wp_reset_postdata();
	}
}