<?php

namespace NITECHPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Program extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'nitech_our_program';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Our Program', 'nitech' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'nitech' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'our_program',
				[
					'label' => esc_html__( 'Our Program', 'nitech' ),
				]
		);
		$this->add_control(
			'program_bg_img',
				[
				  'label' => __( 'Program BG Image', 'nitech' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
	    );
		$this->add_control(
			'big_title',
			[
				'label'       => __( 'Big Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your big title', 'nitech' ),
			]
		);
		$this->add_control(
			'sub_title',
			[
				'label'       => __( 'Sub Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'nitech' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'nitech' ),
			]
		);
		$this->add_control(
                'slides', 
				[
						'type' => Controls_Manager::REPEATER,
						'separator' => 'before',
						'default' => 
					[

					],
				'fields' => 
					[
						[
							'name' => 'icons',
							'label' => esc_html__('Select Icon', 'nitech'),
							'label_block' => true,
							'type' => Controls_Manager::SELECT2,
							'options' => get_fontawesome_icons(),
						],
						[
							'name' => 'block_title',
							'label' => esc_html__('Block Title', 'nitech'),
							'label_block' => true,
							'type' => Controls_Manager::TEXTAREA,
							'default' => esc_html__('Enter Text Here', 'nitech')
						],
						[
							'name' => 'block_text',
							'label' => esc_html__('Block Text', 'nitech'),
							'label_block' => true,
							'type' => Controls_Manager::TEXTAREA,
							'default' => esc_html__('Enter Text Here', 'nitech')
						],
						[
                    		'name' => 'title_link',
							'label' => __( 'Title Url', 'nitech' ),
							'type' => Controls_Manager::URL,
							'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
							'show_external' => true,
							'default' => ['url' => '','is_external' => true,'nofollow' => true,],
                		],
						[
                    		'name' => 'btn_link',
							'label' => __( 'Button Url', 'nitech' ),
							'type' => Controls_Manager::URL,
							'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
							'show_external' => true,
							'default' => ['url' => '','is_external' => true,'nofollow' => true,],
                		],
					],
            ]
        );
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>


    <!-- City Program section-->
    <section class="city-program-section" id="program" <?php if($settings['program_bg_img']['id']){ ?>style="background-image: url(<?php echo esc_url(wp_get_attachment_url($settings['program_bg_img']['id'])); ?>);"<?php } ?>>
        <div class="auto-container">
            <?php if($settings['big_title'] || $settings['sub_title'] || $settings['title']){ ?>
            <div class="sec-title text-center">
                <?php if($settings['big_title']){ ?><div class="big-title"><?php echo wp_kses($settings['big_title'], true); ?></div><?php } ?>
                <?php if($settings['sub_title']){ ?><div class="sub-title"><?php echo wp_kses($settings['sub_title'], true); ?></div><?php } ?>
                <?php if($settings['title']){ ?><h2><?php echo wp_kses($settings['title'], true); ?></h2><?php } ?>
            </div>
            <?php } ?>
            <div class="row">
				<?php foreach($settings['slides'] as $key => $item): ?>
                <div class="col-lg-4 program-block">
                    <div class="inner-box wow fadeInUp" data-wow-delay="0ms" data-wow-duration="1500ms">
                        <div class="shape">
                            <svg 
                            xmlns="http://www.w3.org/2000/svg"
                            xmlns:xlink="http://www.w3.org/1999/xlink">
                           <defs>
                           <filter filterUnits="userSpaceOnUse" id="Filter_0" x="0px" y="0px" width="413px" height="325px"  >
                               <feOffset in="SourceAlpha" dx="0" dy="10" />
                               <feGaussianBlur result="blurOut" stdDeviation="5" />
                               <feFlood flood-color="rgb(0, 0, 0)" result="floodOut" />
                               <feComposite operator="atop" in="floodOut" in2="blurOut" />
                               <feComponentTransfer><feFuncA type="linear" slope="0.06"/></feComponentTransfer>
                               <feMerge>
                               <feMergeNode/>
                               <feMergeNode in="SourceGraphic"/>
                             </feMerge>
                           </filter>
                           
                           </defs>
                           <g filter="url(#Filter_0)">
                           <path fill-rule="evenodd"  fill="rgb(255, 255, 255)"
                            d="M386.000,287.999 L26.000,287.999 L26.000,96.000 L26.000,61.000 L26.000,16.000 L177.000,16.000 L177.000,61.000 L386.000,61.000 L386.000,287.999 Z"/>
                           </g>
                           </svg>
                        </div>
                        <div class="icon"><span class="<?php echo esc_attr($item['icons']);?>"></span></div>
                        <div class="category"><a href="<?php echo esc_url($item['title_link']['url']); ?>"><?php echo wp_kses($item['block_title'], true); ?></a></div>
                        <h4><?php echo wp_kses($item['block_text'], true); ?></h4>
                        <div class="link-btn"><a href="<?php echo esc_url($item['btn_link']['url']); ?>"><i class="icon-arrow"></i></a></div>
                    </div>
                </div>
				<?php endforeach; ?>
            </div>
        </div>
    </section>
	
    <!--End City Program section -->
		
    <?php 
	
	}

}