<?php

namespace NITECHPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Pricing_Section extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'nitech_pricing_section';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Pricing Section', 'nitech' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'nitech' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'pricing_section',
				[
					'label' => esc_html__( 'General', 'nitech' ),
					'tab' => Controls_Manager::TAB_LAYOUT,
				]
		);
		$this->add_control(
			'bg_image1',
				[
				  'label' => __( 'Background Image', 'nitech' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
	    );
		$this->add_control(
			'sub_title',
			[
				'label'       => __( 'Sub Title', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'nitech' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'nitech' ),
			]
		);
		$this->end_controls_section();
		
		//Monthly Table Plan
		$this->start_controls_section(
            'monthly_plan',
            [
                'label' => esc_html__( 'Monthly Table Plan', 'nitech' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
		$this->add_control(
			'monthly_btn_title',
			[
				'label'       => __( 'Monthly Button Title', 'nitech' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Monthly Button Title', 'nitech' ),
			]
		);
		$this->add_control(
            'monthly', 
			  	[
				'type' => Controls_Manager::REPEATER,
				'separator' => 'before',
				'default' => 
					[
						['block_title1' => esc_html__('Beginner', 'nitech')],
						['block_title1' => esc_html__('Professional', 'nitech')],
						['block_title1' => esc_html__('Standard', 'nitech')]
					],
			'fields' => 
				[
					
					[
						'name' => 'pattern_image1',
						'label' => __( 'Pattern Images One', 'nitech' ),
						 'type' => Controls_Manager::MEDIA,
						 'default' => ['url' => Utils::get_placeholder_image_src(),],
					],
					[
						'name' => 'pattern_image2',
						'label' => __( 'Pattern Images Two', 'nitech' ),
						 'type' => Controls_Manager::MEDIA,
						 'default' => ['url' => Utils::get_placeholder_image_src(),],
					],
					[
						'name' => 'block_title1',
						'label' => esc_html__('Block Title', 'nitech'),
						'label_block' => true,
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__('Enter Title Here', 'nitech')
					],
					[
						'name' => 'block_price1',
						'label' => esc_html__('Block Text', 'nitech'),
						'label_block' => true,
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__('Enter Text Here', 'nitech')
					],
					[
						'name' => 'features_list',
						'label' => esc_html__('Feature List', 'nitech'),
						'type' => Controls_Manager::TEXTAREA,
						'default' => esc_html__('', 'nitech')
					],
					[
						'name' => 'btn_title1',
						'label' => esc_html__('Button Title', 'nitech'),
						'label_block' => true,
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__('Enter button title Here', 'nitech')
					],
					[
						'name' => 'btn_link1',
						'label' => __( 'External Url', 'nitech' ),
						'type' => Controls_Manager::URL,
						'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
						'show_external' => true,
						'default' => ['url' => '','is_external' => true,'nofollow' => true,],
					],
				],
				'title_field' => '{{block_title1}}',
            ]
        );
		$this->end_controls_section();
		
		//Yearly Table Plan
		$this->start_controls_section(
            'yearly_plan',
            [
                'label' => esc_html__( 'Yearly Table Plan', 'nitech' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
		$this->add_control(
			'yearly_btn_title',
			[
				'label'       => __( 'Yearly Button Title', 'nitech' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Yearly Button Title', 'nitech' ),
			]
		);
		$this->add_control(
            'yearly', 
			  	[
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'default' => 
				[
					['block_title2' => esc_html__('Beginner', 'nitech')],
					['block_title2' => esc_html__('Professional', 'nitech')],
					['block_title2' => esc_html__('Standard', 'nitech')]
				],
			'fields' => 
				[
					
					[
						'name' => 'pattern_image1',
						'label' => __( 'Pattern Images One', 'nitech' ),
						 'type' => Controls_Manager::MEDIA,
						 'default' => ['url' => Utils::get_placeholder_image_src(),],
					],
					[
						'name' => 'pattern_image2',
						'label' => __( 'Pattern Images Two', 'nitech' ),
						 'type' => Controls_Manager::MEDIA,
						 'default' => ['url' => Utils::get_placeholder_image_src(),],
					],
					[
						'name' => 'block_title2',
						'label' => esc_html__('Block Title', 'nitech'),
						'label_block' => true,
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__('Enter Title Here', 'nitech')
					],
					[
						'name' => 'block_price2',
						'label' => esc_html__('Block Text', 'nitech'),
						'label_block' => true,
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__('Enter Text Here', 'nitech')
					],
					[
						'name' => 'features_list2',
						'label' => esc_html__('Feature List', 'nitech'),
						'type' => Controls_Manager::TEXTAREA,
						'default' => esc_html__('', 'nitech')
					],
					[
						'name' => 'btn_title2',
						'label' => esc_html__('Button Title', 'nitech'),
						'label_block' => true,
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__('Enter button title Here', 'nitech')
					],
					[
						'name' => 'btn_link2',
						'label' => __( 'External Url', 'nitech' ),
						'type' => Controls_Manager::URL,
						'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
						'show_external' => true,
						'default' => ['url' => '','is_external' => true,'nofollow' => true,],
					],
				],
				'title_field' => '{{block_title2}}',
            ]
        );
		
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>

	<!-- Pricing Section -->
	<section class="pricing-section">
		<?php if($settings['bg_image1']['id']){ ?><div class="image-layer" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['bg_image1']['id'])); ?>)"></div><?php } ?>
		<div class="auto-container">
			<div class="inner-container">
				<?php if($settings['sub_title'] || $settings['title']){ ?>
                <!-- Sec Title / Style Two -->
				<div class="sec-title style-two">
					<?php if($settings['sub_title']){ ?><div class="title"><?php echo wp_kses($settings['sub_title'], true); ?></div><?php } ?>
					<?php if($settings['title']){ ?><h2><?php echo wp_kses($settings['title'], true); ?></h2><?php } ?>
				</div>
				<?php } ?>
				<div class="pricing-tabs tabs-box">
                
					<!-- Tab Buttons -->
					<div class="buttons-outer">
						<ul class="tab-buttons clearfix">
							<li data-tab="#prod-monthly" class="tab-btn active-btn"><?php echo wp_kses($settings['monthly_btn_title'], true); ?></li>
							<li data-tab="#prod-yearly" class="tab-btn"><?php echo wp_kses($settings['yearly_btn_title'], true); ?></li>
						</ul>
					</div>
					
					<!--Tabs Container-->
					<div class="tabs-content">
						
						<!--Tab-->
						<div class="tab active-tab" id="prod-monthly">
							<div class="content">
								<div class="row clearfix">
									<?php foreach($settings['monthly'] as $key => $item):?>
									<!-- Price Block -->
									<div class="price-block col-lg-4 col-md-6 col-sm-12">
										<div class="inner-box">
											<div class="upper-box" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($item['pattern_image1']['id'])); ?>)">
												<div class="title"><?php echo wp_kses($item['block_title1'], true); ?></div>
												<div class="price"><?php echo wp_kses($item['block_price1'], true); ?></div>
											</div>
											<div class="lower-content" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($item['pattern_image2']['id'])); ?>)">
												<?php $features_list = $item['features_list'];
													if(!empty($features_list)){
													$features_list = explode("\n", ($features_list)); 
												?>
													<ul class="price-list">
													<?php foreach($features_list as $features): ?>
													   <li><?php echo wp_kses($features, true); ?></li>
													<?php endforeach; ?>
													</ul>
												<?php } ?>
												<div class="btn-box text-center">
													<a href="<?php echo esc_url($item['btn_link1']['url']); ?>" class="theme-btn purchase-btn"><span class="txt"><?php echo wp_kses($item['btn_title1'], true); ?></span></a>
												</div>
											</div>
										</div>
									</div>
									<?php endforeach;?>
								</div>
							</div>
						</div>
						
						<!--Tab-->
						<div class="tab" id="prod-yearly">
							<div class="content">
								<div class="row clearfix">
									<?php foreach($settings['yearly'] as $key => $item):?>
									<!-- Price Block -->
									<div class="price-block col-lg-4 col-md-6 col-sm-12">
										<div class="inner-box">
											<div class="upper-box" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($item['pattern_image1']['id'])); ?>)">
												<div class="title"><?php echo wp_kses($item['block_title2'], true); ?></div>
												<div class="price"><?php echo wp_kses($item['block_price2'], true); ?></div>
											</div>
											<div class="lower-content" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($item['pattern_image2']['id'])); ?>)">
												<?php $features_list2 = $item['features_list2'];
													if(!empty($features_list2)){
													$features_list2 = explode("\n", ($features_list2)); 
												?>
													<ul class="price-list">
													<?php foreach($features_list2 as $features): ?>
													   <li><?php echo wp_kses($features, true); ?></li>
													<?php endforeach; ?>
													</ul>
												<?php } ?>
												<div class="btn-box text-center">
													<a href="<?php echo esc_url($item['btn_link2']['url']); ?>" class="theme-btn purchase-btn"><span class="txt"><?php echo wp_kses($item['btn_title2'], true); ?></span></a>
												</div>
											</div>
										</div>
									</div>
									<?php endforeach;?>
								</div>
							</div>
						</div>
					
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- End Pricing Section -->
		
    <?php 
	
	}

}