<?php
namespace NITECHPLUGIN\Element;
use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;
/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Project_Detail extends Widget_Base {
	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'nitech_project_detail';
	}
	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Project Detail', 'nitech' );
	}
	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}
	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'nitech' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'project_detail',
			[
				'label' => esc_html__( 'Project Detail', 'nitech' ),
			]
		);
		$this->add_control(
			'project_pattern_image',
			[
			  'label' => __( 'BG Pattern Image', 'nitech' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => [
				  'url'     => Utils::get_placeholder_image_src(), 
				],
			]
	    );
		$this->add_control(
			'project_detail_title',
			[
				'label'       => __( 'Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'nitech' ),
			]
		);
		$this->add_control(
        	'project_info', 
				[
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'default' => 
				[
					['project_info_title' => esc_html__('Client:', 'nitech')],
					['project_info_title' => esc_html__('Class:', 'nitech')],
					['project_info_title' => esc_html__('Date:', 'nitech')],
					['project_info_title' => esc_html__('Website:', 'nitech')]
				],
			'fields' => 
				[
					[
						'name' => 'project_info_title',
						'label' => esc_html__('Block Title', 'nitech'),
						'label_block' => true,
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__('Enter Title Here', 'nitech')
					],
					[
						'name' => 'project_info_text',
						'label' => esc_html__('Block Title', 'nitech'),
						'label_block' => true,
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__('Enter Title Here', 'nitech')
					],
				],
			'title_field' => '{{project_info_title}}',
			]	
        );
		$this->add_control(
        	'social_icons', 
				[
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'default' => 
				[
					['social_link' => esc_html__('https://www.facebook.com/', 'nitech')],
				],
			'fields' => 
				[
					[
						'name' => 'social_icons',
						'label' => esc_html__('Select Icon', 'nitech'),
						'label_block' => true,
						'type' => Controls_Manager::SELECT2,
						'options' => get_fontawesome_icons(),
					],
					[
						'name' => 'social_link',
						'label' => __( 'External Url', 'nitech' ),
						'type' => Controls_Manager::URL,
						'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
						'show_external' => true,
						'default' => ['url' => '','is_external' => true,'nofollow' => true,],
					],
				],
			'title_field' => '{{social_link}}',
			]	
        );
		$this->add_control(
			'project_description_title',
			[
				'label'       => __( 'Description Title', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description Title', 'nitech' ),
			]
		);
		$this->add_control(
			'project_detail_text',
			[
				'label'       => __( 'Text', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text', 'nitech' ),
			]
		);
		$this->add_control(
			'project_button_title',
			[
				'label'       => __( 'Button Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Button Title', 'nitech' ),
			]
		);
		$this->add_control(
            'project_button_link',
			[
				'label' => __( 'Button Url', 'nitech' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
        );
		$this->add_control(
			'project_detail_image1',
			[
			  'label' => __( 'Project Feature Image V1', 'nitech' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => [
				  'url'     => Utils::get_placeholder_image_src(), 
				],
			]
	    );
		$this->add_control(
			'project_detail_image2',
			[
			  'label' => __( 'Project Feature Image V2', 'nitech' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => [
				  'url'     => Utils::get_placeholder_image_src(), 
				],
			]
	    );
		$this->add_control(
            'show_related_project',
			[
				'label' => __( 'Enable/Disable Related Project Post', 'nitech' ),
				'type'     => Controls_Manager::SWITCHER,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enable/Disable Related Project Post', 'nitech' ),
			]
		);
		$this->add_control(
			'sub_title',
			[
				'label'       => __( 'Sub Title', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'nitech' ),
			]
		);
		$this->add_control(
			'big_title',
			[
				'label'       => __( 'Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'nitech' ),
			]
		);
		$this->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'nitech' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 4,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'text_limit',
			[
				'label'   => esc_html__( 'Text Limit', 'nitech' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'nitech' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'nitech' ),
					'title'      => esc_html__( 'Title', 'nitech' ),
					'menu_order' => esc_html__( 'Menu Order', 'nitech' ),
					'rand'       => esc_html__( 'Random', 'nitech' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'nitech' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESC' => esc_html__( 'DESC', 'nitech' ),
					'ASC'  => esc_html__( 'ASC', 'nitech' ),
				),
			]
		);
		$this->add_control(
            'query_category', 
			[
			  'type' => Controls_Manager::SELECT,
			  'label' => esc_html__('Category', 'nitech'),
			  'label_block' => true,
			  'options' => get_project_categories()
			]
		);
		$this->add_control(
			'click_text_v5',
			[
				'label'       => __( 'Section Bottom Description', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'nitech' ),
			]
		);
		$this->add_control(
			'style_two',
			[
				'label'   => esc_html__( 'Choose Different Style', 'nitech' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'one',
				'options' => array(
					'one' => esc_html__( 'Choose Project Style V1', 'nitech' ),
					'two' => esc_html__( 'Choose Project Style V2', 'nitech' ),
				),
			]
		);
		$this->end_controls_section();
	}
	
	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		
        $paged = nitech_set($_POST, 'paged') ? esc_attr($_POST['paged']) : 1;
		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-nitech' );
		$args = array(
			'post_type'      =>  'project',
			'posts_per_page' => nitech_set( $settings, 'query_number' ),
			'orderby'        => nitech_set( $settings, 'query_orderby' ),
			'order'          => nitech_set( $settings, 'query_order' ),
			'paged'         => $paged
		);
		if( nitech_set( $settings, 'query_category' ) ) $args['project_cat'] = nitech_set( $settings, 'query_category' );
		$query = new \WP_Query( $args );
		if ( $query->have_posts() ) 
		{ ?>
		
        <?php if($settings['style_two'] == 'two'): ?>
        
        <!-- Project Detail Section -->
        <div class="project-detail-section" <?php if($settings['project_pattern_image']['id']){ ?>style="background-image: url(<?php echo esc_url(wp_get_attachment_url($settings['project_pattern_image']['id'])); ?>)"<?php } ?>>
            <div class="auto-container">
                
                <?php if( $settings['project_detail_image1']['id'] || $settings['project_detail_image2']['id'] ){ ?>
                <!-- Gallery Images -->
                <div class="gallery-images m-b60">
                    <div class="row clearfix">
                        <?php if($settings['project_detail_image1']['id']){ ?>
                        <!-- Image Column -->
                        <div class="image-column col-lg-6 col-md-6 col-sm-12">
                            <a href="<?php echo esc_url(wp_get_attachment_url($settings['project_detail_image1']['id'])); ?>" data-fancybox="gallery-2" data-caption=""><img src="<?php echo esc_url(wp_get_attachment_url($settings['project_detail_image1']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'nitech'); ?>" /></a>
                        </div>
                        <?php } ?>
						<?php if($settings['project_detail_image2']['id']){ ?>
                        <!-- Image Column -->
                        <div class="image-column col-lg-6 col-md-6 col-sm-12">
                            <a href="<?php echo esc_url(wp_get_attachment_url($settings['project_detail_image2']['id'])); ?>" data-fancybox="gallery-2" data-caption=""><img src="<?php echo esc_url(wp_get_attachment_url($settings['project_detail_image2']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'nitech'); ?>" /></a>
                        </div>
                        <?php } ?>
                    </div>
                </div>
                <!-- End Gallery Images -->
                <?php } ?>
                
                <div class="row clearfix">
                    
                    <!-- Content Column -->
                    <div class="content-column col-lg-9 col-md-12 col-sm-12">
                        <div class="inner-column m-r40">
                            <?php if($settings['project_description_title']){ ?><h2><?php echo wp_kses($settings['project_description_title'], true); ?></h2><?php } ?>
                            <?php echo wp_kses($settings['project_detail_text'], true); ?>
                            
                            <?php if($settings['project_button_link']['url'] and $settings['project_button_title']){ ?>
                            <div class="btn-box">
                                <a href="<?php echo esc_url($settings['project_button_link']['url']); ?>" class="theme-btn btn-style-three"><span class="txt"><?php echo wp_kses($settings['project_button_title'], true); ?></span></a>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                    
                    <?php if($settings['project_detail_title']){ ?>
                    <!-- Title Column -->
                    <div class="title-column content-column col-lg-3 col-md-12 col-sm-12">
                        <div class="inner-column">
                            <?php if( $settings['project_detail_title'] ):?>
                            <h3><?php echo wp_kses($settings['project_detail_title'], true); ?></h3>
                            <?php endif;?>
                            <ul class="info-list">
                                <?php foreach($settings['project_info'] as $key => $item): ?>
                                <li><strong><?php echo wp_kses($item['project_info_title'], true); ?></strong><?php echo wp_kses($item['project_info_text'], true); ?></li>
                                <?php endforeach; ?>
								
                                <li>
                                    <?php foreach($settings['social_icons'] as $key => $item): ?>
                                    <a target="_blank" href="<?php echo esc_url($item['social_link']['url']); ?>" class="fa <?php echo wp_kses(str_replace( "icon ",  "", $item['social_icons']), true); ?>"></a>
                                    <?php endforeach; ?>
                                </li>
                                
                            </ul>
                        </div>
                    </div>
                    <?php } ?>
                    
                </div>
                
                
                
                <?php if($settings['show_related_project']){ ?>
                <!-- Related Projects -->
                <div class="related-projects-section">
                    
                    <!-- Sec Title / Style Two -->
                    <div class="sec-title style-two centered">
                        <div class="title"><?php echo wp_kses($settings['sub_title'], true); ?></div>
                        <h2><?php echo wp_kses($settings['big_title'], true); ?></h2>
                    </div>
                    
                    <div class="three-item-carousel owl-carousel owl-theme">
                        <?php 
                            global  $post;
                            while ( $query->have_posts() ) : $query->the_post(); 
                            $post_thumbnail_id = get_post_thumbnail_id($post->ID);
                            $post_thumbnail_url = wp_get_attachment_url($post_thumbnail_id);
                        ?>
                        <!-- Project Block Four -->
                        <div class="project-block-four">
                            <div class="inner-box">
                                <div class="image">
                                    <?php the_post_thumbnail('nitech_370x320'); ?>
                                    <!--Overlay Box-->
                                    <div class="overlay-box" style="background-image: url(<?php echo esc_url(get_template_directory_uri());?>/assets/images/background/pattern-41.png)">
                                        <div class="overlay-inner">
                                            <div class="icons-box">
                                                <a href="<?php echo esc_url($post_thumbnail_url); ?>" data-fancybox="gallery-1" data-caption="" class="link"><span class="icon flaticon-full-screen"></span></a>
                                                <a href="<?php echo esc_url(get_post_meta( get_the_id(), 'project_url', true ));?>" class="flaticon-unlink"></a>
                                            </div>
                                            <div class="content">
                                                <h3><a href="<?php echo esc_url(get_post_meta( get_the_id(), 'project_url', true ));?>"><?php the_title(); ?></a></h3>
                                                <div class="text"><?php echo wp_kses(nitech_trim(get_the_content(), $settings['text_limit']), true); ?></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endwhile; ?>
                    </div>
                    
                    <?php if($settings['click_text_v5']){ ?>
                    <!-- Lower Text -->
                    <div class="lower-text text-center">
                        <div class="text"><?php echo wp_kses($settings['click_text_v5'], true); ?> </div>
                    </div>
                    <?php } ?>
                    
                </div>
                <!-- End Related Projects -->
                <?php } ?>
            </div>
        </div>
        <!-- End Project section -->
        
        <?php else: ?>
        
		<!-- Project Detail Section -->
        <div class="project-detail-section style-one" <?php if($settings['project_pattern_image']['id']){ ?>style="background-image: url(<?php echo esc_url(wp_get_attachment_url($settings['project_pattern_image']['id'])); ?>)"<?php } ?>>
            <div class="auto-container">
                <div class="row clearfix">
                    <?php if($settings['project_detail_title']){ ?>
                    <!-- Title Column -->
                    <div class="title-column content-column col-lg-3 col-md-12 col-sm-12">
                        <div class="inner-column">
                            <?php if( $settings['project_detail_title'] ):?>
                            <h3><?php echo wp_kses($settings['project_detail_title'], true); ?></h3>
                            <?php endif;?>
                            <ul class="info-list">
                                <?php foreach($settings['project_info'] as $key => $item): ?>
                                <li><strong><?php echo wp_kses($item['project_info_title'], true); ?></strong><?php echo wp_kses($item['project_info_text'], true); ?></li>
                                <?php endforeach; ?>
								
                                <li>
                                    <?php foreach($settings['social_icons'] as $key => $item): ?>
                                    <a target="_blank" href="<?php echo esc_url($item['social_link']['url']); ?>" class="fa <?php echo wp_kses(str_replace( "icon ",  "", $item['social_icons']), true); ?>"></a>
                                    <?php endforeach; ?>
                                </li>
                                
                            </ul>
                        </div>
                    </div>
                    <?php } ?>
                    <!-- Content Column -->
                    <div class="content-column col-lg-9 col-md-12 col-sm-12">
                        <div class="inner-column m-l40">
                            <?php if($settings['project_description_title']){ ?><h2><?php echo wp_kses($settings['project_description_title'], true); ?></h2><?php } ?>
                            <?php echo wp_kses($settings['project_detail_text'], true); ?>
                            
                            <?php if($settings['project_button_link']['url'] and $settings['project_button_title']){ ?>
                            <div class="btn-box">
                                <a href="<?php echo esc_url($settings['project_button_link']['url']); ?>" class="theme-btn btn-style-three"><span class="txt"><?php echo wp_kses($settings['project_button_title'], true); ?></span></a>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                    
                </div>
                <?php if( $settings['project_detail_image1']['id'] || $settings['project_detail_image2']['id'] ){ ?>
                <!-- Gallery Images -->
                <div class="gallery-images m-t60">
                    <div class="row clearfix">
                        <?php if($settings['project_detail_image1']['id']){ ?>
                        <!-- Image Column -->
                        <div class="image-column col-lg-6 col-md-6 col-sm-12">
                            <a href="<?php echo esc_url(wp_get_attachment_url($settings['project_detail_image1']['id'])); ?>" data-fancybox="gallery-2" data-caption=""><img src="<?php echo esc_url(wp_get_attachment_url($settings['project_detail_image1']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'nitech'); ?>" /></a>
                        </div>
                        <?php } ?>
						<?php if($settings['project_detail_image2']['id']){ ?>
                        <!-- Image Column -->
                        <div class="image-column col-lg-6 col-md-6 col-sm-12">
                            <a href="<?php echo esc_url(wp_get_attachment_url($settings['project_detail_image2']['id'])); ?>" data-fancybox="gallery-2" data-caption=""><img src="<?php echo esc_url(wp_get_attachment_url($settings['project_detail_image2']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'nitech'); ?>" /></a>
                        </div>
                        <?php } ?>
                    </div>
                </div>
                <!-- End Gallery Images -->
                <?php } ?>
                
                <?php if($settings['show_related_project']){ ?>
                <!-- Related Projects -->
                <div class="related-projects-section">
                    <?php if($settings['sub_title'] || $settings['big_title']){ ?>
                    <!-- Sec Title / Style Two -->
                    <div class="sec-title style-two centered">
                        <?php if($settings['sub_title']){ ?><div class="title"><?php echo wp_kses($settings['sub_title'], true); ?></div><?php } ?>
                        <?php if($settings['big_title']){ ?><h2><?php echo wp_kses($settings['big_title'], true); ?></h2><?php } ?>
                    </div>
                    <?php } ?>
                    <div class="three-item-carousel owl-carousel owl-theme">
						<?php
                            global  $post;
                            while ( $query->have_posts() ) : $query->the_post(); 
                            $post_thumbnail_id = get_post_thumbnail_id($post->ID);
                            $post_thumbnail_url = wp_get_attachment_url($post_thumbnail_id);
                        ?>
                        <!-- Project Block Four -->
                        <div class="project-block-four">
                            <div class="inner-box">
                                <div class="image">
                                    <?php the_post_thumbnail('nitech_370x320'); ?>
                                    <!--Overlay Box-->
                                    <div class="overlay-box" style="background-image: url(<?php echo esc_url(get_template_directory_uri());?>/assets/images/background/pattern-41.png)">
                                        <div class="overlay-inner">
                                            <div class="icons-box">
                                                <a href="<?php echo esc_url($post_thumbnail_url); ?>" data-fancybox="gallery-1" data-caption="" class="link"><span class="icon flaticon-full-screen"></span></a>
                                                <a href="<?php echo esc_url(get_post_meta( get_the_id(), 'project_url', true ));?>" class="flaticon-unlink"></a>
                                            </div>
                                            <div class="content">
                                                <h3><a href="<?php echo esc_url(get_post_meta( get_the_id(), 'project_url', true ));?>"><?php the_title(); ?></a></h3>
                                                <div class="text"><?php echo wp_kses(nitech_trim(get_the_content(), $settings['text_limit']), true); ?></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    	<?php endwhile; ?>
                    </div>
                    <?php if($settings['click_text_v5']){ ?>
                    <!-- Lower Text -->
                    <div class="lower-text text-center">
                        <div class="text"><?php echo wp_kses($settings['click_text_v5'], true); ?> </div>
                    </div>
            		<?php } ?>
                </div>
                <?php } ?> 
            </div>
        </div>
        <!-- End Project section -->
      	
		<?php endif; }
		wp_reset_postdata();
	}
}