<?php
namespace NITECHPLUGIN\Element;
use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;
/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Project_Detail_V2 extends Widget_Base {
	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'nitech_project_detail_v2';
	}
	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Project Detail V2', 'nitech' );
	}
	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fa fa-briefcase';
	}
	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'nitech' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'project_detail_v2',
			[
				'label' => esc_html__( 'Project Detail V2', 'nitech' ),
			]
		);
		$this->add_control(
			'project_pattern_image2',
			[
			  'label' => __( 'Project Pattern Image', 'nitech' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => [
				  'url'     => Utils::get_placeholder_image_src(), 
				],
			]
	    );
		$this->add_control(
			'project_company_title_v2',
			[
				'label'       => __( 'Company Name', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your company name', 'nitech' ),
			]
		);
		$this->add_control(
			'project_detail_designation_v2',
			[
				'label'       => __( 'Designation', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your designation', 'nitech' ),
			]
		);
		$this->add_control(
			'project_detail_date_v2',
			[
				'label'       => __( 'Joining Date', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Joining date', 'nitech' ),
			]
		);
		$this->add_control(
			'project_detail_web_v2',
			[
				'label'       => __( 'Compnay Website', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter company website', 'nitech' ),
			]
		);
		$this->add_control(
			'project_description_title_v2',
			[
				'label'       => __( 'Description Title', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description Title', 'nitech' ),
			]
		);
		$this->add_control(
			'project_detail_text_v2',
			[
				'label'       => __( 'Text', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text', 'nitech' ),
			]
		);
		$this->add_control(
			'project_button_title2',
			[
				'label'       => __( 'Button Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Button Title', 'nitech' ),
			]
		);
		$this->add_control(
            'project_button_link2',
			[
				'label' => __( 'Button Url', 'nitech' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
        );
		$this->add_control(
			'project_detail_image_v1',
			[
			  'label' => __( 'Project Detail Image One', 'nitech' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => [
				  'url'     => Utils::get_placeholder_image_src(), 
				],
			]
	    );
		$this->add_control(
			'project_detail_image_v2',
			[
			  'label' => __( 'Project Detail Image Two', 'nitech' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => [
				  'url'     => Utils::get_placeholder_image_src(), 
				],
			]
	    );
		$this->add_control(
			'sub_title',
			[
				'label'       => __( 'Sub Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'nitech' ),
			]
		);
		$this->add_control(
			'big_title',
			[
				'label'       => __( 'Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'nitech' ),
			]
		);
		$this->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'nitech' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 4,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'text_limit',
			[
				'label'   => esc_html__( 'Text Limit', 'nitech' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'nitech' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'nitech' ),
					'title'      => esc_html__( 'Title', 'nitech' ),
					'menu_order' => esc_html__( 'Menu Order', 'nitech' ),
					'rand'       => esc_html__( 'Random', 'nitech' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'nitech' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESC' => esc_html__( 'DESC', 'nitech' ),
					'ASC'  => esc_html__( 'ASC', 'nitech' ),
				),
			]
		);
		$this->add_control(
            'query_category', 
				[
				  'type' => Controls_Manager::SELECT,
				  'label' => esc_html__('Category', 'nitech'),
				  'label_block' => true,
				  'options' => get_project_categories()
				]
		);
		
		$this->add_control(
			'click_text_v5',
			[
				'label'       => __( 'Text', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text Here', 'nitech' ),
			]
		);
		$this->add_control(
			'click_btn_title_v5',
			[
				'label'       => __( 'Click Text', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text Here', 'nitech' ),
			]
		);
		$this->add_control(
            'button_link_v5',
			[
				'label' => __( 'Click Here Url', 'nitech' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
        );
		$this->end_controls_section();
	}
	
	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		
        $paged = nitech_set($_POST, 'paged') ? esc_attr($_POST['paged']) : 1;
		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-nitech' );
		$args = array(
			'post_type'      =>  'project',
			'posts_per_page' => nitech_set( $settings, 'query_number' ),
			'orderby'        => nitech_set( $settings, 'query_orderby' ),
			'order'          => nitech_set( $settings, 'query_order' ),
			'paged'         => $paged
		);
		if( nitech_set( $settings, 'query_category' ) ) $args['project_cat'] = nitech_set( $settings, 'query_category' );
		$query = new \WP_Query( $args );
		if ( $query->have_posts() ) 
		{ ?>
	
	<!-- Project Detail Section -->
    <div class="project-detail-section" style="background-image: url(<?php echo esc_url(wp_get_attachment_url($settings['project_pattern_image2']['id'])); ?>)">
    	<div class="auto-container">
        	<div class="row clearfix">
				
				<!-- Content Column -->
                <div class="content-column col-lg-12 col-md-12 col-sm-12">
                	<div class="inner-column">
						<ul class="info-list">
							<li><strong><?php esc_html_e('Client:', 'nitech'); ?></strong><?php echo wp_kses($settings['project_company_title_v2'], true); ?></li>
							<li><strong><?php esc_html_e('Class:', 'nitech'); ?></strong><?php echo wp_kses($settings['project_detail_designation_v2'], true); ?></li>
							<li><strong><?php esc_html_e('Date:', 'nitech'); ?></strong><?php echo wp_kses($settings['project_detail_date_v2'], true); ?></li>
							<li><strong><?php esc_html_e('Website:', 'nitech'); ?></strong><?php echo wp_kses($settings['project_detail_web_v2'], true); ?></li>
							<li>
								<a target="_blank" href="http://facebook.com/" class="fa fa-facebook-f"></a>
								<a target="_blank" href="http://twitter.com/" class="fa fa-google"></a>
								<a target="_blank" href="http://twitter.com/" class="fa fa-twitter"></a>
								<a target="_blank" href="http://instagram.com/" class="fa fa-pinterest-p"></a>
							</li>
						</ul>
						<h2><?php echo wp_kses($settings['project_description_title_v2'], true); ?></h2>
							<?php echo wp_kses($settings['project_detail_text_v2'], true); ?>
						<div class="btn-box">
							<a href="<?php echo esc_url($settings['project_button_link2']['url']); ?>" class="theme-btn btn-style-three"><span class="txt"><?php echo wp_kses($settings['project_button_title2'], true); ?></span></a>
						</div>
					</div>
				</div>
				
			</div>
			
			<!-- Gallery Images -->
			<div class="gallery-images">
				<div class="row clearfix">
					<!-- Image Column -->
					<div class="image-column col-lg-6 col-md-6 col-sm-12">
						<a href="images/gallery/22.jpg" data-fancybox="gallery-2" data-caption=""><img src="<?php echo esc_url(wp_get_attachment_url($settings['project_detail_image_v1']['id'])); ?>" alt="" /></a>
					</div>
					
					<!-- Image Column -->
					<div class="image-column col-lg-6 col-md-6 col-sm-12">
						<a href="images/gallery/23.jpg" data-fancybox="gallery-2" data-caption=""><img src="<?php echo esc_url(wp_get_attachment_url($settings['project_detail_image_v2']['id'])); ?>" alt="" /></a>
					</div>
				</div>
			</div>
			<!-- End Gallery Images -->
			
			<!-- Related Projects -->
			<div class="related-projects-section">
				
				<!-- Sec Title / Style Two -->
				<div class="sec-title style-two centered">
					<div class="title"><?php echo wp_kses($settings['sub_title'], true); ?></div>
					<h2><?php echo wp_kses($settings['big_title'], true); ?></h2>
				</div>
				
				<div class="three-item-carousel owl-carousel owl-theme">
				<?php while ( $query->have_posts() ) : $query->the_post(); ?>
					<!-- Project Block Four -->
					<div class="project-block-four">
						<div class="inner-box">
							<div class="image">
								<?php the_post_thumbnail('nitech_370x320'); ?>
								<!--Overlay Box-->
								<div class="overlay-box" style="background-image: url(<?php echo esc_url(get_template_directory_uri());?>/assets/images/background/pattern-41.png)">
									<div class="overlay-inner">
										<div class="icons-box">
											<a href="images/gallery/16.jpg" data-fancybox="gallery-1" data-caption="" class="link"><span class="icon flaticon-full-screen"></span></a>
											<a href="<?php echo esc_url(get_post_meta( get_the_id(), 'project_url', true ));?>" class="flaticon-unlink"></a>
										</div>
										<div class="content">
											<h3><a href="<?php echo esc_url(get_post_meta( get_the_id(), 'project_url', true ));?>"><?php the_title(); ?></a></h3>
											<div class="text"><?php echo wp_kses(nitech_trim(get_the_content(), $settings['text_limit']), true); ?></div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				<?php endwhile; ?>
				</div>
				
				<!-- Lower Text -->
				<div class="lower-text text-center">
					<div class="text"><?php echo wp_kses($settings['click_text_v5'], true); ?> <a href="<?php echo esc_url($settings['button_link_v5']['url']); ?>"><?php echo wp_kses($settings['click_btn_title_v5'], true); ?></a> Now.</div>
				</div>
				
			</div>
			<!-- End Related Projects -->
			
		</div>
	</div>
	<!-- End Project section -->
      	
		<?php }
		wp_reset_postdata();
	}
}