<?php

namespace NITECHPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Quote_Form_Info extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'nitech_quote_form_info';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Quote Form Info', 'nitech' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'nitech' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'quote_form_info',
				[
					'label' => esc_html__( 'Quote Form Info', 'nitech' ),
				]
		);
		$this->add_control(
			'form_sub_title',
			[
				'label'       => __( 'Form Sub Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Form Sub Tilte Here', 'nitech' ),
			]
		);
		$this->add_control(
			'form_title',
			[
				'label'       => __( 'Form Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Form Title Here', 'nitech' ),
			]
		);
		$this->add_control(
           'contact_us_form',
			[
				'label'       => __( 'Contact Form 7 Url', 'nitech' ),
                'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
                'active' => true,
				],
                'placeholder' => __( 'Enter your Contact Form 7 Url', 'nitech' )
			]
		);
		$this->add_control(
			'sub_title',
			[
				'label'       => __( 'Sub Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Tilte Here', 'nitech' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'nitech' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Text', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text Here', 'nitech' ),
			]
		);
        $this->add_control(
			'features_list',
			[
				'label'       => __( 'Feature List', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Feature List', 'nitech' ),
			]
		);
		$this->add_control(
			'btn_title1',
			[
				'label'       => __( 'Button Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Button Title Here', 'nitech' ),
			]
		);
		$this->add_control(
            'btn_link1',
			[
				'label' => __( 'Button Url', 'nitech' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
		
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>

	<!-- Quote Section -->
	<section class="quote-section">
		<div class="auto-container">
			<div class="row clearfix">
			
				<!-- Form Column -->
				<div class="form-column col-lg-5 col-md-12 col-sm-12">
					<div class="inner-column">
						<?php if($settings['form_sub_title'] || $settings['form_title']){ ?>
                        <!-- Sec Title / Style Two -->
						<div class="sec-title style-two">
							<?php if($settings['form_sub_title']){ ?><div class="title"><?php echo wp_kses($settings['form_sub_title'], true); ?></div><?php } ?>
							<?php if($settings['form_title']){ ?><h2><?php echo wp_kses($settings['form_title'], true); ?></h2><?php } ?>
						</div>
						<?php } ?>
                        
                        <?php if($settings['contact_us_form']){ ?>
						<!-- Default Form -->
						<div class="default-form">
							<?php echo do_shortcode( $settings['contact_us_form'] );?>
                        </div>
						<?php } ?>
					</div>
				</div>
				
				<!-- Content Column -->
				<div class="content-column col-lg-7 col-md-12 col-sm-12">
					<div class="inner-column">
						<?php if($settings['sub_title'] || $settings['title'] || $settings['text']){ ?>
                        <!-- Sec Title / Style Two -->
						<div class="sec-title style-two">
							<?php if($settings['sub_title']){ ?><div class="title"><?php echo wp_kses($settings['sub_title'], true); ?></div><?php } ?>
							<?php if($settings['title']){ ?><h2><?php echo wp_kses($settings['title'], true); ?></h2><?php } ?>
							<?php if($settings['text']){ ?><div class="text"><?php echo wp_kses($settings['text'], true); ?></div><?php } ?>
						</div>
						<?php } ?>
						<?php $features_list = $settings['features_list'];
                            if(!empty($features_list)){
                            $features_list = explode("\n", ($features_list)); 
                        ?>
                        <ul class="list-style-two">
                        	<?php foreach($features_list as $features): ?>
                           <li><?php echo wp_kses($features, true); ?></li>
                        	<?php endforeach; ?>
                        </ul>
                        <?php } ?>
                        <?php if($settings['btn_link1']['url'] and $settings['btn_title1']){ ?>
						<div class="btn-box">
							<a href="<?php echo esc_url($settings['btn_link1']['url']); ?>" class="theme-btn btn-style-four"><span class="txt"><?php echo wp_kses($settings['btn_title1'], true); ?></span></a>
						</div>
                        <?php } ?>
					</div>
				</div>
			
			</div>
		</div>
	</section>
	
	<!-- End Quote Section -->
		
    <?php 
	
	}

}