<?php

namespace NITECHPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Services_Single extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'nitech_services_single';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Services Single', 'nitech' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'nitech' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'services_single',
				[
					'label' => esc_html__( 'Services Single', 'nitech' ),
				]
		);
		$this->add_control(
			'sidebar_slug',
			[
				'label'   => esc_html__( 'Choose Sidebar', 'nitech' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'Choose Sidebar',
				'options'  => nitech_get_sidebars(),
			]
		);
		$this->add_control(
			'service_single_image',
			[
			  	'label' => __( 'Service Single Image', 'nitech' ),
			  	'type' => Controls_Manager::MEDIA,
			  	'label_block' => true,
			  	'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
	    );
		$this->add_control(
			'block_title1',
			[
				'label'       => __( 'Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'nitech' ),
			]
		);
		$this->add_control(
			'block_text1',
			[
				'label'       => __( 'Text', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text Here', 'nitech' ),
			]
		);
         $this->add_control(
			'features_list',
			[
				'label'       => __( 'Feature List V1', 'kidum' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Feature List V1', 'kidum' ),
			]
		);
         $this->add_control(
			'features_list2',
			[
				'label'       => __( 'Feature List V2', 'kidum' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Feature List V2', 'kidum' ),
			]
		);
		$this->add_control(
			'block_title2',
			[
				'label'       => __( 'Sub Heading/Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Heading/Title Here', 'nitech' ),
			]
		);
		$this->add_control(
			'block_text2',
			[
				'label'       => __( 'Text', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text Here', 'nitech' ),
			]
		);
		$this->add_control(
			'block_title3',
			[
				'label'       => __( 'Sub Heading/Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Heading/Title Here', 'nitech' ),
			]
		);
		$this->add_control(
			'block_text3',
			[
				'label'       => __( 'Text', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text Here', 'nitech' ),
			]
		);
		$this->add_control(
                'our_tab', 
				[
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'default' => 
					[
						['btn_title' => esc_html__('01. Workflow & Process', 'nitech')],
						['btn_title' => esc_html__('02. Research Analysis', 'nitech')],
						['btn_title' => esc_html__('03. Financial Statement', 'nitech')],
						['btn_title' => esc_html__('04. Risk Assuarance', 'nitech')]
					],
				'fields' => 
					[
						[
							'name' => 'btn_title',
							'label' => esc_html__('Tab Button Title', 'nitech'),
							'label_block' => true,
							'type' => Controls_Manager::TEXTAREA,
							'default' => esc_html__('', 'nitech')
						],
						[
							'name' => 'tab_text',
							'label' => esc_html__('Tab Text', 'nitech'),
							'label_block' => true,
							'type' => Controls_Manager::TEXTAREA,
							'default' => esc_html__('', 'nitech')
						],
						[
							'name' => 'tab_image',
							'label' => __( 'Tab Images', 'nitech' ),
							 'type' => Controls_Manager::MEDIA,
							 'default' => ['url' => Utils::get_placeholder_image_src(),],
						],
					],
				'title_field' => '{{btn_title}}',
            ]
        );
		
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>

	<!-- Sidebar Page Container -->
    <div class="sidebar-page-container left-sidebar">
    	<div class="auto-container">
        	<div class="row clearfix">
				
                <?php if ( is_active_sidebar( $settings['sidebar_slug'] ) ) : ?>
				<!--Sidebar Side-->
				<div class="sidebar-side col-lg-4 col-md-12 col-sm-12">
					<aside class="sidebar sticky-top">
						<?php dynamic_sidebar( $settings['sidebar_slug'] ); ?>
					</aside>
				</div>
				<!--End Sidebar Side-->
				<?php endif; ?>
                
                <!-- Content Side -->
                <div class="content-side <?php if ( is_active_sidebar( $settings['sidebar_slug'] ) ) echo 'col-lg-8'; else echo 'col-lg-12'; ?> col-md-12 col-sm-12">
                	<div class="service-detail">
						<div class="inner-box">
							<?php if($settings['service_single_image']['id']){ ?>
                            <div class="image">
								<img src="<?php echo esc_url(wp_get_attachment_url($settings['service_single_image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'nitech'); ?>" />
							</div>
							<?php } ?>
                            <div class="lower-content">
								<?php if($settings['block_title1']){ ?><h2><?php echo wp_kses($settings['block_title1'], true); ?></h2><?php } ?>
								<?php echo wp_kses($settings['block_text1'], true); ?>
								<div class="row clearfix">
									<!-- Column -->
									<div class="column col-lg-6 col-md-6 col-sm-12">
										<?php $features_list = $settings['features_list'];
											if(!empty($features_list)){
											$features_list = explode("\n", ($features_list)); 
										?>
                                        <ul class="list-style-two">
                                            <?php foreach($features_list as $features): ?>
                                            <li><?php echo wp_kses($features, true); ?></li>
                                        	<?php endforeach; ?>
                                        </ul>
										<?php } ?>
									</div>
									<!-- Column -->
									<div class="column col-lg-6 col-md-6 col-sm-12">
										<?php $features_list2 = $settings['features_list2'];
											if(!empty($features_list2)){
											$features_list2 = explode("\n", ($features_list2)); 
										?>
                                        <ul class="list-style-two">
                                            <?php foreach($features_list2 as $features): ?>
                                            <li><?php echo wp_kses($features, true); ?></li>
                                        	<?php endforeach; ?>
                                        </ul>
										<?php } ?>
									</div>
								</div>
								<?php if($settings['block_title2']){ ?><h3><?php echo wp_kses($settings['block_title2'], true); ?></h3><?php } ?>
								<?php echo wp_kses($settings['block_text2'], true); ?>
								<?php if($settings['block_title3']){ ?><h3><?php echo wp_kses($settings['block_title3'], true); ?></h3><?php } ?>
								<?php echo wp_kses($settings['block_text3'], true); ?>
								
								<!-- Service Info Tabs -->
								<div class="service-info-tabs">
									<!-- Service Tabs -->
									<div class="service-tabs tabs-box">
										
										<!--Tab Btns-->
										<ul class="tab-btns tab-buttons clearfix">
											<?php foreach($settings['our_tab'] as $key => $item): ?>
											<li data-tab="#prod-workflow<?php echo esc_attr($key); ?>" class="tab-btn  <?php if($key == 1) echo 'active-btn' ?>"><?php echo wp_kses($item['btn_title'], true); ?></li>
											<?php endforeach; ?>
										</ul>
										
										<!--Tabs Container-->
										<div class="tabs-content">
											<?php foreach($settings['our_tab'] as $key => $item): ?>
											<!-- Tab / Active Tab -->
											<div class="tab <?php if($key == 1) echo 'active-tab' ?>" id="prod-workflow<?php echo esc_attr($key); ?>">
												<div class="content">
													<?php echo wp_kses($item['tab_text'], true); ?>
													<div class="image-two">
														<img src="<?php echo esc_url(wp_get_attachment_url($item['tab_image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'nitech'); ?>" />
													</div>
												</div>
											</div>
											<?php endforeach; ?>
										</div>
									</div>
								</div>
								
							</div>
						</div>
					</div>
				</div>
					
			</div>
		</div>
	</div>
	
    <!--End Sidebar Page Container -->
		
    <?php 
	
	}

}