<?php

namespace NITECHPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Services_V1 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'nitech_services_v1';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Services V1', 'nitech' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'nitech' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'services_v1',
				[
					'label' => esc_html__( 'Services V1', 'nitech' ),
				]
		);
		$this->add_control(
			'bg_image1',
				[
				  'label' => __( 'Background Image One', 'nitech' ),
				  'type' => Controls_Manager::MEDIA,
				  'label_block' => true, 
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
	    );
		$this->add_control(
			'bg_image2',
				[
				  'label' => __( 'Background Image Two', 'nitech' ),
				  'type' => Controls_Manager::MEDIA,
				  'label_block' => true, 
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
	    );
		$this->add_control(
			'sub_title',
			[
				'label'       => __( 'Sub Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'nitech' ),
			]
		);
		$this->add_control(
			'big_title',
			[
				'label'       => __( 'Big Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your big title', 'nitech' ),
			]
		);
		$this->add_control(
			'text_limit',
			[
				'label'   => esc_html__( 'Text Limit', 'nitech' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'nitech' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 4,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'nitech' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'nitech' ),
					'title'      => esc_html__( 'Title', 'nitech' ),
					'menu_order' => esc_html__( 'Menu Order', 'nitech' ),
					'rand'       => esc_html__( 'Random', 'nitech' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'nitech' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESC' => esc_html__( 'DESC', 'nitech' ),
					'ASC'  => esc_html__( 'ASC', 'nitech' ),
				),
			]
		);
		$this->add_control(
            'query_category', 
				[
				  'type' => Controls_Manager::SELECT,
				  'label' => esc_html__('Category', 'nitech'),
				  'label_block' => true,
				  'options' => get_service_categories()
				]
		);$this->add_control(
			'click_btn_text1',
			[
				'label'       => __( 'Section Bottom Description', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Bottom Description', 'nitech' ),
			]
		);
				
		$this->end_controls_section();
	}
	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		
        $paged = nitech_set($_POST, 'paged') ? esc_attr($_POST['paged']) : 1;
		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-nitech' );
		$args = array(
			'post_type'      => 'service',
			'posts_per_page' => nitech_set( $settings, 'query_number' ),
			'orderby'        => nitech_set( $settings, 'query_orderby' ),
			'order'          => nitech_set( $settings, 'query_order' ),
			'paged'         => $paged
		);
		if( nitech_set( $settings, 'query_category' ) ) $args['service_cat'] = nitech_set( $settings, 'query_category' );
		$query = new \WP_Query( $args );
		if ( $query->have_posts() ) 
		{ ?>
		


	<!-- Services Section -->
	<section class="services-section" id="services">
		<?php if($settings['bg_image1']['id']){ ?><div class="pattern-layer-one" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['bg_image1']['id'])); ?>)"></div><?php } ?>
		<?php if($settings['bg_image2']['id']){ ?><div class="pattern-layer-two" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['bg_image2']['id'])); ?>)"></div><?php } ?>
		<div class="auto-container">
			<?php if($settings['sub_title'] || $settings['big_title']){ ?>
            <!-- Sec Title -->
			<div class="sec-title">
				<?php if($settings['sub_title'] || $settings['big_title']){ ?>
                <div class="title">
					<span class="icon-box-left">
						<span class="color-one"></span>
						<span class="color-two"></span>
						<span class="color-three"></span>
					</span>
					<?php echo wp_kses($settings['sub_title'], true); ?>
				</div>
                <?php } ?>
                <?php if($settings['big_title']){ ?>
				<h2><?php echo wp_kses($settings['big_title'], true); ?></h2>
                <?php } ?>
			</div>
			<!-- End Sec Title -->
			<?php } ?>
			<div class="services-carousel owl-carousel owl-theme">
			<?php $i = 1; while ( $query->have_posts() ) : $query->the_post(); ?>
				<!-- Service Block -->
				<div class="service-block">
					<div class="inner-box">
						<div class="icon <?php echo wp_kses(str_replace("icon ", " ", get_post_meta(get_the_id(), 'service_icon', true )), $allowed_tags); ?>"></div>
						<div class="service-number"><?php $i = sprintf('%02d', $i); echo $i; ?></div>
						<h3><a href="<?php echo esc_url(get_post_meta( get_the_id(), 'service_url', true ));?>"><?php the_title(); ?></a></h3>
						<div class="text"><?php echo wp_kses(nitech_trim(get_the_content(), $settings['text_limit']), true); ?></div>
						<a href="<?php echo esc_url(get_post_meta( get_the_id(), 'service_url', true ));?>" class="read-more"><?php esc_html_e('Read More', 'nitech'); ?> <span class="fa fa-angle-double-right"></span></a>
					</div>
				</div>
			<?php $i++; endwhile; ?>	
			</div>
			<?php if($settings['click_btn_text1']){ ?>
			<!-- Lower Text -->
			<div class="lower-text text-center">
				<div class="service-text"><?php echo wp_kses($settings['click_btn_text1'], true); ?></div>
			</div>
			<?php } ?>
		</div>
	</section>
	
	<!-- End Services Section -->
        
		<?php }
		wp_reset_postdata();
	}
}