<?php

namespace NITECHPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Slider_V1 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'nitech_slider_v1';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Slider V1', 'nitech' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'nitech' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'slider_v1',
				[
					'label' => esc_html__( 'Slider V1', 'nitech' ),
				]
		);
		$this->add_control(
			'pattern_one_image',
				[
				  'label' => __( 'Pattern Image One', 'nitech' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
	    );
		$this->add_control(
                'slides', 
				[
						'type' => Controls_Manager::REPEATER,
						'separator' => 'before',
						'default' => 
					[
						['block_title' => esc_html__('Slider#1', 'nitech')],
						['block_title' => esc_html__('Slider#2', 'nitech')],
						['block_title' => esc_html__('Slider#3', 'nitech')],	
					],
				'fields' => 
					[
						[
							'name' => 'sub_title',
							'label' => esc_html__('Sub Title', 'nitech'),
							'label_block' => true,
							'type' => Controls_Manager::TEXTAREA,
							'default' => esc_html__('', 'nitech')
						],
						[
							'name' => 'title',
							'label' => esc_html__('Title', 'nitech'),
							'label_block' => true,
							'type' => Controls_Manager::TEXTAREA,
							'default' => esc_html__('', 'nitech')
						],
						[
							'name' => 'text',
							'label' => esc_html__('Text', 'nitech'),
							'label_block' => true,
							'type' => Controls_Manager::TEXTAREA,
							'default' => esc_html__('', 'nitech')
						],
						[
							'name' => 'btn_title1',
							'label' => esc_html__('Button Title', 'nitech'),
							'label_block' => true,
							'type' => Controls_Manager::TEXTAREA,
							'default' => esc_html__('', 'nitech')
						],
						[
							'name' => 'btn_title1_link',
							'label' => __( 'External Url', 'nitech' ),
							'type' => Controls_Manager::URL,
							'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
							'show_external' => true,
							'default' => ['url' => '','is_external' => true,'nofollow' => true,],
						],
						[
							'name' => 'slider_one_images',
							'label' => __( 'Slider V1 Images', 'nitech' ),
							 'type' => Controls_Manager::MEDIA,
							 'default' => ['url' => Utils::get_placeholder_image_src(),],
						],
					],
				]
        );
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>


	<!-- Main Slider Section -->
	<section class="main-slider" id="home">
		<div class="pattern-layer-one" <?php if($settings['pattern_one_image']['id']){ ?>style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['pattern_one_image']['id'])); ?>)"<?php } ?>></div>
		<div class="color-layer"></div>
		<div class="banner-carousel owl-carousel owl-theme">
			<?php foreach($settings['slides'] as $key => $item): ?>
			<div class="slide">
				<div class="auto-container">
					<div class="row cus-flex clearfix">
						<!-- Content Column -->
						<div class="content-column col-lg-6 col-md-12 col-sm-12">
							<div class="inner-column">
								<div class="pattern-layer-two" style="background-image:url(<?php echo esc_url(get_template_directory_uri());?>/assets/images/main-slider/pattern-2.png)"></div>
								<div class="title"><?php echo wp_kses($item['sub_title'], true); ?></div>
								<h1><?php echo wp_kses($item['title'], true); ?></h1>
								<div class="text"><?php echo wp_kses($item['text'], true); ?></div>
								<div class="btn-box">
									<div class="btns-inner clearfix">
										<a href="<?php echo esc_url($item['btn_title1_link']['url']); ?>" class="theme-btn btn-style-one"><span class="txt"><?php echo wp_kses($item['btn_title1'], true); ?></span></a>
									</div>
								</div>
							</div>
						</div>
						<!-- Image Column -->
						<div class="image-column col-lg-6 col-md-12 col-sm-12">
							<div class="inner-column">
								<div class="image">
									<img src="<?php echo esc_url(wp_get_attachment_url($item['slider_one_images']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'nitech'); ?>" />
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php endforeach; ?>
		</div>
	</section>
	
	<!-- End Main Slider Section -->
		
    <?php 
	
	}

}