<?php

namespace NITECHPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Software_Section extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'nitech_software_section';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Software Section', 'nitech' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'nitech' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'software_section',
				[
					'label' => esc_html__( 'Software Section', 'nitech' ),
				]
		);
		$this->add_control(
                'slides', 
				[
						'type' => Controls_Manager::REPEATER,
						'separator' => 'before',
						'default' => 
					[

					],
				'fields' => 
					[
						[
							'name' => 'pdf_img',
							'label' => __( 'PDF Image', 'nitech' ),
							 'type' => Controls_Manager::MEDIA,
							 'default' => ['url' => Utils::get_placeholder_image_src(),],
						],
						[
							'name' => 'hover_url',
							'label' => __( 'External Url', 'nitech' ),
							'type' => Controls_Manager::URL,
							'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
							'show_external' => true,
							'default' => ['url' => '','is_external' => true,'nofollow' => true,],
						],
						[
							'name' => 'block_title1',
							'label' => esc_html__('Block Sub Title', 'nitech'),
							'label_block' => true,
							'type' => Controls_Manager::TEXT,
							'default' => esc_html__('Enter Sub Title Here', 'nitech')
						],
						[
							'name' => 'block_title2',
							'label' => esc_html__('Block Title', 'nitech'),
							'label_block' => true,
							'type' => Controls_Manager::TEXT,
							'default' => esc_html__('Enter Title Here', 'nitech')
						],
						[
							'name' => 'block_text',
							'label' => esc_html__('Block Text', 'nitech'),
							'label_block' => true,
							'type' => Controls_Manager::TEXT,
							'default' => esc_html__('Enter Text Here', 'nitech')
						],
					],
				]	
        );
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>
	
	<!-- Software Section -->
	<section class="software-section">
		<div class="auto-container">
			<div class="row clearfix">
				<?php foreach($settings['slides'] as $key => $item): ?>
				<!-- Software Column -->
				<div class="software-block col-lg-6 col-md-6 col-sm-12">
					<div class="inner-box" style="background-image:url(<?php echo esc_url(get_template_directory_uri());?>/assets/images/background/pattern-30.png)">
						<a href="<?php echo esc_url($item['hover_url']['url']); ?>" class="overlay-link"></a>
						<div class="content">
							<div class="icon"><img src="<?php echo esc_url(wp_get_attachment_url($item['pdf_img']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'nitech'); ?>" /></div>
							<div class="title"><?php echo wp_kses($item['block_title1'], true); ?></div>
							<h5><?php echo wp_kses($item['block_title2'], true); ?></h5>
							<div class="download"><?php echo wp_kses($item['block_text'], true); ?></div>
						</div>
					</div>
				</div>
				<?php endforeach; ?>
			</div>
		</div>
	</section>
	
	<!-- End Software Section -->
		
    <?php 
	
	}

}