<?php
namespace NITECHPLUGIN\Element;
use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;
/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Team_Details extends Widget_Base {
	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'nitech_team_details';
	}
	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Team Details', 'nitech' );
	}
	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}
	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'nitech' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'team_details',
			[
				'label' => esc_html__( 'Team Details', 'nitech' ),
			]
		);
		$this->add_control(
			'team_detail_image',
			[
			  'label' => __( 'Team Detail Image', 'nitech' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => [
				  'url'     => Utils::get_placeholder_image_src(), 
				],
			]
	    );
		$this->add_control(
			'detail_title',
			[
				'label'       => __( 'Title', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'nitech' ),
			]
		);
		$this->add_control(
			'detail_category',
			[
				'label'       => __( 'Designation', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Designation', 'nitech' ),
			]
		);
		$this->add_control(
			'team_detail_email',
			[
				'label'       => __( 'Email Address', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your email', 'nitech' ),
			]
		);
		$this->add_control(
			'team_detail_phone1',
			[
				'label'       => __( 'Phone No.', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Phone No.', 'nitech' ),
			]
		);
		$this->add_control(
			'team_detail_phone2',
			[
				'label'       => __( 'Fax No.', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Fax No.', 'nitech' ),
			]
		);
		$this->add_control(
			'team_detail_text',
			[
				'label'       => __( 'Text', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text', 'nitech' ),
			]
		);
		$this->add_control(
			'features_list',
			[
				'label'       => __( 'Feature List V1', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Feature List V1', 'nitech' ),
			]
		);
		$this->add_control(
			'features_list2',
			[
				'label'       => __( 'Feature List V2', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Feature List V2', 'nitech' ),
			]
		);
		$this->add_control(
        	'social_icons', 
				[
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'default' => 
				[
					
				],
			'fields' => 
				[
					[
						'name' => 'social_icons',
						'label' => esc_html__('Select Icon', 'nitech'),
						'label_block' => true,
						'type' => Controls_Manager::SELECT2,
						'options' => get_fontawesome_icons(),
					],
					[
						'name' => 'social_link',
						'label' => __( 'External Url', 'nitech' ),
						'type' => Controls_Manager::URL,
						'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
						'show_external' => true,
						'default' => ['url' => '','is_external' => true,'nofollow' => true,],
					],
				],
			]	
        );
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>

	<!-- Team Detail Section -->
	<section class="team-single-section">
		<div class="auto-container">
			<div class="row clearfix">
				<?php if($settings['team_detail_image']['id']): ?>
				<!-- Image Column -->
				<div class="image-column col-lg-4 col-md-12 col-sm-12">
					<div class="inner-column wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
						<div class="image">
							<img src="<?php echo esc_url(wp_get_attachment_url($settings['team_detail_image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'nitech'); ?>" />
						</div>
					</div>
				</div>
				<?php endif; ?>
				<!-- Content Column -->
				<div class="content-column col-lg-8 col-md-12 col-sm-12">
					<div class="inner-column">
						<h2><?php echo wp_kses($settings['detail_title'], true); ?><span class="category"><?php echo wp_kses($settings['detail_category'], true); ?></span></h2>
						<?php if($settings['team_detail_email'] || $settings['team_detail_phone1'] || $settings['team_detail_phone2']){ ?>
                        <ul class="post-meta">
							<?php if($settings['team_detail_email']){ ?><li><span class="icon flaticon-email-2"></span> <a href="mailto:<?php echo sanitize_email($settings['team_detail_email']); ?>"><?php echo wp_kses($settings['team_detail_email'], true); ?></a></li><?php } ?>
							<?php if($settings['team_detail_phone1']){ ?><li><span class="icon flaticon-call-2"></span> <a href="tel:<?php echo esc_attr($settings['team_detail_phone1']);?>"><?php echo wp_kses($settings['team_detail_phone1'], true); ?></a></li><?php } ?>
							<?php if($settings['team_detail_phone2']){ ?><li><span class="icon flaticon-call-1"></span> <a href="tel:<?php echo esc_attr($settings['team_detail_phone2']);?>"><?php echo wp_kses($settings['team_detail_phone2'], true); ?></a></li><?php } ?>
						</ul>
                        <?php } ?>
                        <?php if($settings['team_detail_text']){ ?>
						<div class="text">
							<?php echo wp_kses($settings['team_detail_text'], true); ?>
						</div>
                        <?php } ?>
						<div class="row clearfix">
							<div class="column col-lg-6 col-md-6 col-sm-12">
								<?php $features_list = $settings['features_list'];
									if(!empty($features_list)){
									$features_list = explode("\n", ($features_list)); 
								?>
								<ul class="list-style-two">
									<?php foreach($features_list as $features): ?>
								    <li><?php echo wp_kses($features, true); ?></li>
									<?php endforeach; ?>
								</ul>
								<?php } ?>
							</div>
							<div class="column col-lg-6 col-md-6 col-sm-12">
								<?php $features_list2 = $settings['features_list2'];
									if(!empty($features_list2)){
									$features_list2 = explode("\n", ($features_list2)); 
								?>
								<ul class="list-style-two">
								<?php foreach($features_list2 as $features): ?>
								   <li><?php echo wp_kses($features, true); ?></li>
								<?php endforeach; ?>
								</ul>
								<?php } ?>
							</div>
						</div>
						<!-- Social Box -->
						<ul class="social-box">
							<?php foreach($settings['social_icons'] as $key => $item): ?>
                            <li><a target="_blank" href="<?php echo esc_url($item['social_link']['url']); ?>" class="fab <?php echo wp_kses(str_replace( "icon ",  "", $item['social_icons']), true); ?>"></a></li>
							<?php endforeach; ?>
						</ul>
					</div>
				</div>
				
			</div>
		</div>
	</section>
	<!-- End Team Detail Section -->
		
    <?php 
	
	}

}