<?php
namespace NITECHPLUGIN\Element;
use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;
/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Team_Details_v2 extends Widget_Base {
	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'nitech_team_details_v2';
	}
	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Team Details V2', 'nitech' );
	}
	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}
	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'nitech' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'team_details_v2',
			[
				'label' => esc_html__( 'Team Details V2', 'nitech' ),
			]
		);
		$this->add_control(
			'team_detail_image',
			[
			  'label' => __( 'Team Detail Image', 'nitech' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => [
				  'url'     => Utils::get_placeholder_image_src(), 
				],
			]
	    );
		$this->add_control(
        	'social_icons', 
				[
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'default' => 
				[
					
				],
			'fields' => 
				[
					[
						'name' => 'social_icons',
						'label' => esc_html__('Select Icon', 'nitech'),
						'label_block' => true,
						'type' => Controls_Manager::SELECT2,
						'options' => get_fontawesome_icons(),
					],
					[
						'name' => 'social_link',
						'label' => __( 'External Url', 'nitech' ),
						'type' => Controls_Manager::URL,
						'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
						'show_external' => true,
						'default' => ['url' => '','is_external' => true,'nofollow' => true,],
					],
				],
			]	
        );
		$this->add_control(
			'detail_title',
			[
				'label'       => __( 'Title', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'nitech' ),
			]
		);
		$this->add_control(
			'detail_category',
			[
				'label'       => __( 'Designation', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Designation', 'nitech' ),
			]
		);
		$this->add_control(
			'team_detail_email',
			[
				'label'       => __( 'Email Address', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your email', 'nitech' ),
			]
		);
		$this->add_control(
			'team_detail_phone',
			[
				'label'       => __( 'Phone No.', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Phone No.', 'nitech' ),
			]
		);
		$this->add_control(
			'team_detail_website',
			[
				'label'       => __( 'Website', 'nitech' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Website.', 'nitech' ),
			]
		);
		$this->add_control(
			'team_detail_address',
			[
				'label'       => __( 'Address', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Address.', 'nitech' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'nitech' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Text', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text', 'nitech' ),
			]
		);
		$this->add_control(
        	'features', 
				[
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'default' => 
				[
					
				],
			'fields' => 
				[
					[
						'name' => 'block_date',
						'label' => esc_html__('Date', 'nitech'),
						'label_block' => true,
						'type' => Controls_Manager::TEXT,
					],
					[
						'name' => 'block_text',
						'label' => esc_html__('Text', 'nitech'),
						'label_block' => true,
						'type' => Controls_Manager::TEXTAREA,
					],
				],
			]	
        );
		$this->add_control(
			'f_title',
			[
				'label'       => __( 'Form Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Form Title Here', 'nitech' ),
			]
		);
		$this->add_control(
           'team_form',
			[
				'label'       => __( 'Contact Form 7 Url', 'nitech' ),
                'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
                'active' => true,
				],
                'placeholder' => __( 'Enter your Contact Form 7 Url', 'nitech' )
			]
		);
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>

	<!-- Team Detail Section Two -->
    <section class="team-details-section-two">
        <div class="auto-container">
            <div class="row clearfix">
                <div class="left-column col-lg-4 col-md-8 col-sm-12">
                    <div class="single-team-member">
                        <div class="inner-box">
                            <?php if($settings['team_detail_image']['id']): ?>
                            <div class="image">
                                <img src="<?php echo esc_url(wp_get_attachment_url($settings['team_detail_image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'nitech'); ?>">
                                
                                <div class="social-links-wrapper">
                                    <div class="icon"><span class="flaticon-share"></span></div>
                                    <ul class="social-links">
                                        <?php foreach($settings['social_icons'] as $key => $item): ?>
                                        <li><a href="<?php echo esc_url($item['social_link']['url']); ?>"><span class="fab <?php echo wp_kses(str_replace( "icon fa ",  "", $item['social_icons']), true); ?>"></span></a></li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                                
                            </div>
                            <?php endif;?>
                            <div class="lower-content">
                                <div class="author-title">
                                    <h4><?php echo wp_kses($settings['detail_title'], true); ?></h4>
                                    <div class="designation"><?php echo wp_kses($settings['detail_category'], true); ?></div>
                                </div>                                
                                <ul class="info-list">
                                    <?php if($settings['team_detail_email']){ ?><li><span>Email:</span> <a href="mailto:<?php echo esc_url($settings['team_detail_email']); ?>"><?php echo sanitize_email($settings['team_detail_email']); ?></a></li><?php } ?>
                                    <?php if($settings['team_detail_phone']){ ?><li><span>Phone:</span> <a href="tel:<?php echo esc_attr($settings['team_detail_phone']);?>"><?php echo wp_kses($settings['team_detail_phone'], true);?></a></li><?php } ?>
                                    <?php if($settings['team_detail_address']){ ?><li><span>Address:</span> <?php echo wp_kses($settings['team_detail_address'], true);?></li><?php } ?>
                                    <?php if($settings['team_detail_website']){ ?><li><span>Website:</span> <?php echo wp_kses($settings['team_detail_website'], true);?></li><?php } ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="right-column col-lg-8 col-md-12 col-sm-12">
                    <div class="working-history">
                        <div class="top-content">
                            <h2><?php echo wp_kses($settings['title'], true); ?></h2>
                            <div class="text"><?php echo wp_kses($settings['text'], true); ?></div>
                        </div>                            
                        <div class="wrapper-box">
                            
                            <ul class="timeline">
                                
								<?php foreach($settings['features'] as $key => $item): ?>
                                <li data-date="<?php echo esc_attr( $item[ 'block_date' ] );?>" class="<?php if( $key == 1 ) echo ' current ';?>">
                                    <div class="text"><?php echo esc_attr( $item[ 'block_text' ] );?></div>
                                </li>
                                <?php endforeach; ?>
                                
                            </ul>
                        </div>
                        
                        <!-- Sec Title -->
                        <div class="sec-title">
                            <h2><?php echo wp_kses($settings['f_title'], true); ?></h2>
                        </div>
                        <!-- End Sec Title -->
                        
                        <div class="default-form">
                        	<div class="contact-form">
                            	<?php echo do_shortcode( $settings['team_form'] );?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- End Team Detail Section Two -->
		
    <?php 
	
	}

}