<?php

namespace NITECHPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Technology_Section extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'nitech_technology_section';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Technology Section', 'nitech' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'nitech' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'technology_section',
				[
					'label' => esc_html__( 'Technology Section', 'nitech' ),
				]
		);
		$this->add_control(
			'bg_image',
				[
				  'label' => __( 'Background Image', 'nitech' ),
				  'type' => Controls_Manager::MEDIA,
				  'label_block' => true, 
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
	    );
		$this->add_control(
			'sub_title',
			[
				'label'       => __( 'Sub Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'nitech' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'nitech' ),
			]
		);
		$this->add_control(
                'slides', 
				[
						'type' => Controls_Manager::REPEATER,
						'separator' => 'before',
						'default' => 
					[

					],
				'fields' => 
					[

						[
							'name' => 'overlay_link',
							'label' => __( 'External Url', 'nitech' ),
							'type' => Controls_Manager::URL,
							'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
							'show_external' => true,
							'default' => ['url' => '','is_external' => true,'nofollow' => true,],
						],
						[
							'name' => 'icons',
							'label' => esc_html__('Select Icon', 'nitech'),
							'label_block' => true,
							'type' => Controls_Manager::SELECT2,
							'options' => get_fontawesome_icons(),
						],
						[
							'name' => 'block_title',
							'label' => esc_html__('Block Title', 'nitech'),
							'label_block' => true,
							'type' => Controls_Manager::TEXTAREA,
							'default' => esc_html__('', 'nitech')
						],
					],
				]
        );
		$this->add_control(
			'btn_title1',
			[
				'label'       => __( 'Button Title', 'nitech' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter Button Title Here', 'nitech' ),
			]
		);
		$this->add_control(
            'btn_url',
			[
				'label' => __( 'Button Url', 'nitech' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
		
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>

	<!-- Technology Section -->
	<section class="technology-section" <?php if($settings['bg_image']['id']){ ?>style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['bg_image']['id']));?>)"<?php } ?>>
		<div class="auto-container">
			
			<!-- Sec Title -->
			<div class="sec-title centered">
				<?php if($settings['sub_title']){ ?>
                <div class="title">
					<span class="icon-box-left">
						<span class="color-one"></span>
						<span class="color-two"></span>
						<span class="color-three"></span>
					</span>
					<?php echo wp_kses($settings['sub_title'], true);?>
					<span class="icon-box-right">
						<span class="color-one"></span>
						<span class="color-two"></span>
						<span class="color-three"></span>
					</span>
				</div>
				<?php } ?>
                
                <?php if($settings['title']){ ?>
                <h2><?php echo wp_kses($settings['title'], true);?></h2>
                <?php } ?>
			</div>
			<!-- End Sec Title -->
			
			<!-- Inner Container -->
			<div class="inner-container">
				<div class="clearfix">
					<?php foreach($settings['slides'] as $key => $item):?>
					<!-- Technology Block -->
					<div class="technology-block">
						<div class="inner-box">
							<div class="color-layer"></div>
							<a class="overlay-link" href="<?php echo esc_url($item['overlay_link']['url']); ?>"></a>
							<div class="<?php echo esc_attr($item['icons']);?>"></div>
							<h6><?php echo wp_kses($item['block_title'], true);?></h6>
						</div>
					</div>
					<?php endforeach;?>
				</div>
				
				<!-- Button Box -->
				<div class="button-box text-center">
					<a href="<?php echo esc_url($settings['btn_url']['url']); ?>" class="theme-btn btn-style-one"><span class="txt"><?php echo wp_kses($settings['btn_title1'], true);?></span></a>
				</div>
				
			</div>
			<!-- End Inner Container -->
			
		</div>
	</section>
	
	<!-- End Technology Section -->

		
    <?php 
	
	}

}