<?php
///----Blog widgets---
//Recent Posts
class Nitech_Recent_Post extends WP_Widget
{
    /** constructor */
    public function __construct()
    {
        parent::__construct( /* Base ID */'Nitech_Recent_Post', /* Name */esc_html__('Nitech Recent Posts', 'nitech'), array( 'description' => esc_html__('Show the Recent Posts', 'nitech')));
    }


    /** @see WP_Widget::widget */
    public function widget($args, $instance)
    {
        extract($args);
        $title = apply_filters('widget_title', $instance['title']);

        echo wp_kses_post($before_widget); ?>

		<!-- Popular Posts -->
        <div class="popular-posts">
            <?php echo wp_kses_post($before_title.$title.$after_title); ?>
            <div class="widget-content">
                <div class="posts-outer">
                    <?php $query_string = array('showposts'=>$instance['number']);
					if ($instance['cat']) {
						$query_string['tax_query'] = array(array('taxonomy' => 'category','field' => 'id','terms' => (array)$instance['cat']));
					}
					$this->posts($query_string); ?>
                </div>
            </div>
        </div>
        
        <?php echo wp_kses_post($after_widget);
    }


    /** @see WP_Widget::update */
    public function update($new_instance, $old_instance)
    {
        $instance = $old_instance;

        $instance['title'] = strip_tags($new_instance['title']);
        $instance['number'] = $new_instance['number'];
        $instance['cat'] = $new_instance['cat'];

        return $instance;
    }

    /** @see WP_Widget::form */
    public function form($instance)
    {
        $title = ($instance) ? esc_attr($instance['title']) : esc_html__('Recent Posts', 'nitech');
        $number = ($instance) ? esc_attr($instance['number']) : 4;
        $cat = ($instance) ? esc_attr($instance['cat']) : ''; ?>

        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title: ', 'nitech'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('No. of Posts:', 'nitech'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr($number); ?>" />
        </p>
		<p>
            <label for="<?php echo esc_attr($this->get_field_id('categories')); ?>"><?php esc_html_e('Category', 'nitech'); ?></label>
            <?php wp_dropdown_categories(array('show_option_all'=>esc_html__('All Categories', 'nitech'), 'taxonomy' => 'category', 'selected'=>$cat, 'class'=>'widefat', 'name'=>$this->get_field_name('cat'))); ?>
        </p>

        <?php
    }

    public function posts($query_string)
    {
        $query = new WP_Query($query_string);
        if ($query->have_posts()):?>

            <!-- Title -->
            <?php
                global $post;
				while ($query->have_posts()): $query->the_post();
				$post_thumbnail_id = get_post_thumbnail_id($post->ID);
				$post_thumbnail_url = wp_get_attachment_url($post_thumbnail_id); 
			?>
            <article class="post">
                <figure class="post-thumb" style="background-image:url(<?php echo esc_url($post_thumbnail_url); ?>)"><a href="<?php echo esc_url(get_the_permalink(get_the_id()));?>" class="overlay-box"><span class="icon fa fa-link"></span></a></figure>
                <div class="m-h85">
                <div class="text"><a href="<?php echo esc_url(get_the_permalink(get_the_id()));?>"><?php echo wp_kses_post(nitech_trim(get_the_title(), 4, '...'));?></a></div>
                <div class="post-info"><?php echo esc_attr(get_the_date());?></div>
                </div>
            </article>
            <?php endwhile; ?>

        <?php endif;
        wp_reset_postdata();
    }
}


///----Services Sidebar Widgets---
//Nitech Services Categories
class Nitech_Services_Categories extends WP_Widget
{
    /** constructor */
    public function __construct()
    {
        parent::__construct( /* Base ID */'Nitech_Services_Categories', /* Name */esc_html__('Nitech Services Categories', 'nitech'), array( 'description' => esc_html__('Show the Services Categories', 'nitech')));
    }


	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract($args);
        
		echo wp_kses_post($before_widget); ?>
		
		<!-- Categories Widget -->
        <div class="categories-widget">
            <div class="widget-content">
                <ul class="blog-cat">
				<?php 
                    $args = array('post_type' => 'service', 'showposts'=>$instance['number']);
                    if( $instance['cat'] ) $args['tax_query'] = array(array('taxonomy' => 'service_cat','field' => 'id','terms' => (array)$instance['cat']));
                    $this->posts($args);
                ?>
                </ul>
            </div>
        </div>
        
        <?php echo wp_kses_post($after_widget);
	}
 
 
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		$instance['number'] = $new_instance['number'];
		$instance['cat'] = $new_instance['cat'];
		
		return $instance;
	}
	/** @see WP_Widget::form */
	function form($instance)
	{
		$number = ( $instance ) ? esc_attr($instance['number']) : 6;
		$cat = ( $instance ) ? esc_attr($instance['cat']) : '';?>
		
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('Number of posts: ', 'nitech'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('cat')); ?>"><?php esc_html_e('Category', 'nitech'); ?></label>
            <?php wp_dropdown_categories( array('show_option_all'=>esc_html__('All Categories', 'nitech'), 'selected'=>$cat, 'taxonomy' => 'service_cat', 'class'=>'widefat', 'name'=>$this->get_field_name('cat')) ); ?>
        </p>
            
		<?php 
	}
	
	function posts($args)
	{
		
		$query = new WP_Query($args);
		if( $query->have_posts() ):?>
        
           	<!-- Title -->
            <?php 
				while( $query->have_posts() ): $query->the_post();
			?>
			<li><a href="<?php echo esc_url(get_post_meta( get_the_id(), 'service_url', true ));?>"><?php if(get_post_meta(get_the_id(), 'service_icon', true )){ ?><span class="icon <?php echo wp_kses(str_replace("icon ", " ", get_post_meta(get_the_id(), 'service_icon', true )), true); ?>"></span><?php } ?><?php the_title(); ?></a></li>
            <?php endwhile; ?>
                
        <?php endif;
		wp_reset_postdata();
    }
}

//Nitech Contact Us Info
class Nitech_Contact_Us_Info extends WP_Widget
{
	
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Nitech_Contact_Us_Info', /* Name */esc_html__('Nitech Contact Us Info','nitech'), array( 'description' => esc_html__('Show the Nitech Contact Us Info', 'nitech' )) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		echo wp_kses_post($before_widget);?>
 
		<div class="sidebar-widget contact-info-widget">
			<div class="content-inner" <?php if($instance['widget_bg_img']){ ?>style="background-image: url(<?php echo esc_url($instance['widget_bg_img']); ?>)"<?php } ?>>
				<?php echo wp_kses_post($before_title.$title.$after_title); ?>
				<ul>
					<?php if($instance['address_title'] || $instance['text']){ ?>
                    <li>
						<span class="icon flaticon-placeholder-2"></span>
						<?php if($instance['address_title']){ ?><strong><?php echo wp_kses_post($instance['address_title']); ?></strong><?php }?>
						<?php if($instance['text']){ ?><?php echo wp_kses_post($instance['text']); ?><?php }?>
					</li>
					<?php }?>
                    <?php if($instance['phone_title'] || $instance['phone']){ ?>
                    <li>
						<span class="icon flaticon-call"></span>
						<?php if($instance['phone_title']){ ?><strong><?php echo wp_kses_post($instance['phone_title']); ?></strong><?php }?>
						<?php if($instance['phone']){ ?><a href="tel:<?php echo phone_number($instance['phone']);?>"><?php echo wp_kses_post($instance['phone']); ?></a><?php }?>
					</li>
                    <?php }?>
					<?php if($instance['email_title'] || $instance['email']){ ?>
                    <li>
						<span class="icon flaticon-email-1"></span>
						<?php if($instance['email_title']){ ?><strong><?php echo wp_kses_post($instance['email_title']); ?></strong><?php }?>
						<?php if($instance['email']){ ?><a href="mailto:<?php echo esc_attr($instance['email']); ?>"><?php echo wp_kses_post($instance['email']); ?></a><?php }?>
					</li>
                    <?php }?>
				</ul>
			</div>
		</div>
      	   <?php
       		
		
		echo wp_kses_post($after_widget);
	}
	
	
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		$instance['widget_bg_img'] = strip_tags($new_instance['widget_bg_img']);
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['address_title'] = $new_instance['address_title'];
		$instance['text'] = $new_instance['text'];
		$instance['phone_title'] = $new_instance['phone_title'];
		$instance['phone'] = $new_instance['phone'];
		$instance['email_title'] = $new_instance['email_title'];
		$instance['email'] = $new_instance['email'];
		
		
		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$widget_bg_img = ($instance) ? esc_attr($instance['widget_bg_img']) : 'http://wp1.efforttech.com/newwp/nitech/wp-content/uploads/2021/09/4.jpg';
		$title = ($instance) ? esc_attr($instance['title']) : 'Contact Us Two';
		$address_title = ($instance) ? esc_attr($instance['address_title']) : '';
		$text = ($instance) ? esc_attr($instance['text']) : '';
		$phone_title = ($instance) ? esc_attr($instance['phone_title']) : '';
		$phone = ($instance) ? esc_attr($instance['phone']) : '';
		$email_title = ($instance) ? esc_attr($instance['email_title']) : '';
		$email = ($instance) ? esc_attr($instance['email']) : '';
		
		?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('widget_bg_img')); ?>"><?php esc_html_e('Enter BG Image Url:', 'nitech'); ?></label>
            <input placeholder="<?php esc_attr_e('BG Image Url', 'nitech');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('widget_bg_img')); ?>" name="<?php echo esc_attr($this->get_field_name('widget_bg_img')); ?>" type="text" value="<?php echo esc_attr($widget_bg_img); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'nitech'); ?></label>
            <input placeholder="<?php esc_attr_e('title', 'nitech');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('address_title')); ?>"><?php esc_html_e('Address Title:', 'nitech'); ?></label>
            <input placeholder="<?php esc_attr_e('Address Title', 'nitech');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('address_title')); ?>" name="<?php echo esc_attr($this->get_field_name('address_title')); ?>" type="text" value="<?php echo esc_attr($address_title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('text')); ?>"><?php esc_html_e('Enter Address:', 'nitech'); ?></label>
            <input placeholder="<?php esc_attr_e('Address', 'nitech');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('text')); ?>" name="<?php echo esc_attr($this->get_field_name('text')); ?>" type="text" value="<?php echo esc_attr($text); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('phone_title')); ?>"><?php esc_html_e('Enter Phone Title:', 'nitech'); ?></label>
            <input placeholder="<?php esc_attr_e('Phone Title', 'nitech');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('phone_title')); ?>" name="<?php echo esc_attr($this->get_field_name('phone_title')); ?>" type="text" value="<?php echo esc_attr($phone_title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('phone')); ?>"><?php esc_html_e('Enter Phone Number:', 'nitech'); ?></label>
            <input placeholder="<?php esc_attr_e('phone', 'nitech');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('phone')); ?>" name="<?php echo esc_attr($this->get_field_name('phone')); ?>" type="text" value="<?php echo esc_attr($phone); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('email_title')); ?>"><?php esc_html_e('Enter Email Title:', 'nitech'); ?></label>
            <input placeholder="<?php esc_attr_e('Email Title', 'nitech');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('email_title')); ?>" name="<?php echo esc_attr($this->get_field_name('email_title')); ?>" type="text" value="<?php echo esc_attr($email_title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('email')); ?>"><?php esc_html_e('Enter Email Addess:', 'nitech'); ?></label>
            <input placeholder="<?php esc_attr_e('email', 'nitech');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('email')); ?>" name="<?php echo esc_attr($this->get_field_name('email')); ?>" type="text" value="<?php echo esc_attr($email); ?>" />
        </p>
        
		<?php 
	}
	
}



///----footer widgets One---
//About Company
class Nitech_About_Company extends WP_Widget
{

	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Nitech_About_Company', /* Name */esc_html__('Nitech About Company','nitech'), array( 'description' => esc_html__('Show the About Company', 'nitech' )) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
        $title = apply_filters('widget_title', $instance['title']);
		
		echo wp_kses_post($before_widget);?>


			<div class="logo-widget">
				<?php echo wp_kses_post($before_title.$title.$after_title); ?>
                <div class="text"><?php echo wp_kses_post($instance['text']); ?></div>
                <!-- Social Box -->
                <?php if( $instance['show'] ): ?>
                	<?php echo wp_kses_post(nitech_get_social_icons()); ?>
                <?php endif; ?>
			</div>
            
        <?php

		echo wp_kses_post($after_widget);
	}


	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['title'] = strip_tags($new_instance['title']);
		$instance['text'] = $new_instance['text'];
		$instance['show'] = $new_instance['show'];

		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ($instance) ? esc_attr($instance['title']) : esc_html__('About Company', 'nitech');
		$text = ($instance) ? esc_attr($instance['text']) : '';
		$show = ($instance) ? esc_attr($instance['show']) : '';
		

		?>

        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title: ', 'nitech'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('text')); ?>"><?php esc_html_e('Description:', 'nitech'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('text')); ?>" name="<?php echo esc_attr($this->get_field_name('text')); ?>" ><?php echo wp_kses_post($text); ?></textarea>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('show')); ?>"><?php esc_html_e('Show Social Icons:', 'nitech'); ?></label>
			<?php $selected = ( $show ) ? ' checked="checked"' : ''; ?>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('show')); ?>"<?php echo esc_attr($selected); ?> name="<?php echo esc_attr($this->get_field_name('show')); ?>" type="checkbox" value="true" />
        </p>
        
		<?php
	}

}

//Nitech Latest News 
//Latest News
class Nitech_Latest_News extends WP_Widget
{
    /** constructor */
    public function __construct()
    {
        parent::__construct( /* Base ID */'Nitech_Latest_News', /* Name */esc_html__('Nitech Latest News', 'nitech'), array( 'description' => esc_html__('Show the Latest News', 'nitech')));
    }


    /** @see WP_Widget::widget */
    public function widget($args, $instance)
    {
        extract($args);
        $title = apply_filters('widget_title', $instance['title']);

        echo wp_kses_post($before_widget); ?>

		<!-- Popular Posts -->
        <div class="news-widget">
            <?php echo wp_kses_post($before_title.$title.$after_title); ?>
            <!-- Footer Column -->
            <div class="widget-content">
                <?php $query_string = array('showposts'=>$instance['number']);
					if ($instance['cat']) {
						$query_string['tax_query'] = array(array('taxonomy' => 'category','field' => 'id','terms' => (array)$instance['cat']));
					}
				$this->posts($query_string); ?>
            </div>
        </div>
        
        <?php echo wp_kses_post($after_widget);
    }


    /** @see WP_Widget::update */
    public function update($new_instance, $old_instance)
    {
        $instance = $old_instance;

        $instance['title'] = strip_tags($new_instance['title']);
        $instance['number'] = $new_instance['number'];
        $instance['cat'] = $new_instance['cat'];

        return $instance;
    }

    /** @see WP_Widget::form */
    public function form($instance)
    {
        $title = ($instance) ? esc_attr($instance['title']) : esc_html__('Latest News', 'nitech');
        $number = ($instance) ? esc_attr($instance['number']) : 2;
        $cat = ($instance) ? esc_attr($instance['cat']) : ''; ?>

        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title: ', 'nitech'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('No. of Posts:', 'nitech'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr($number); ?>" />
        </p>
		<p>
            <label for="<?php echo esc_attr($this->get_field_id('categories')); ?>"><?php esc_html_e('Category', 'nitech'); ?></label>
            <?php wp_dropdown_categories(array('show_option_all'=>esc_html__('All Categories', 'nitech'), 'taxonomy' => 'category', 'selected'=>$cat, 'class'=>'widefat', 'name'=>$this->get_field_name('cat'))); ?>
        </p>

        <?php
    }

    public function posts($query_string)
    {
        $query = new WP_Query($query_string);
        if ($query->have_posts()):?>

            <!-- Title -->
            <?php
                global $post;
				while ($query->have_posts()): $query->the_post();
				$post_thumbnail_id = get_post_thumbnail_id($post->ID);
				$post_thumbnail_url = wp_get_attachment_url($post_thumbnail_id); 
			?>
            <div class="post">
                <div class="thumb" style="background-image:url(<?php echo esc_url($post_thumbnail_url); ?>)"><a href="<?php echo esc_url(get_the_permalink(get_the_id()));?>"></a></div>
                <h6><a href="<?php echo esc_url(get_the_permalink(get_the_id()));?>"><?php the_title(); ?></a></h6>
                <span class="date"><?php echo get_the_date();?></span>
            </div>
            <?php endwhile; ?>

        <?php endif;
        wp_reset_postdata();
    }
}

//Infomation
class Nitech_Information extends WP_Widget
{
	
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Nitech_Information', /* Name */esc_html__('Nitech Information','nitech'), array( 'description' => esc_html__('Show the Information in footer', 'nitech' )) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		echo wp_kses_post($before_widget);?>



			<div class="footer-widget contact-widget">
				<?php echo wp_kses_post($before_title.$title.$after_title); ?>
				<ul>
					<li>
						<span class="icon flaticon-placeholder-2"></span>
						<strong><?php echo wp_kses_post($instance['address_title']); ?></strong>
						<?php echo wp_kses_post($instance['address']); ?>
					</li>
					<li>
						<span class="icon flaticon-call"></span>
						<strong><?php echo wp_kses_post($instance['phone_title']); ?></strong>
						<a href="tel:<?php echo phone_number($instance['phone']);?>"><?php echo wp_kses_post($instance['phone']); ?></a>
					</li>
					<li>
						<span class="icon flaticon-email-1"></span>
						<strong><?php echo wp_kses_post($instance['email_title']); ?></strong>
						<a href="mailto:<?php echo sanitize_email($instance['email']); ?>"><?php echo sanitize_email($instance['email']); ?></a>
					</li>
				</ul>
			</div>
      	   <?php
       		
		
		echo wp_kses_post($after_widget);
	}
	
	
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['address_title'] = $new_instance['address_title'];
		$instance['address'] = $new_instance['address'];
		$instance['phone_title'] = $new_instance['phone_title'];
		$instance['phone'] = $new_instance['phone'];
		$instance['email_title'] = $new_instance['email_title'];
		$instance['email'] = $new_instance['email'];
		
		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ($instance) ? esc_attr($instance['title']) : 'Contact Us';
		$address_title = ($instance) ? esc_attr($instance['address_title']) : '';
		$address = ($instance) ? esc_attr($instance['address']) : '';
		$phone_title = ($instance) ? esc_attr($instance['phone_title']) : '';
		$phone = ($instance) ? esc_attr($instance['phone']) : '';
		$email_title = ($instance) ? esc_attr($instance['email_title']) : '';
		$email = ($instance) ? esc_attr($instance['email']) : '';
		
		?>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'nitech'); ?></label>
            <input placeholder="<?php esc_attr_e('title', 'nitech');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('address_title')); ?>"><?php esc_html_e('Address Title:', 'nitech'); ?></label>
            <input placeholder="<?php esc_attr_e('Address Title', 'nitech');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('address_title')); ?>" name="<?php echo esc_attr($this->get_field_name('address_title')); ?>" type="text" value="<?php echo esc_attr($address); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('address')); ?>"><?php esc_html_e('Address:', 'nitech'); ?></label>
            <input placeholder="<?php esc_attr_e('Address', 'nitech');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('address')); ?>" name="<?php echo esc_attr($this->get_field_name('address')); ?>" type="text" value="<?php echo esc_attr($address); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('phone_title')); ?>"><?php esc_html_e('Phone Title:', 'nitech'); ?></label>
            <input placeholder="<?php esc_attr_e('phone title', 'nitech');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('phone_title')); ?>" name="<?php echo esc_attr($this->get_field_name('phone_title')); ?>" type="text" value="<?php echo esc_attr($phone_title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('phone')); ?>"><?php esc_html_e('Phone Number:', 'nitech'); ?></label>
            <input placeholder="<?php esc_attr_e('phone', 'nitech');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('phone')); ?>" name="<?php echo esc_attr($this->get_field_name('phone')); ?>" type="text" value="<?php echo esc_attr($phone); ?>" />
        </p>
		<p>
            <label for="<?php echo esc_attr($this->get_field_id('email_title')); ?>"><?php esc_html_e('Email Title:', 'nitech'); ?></label>
            <input placeholder="<?php esc_attr_e('email', 'nitech');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('email_title')); ?>" name="<?php echo esc_attr($this->get_field_name('email_title')); ?>" type="text" value="<?php echo esc_attr($email_title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('email')); ?>"><?php esc_html_e('Email Addess:', 'nitech'); ?></label>
            <input placeholder="<?php esc_attr_e('email', 'nitech');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('email')); ?>" name="<?php echo esc_attr($this->get_field_name('email')); ?>" type="text" value="<?php echo esc_attr($email); ?>" />
        </p>
        
		<?php 
	}
	
}


///----footer Two widgets---
//Newsletter
class Nitech_Newsletter extends WP_Widget
{
	
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Nitech_Newsletter', /* Name */esc_html__('Nitech Newsletter','nitech'), array( 'description' => esc_html__('Show the Newsletter', 'nitech' )) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		echo wp_kses_post($before_widget);?>
      		
			<!--Footer Column-->
            <div class="newsletter-widget">
                <?php echo wp_kses_post($before_title.$title.$after_title); ?>
                <div class="text"><?php echo wp_kses_post($instance['content']); ?></div>
                <!-- Newsletter Form -->
                <div class="newsletter-form">
                    <?php echo do_shortcode($instance['mailchimp_form_url']); ?>
                </div>
            </div>
            
        <?php
		
		echo wp_kses_post($after_widget);
	}
	
	
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['title'] = strip_tags($new_instance['title']);
		$instance['content'] = $new_instance['content'];
		$instance['mailchimp_form_url'] = $new_instance['mailchimp_form_url'];
		
		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ($instance) ? esc_attr($instance['title']) : 'Newsletter';
		$content = ($instance) ? esc_attr($instance['content']) : '';
		$mailchimp_form_url = ($instance) ? esc_attr($instance['mailchimp_form_url']) : '';
		
		?>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Enter Title:', 'nitech'); ?></label>
            <input placeholder="<?php esc_attr_e('Newsletter', 'nitech');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('content')); ?>"><?php esc_html_e('Content:', 'nitech'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('content')); ?>" name="<?php echo esc_attr($this->get_field_name('content')); ?>" ><?php echo wp_kses_post($content); ?></textarea>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('mailchimp_form_url')); ?>"><?php esc_html_e('MailChimp Form Url:', 'nitech'); ?></label>
            <input placeholder="<?php esc_attr_e('Form Url', 'nitech');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('mailchimp_form_url')); ?>" name="<?php echo esc_attr($this->get_field_name('mailchimp_form_url')); ?>" type="text" value="<?php echo esc_attr($mailchimp_form_url); ?>" />
        </p>
               
                
		<?php 
	}
	
}



