<?php namespace NITECHPLUGIN\Inc;
use NITECHPLUGIN\Inc\Abstracts\Taxonomy;

class Taxonomies extends Taxonomy {

	public static function init() {

		$labels = array(
			'name'              => _x( 'Project Category', 'wpnitech' ),
			'singular_name'     => _x( 'Project Category', 'wpnitech' ),
			'search_items'      => __( 'Search Category', 'wpnitech' ),
			'all_items'         => __( 'All Categories', 'wpnitech' ),
			'parent_item'       => __( 'Parent Category', 'wpnitech' ),
			'parent_item_colon' => __( 'Parent Category:', 'wpnitech' ),
			'edit_item'         => __( 'Edit Category', 'wpnitech' ),
			'update_item'       => __( 'Update Category', 'wpnitech' ),
			'add_new_item'      => __( 'Add New Category', 'wpnitech' ),
			'new_item_name'     => __( 'New Category Name', 'wpnitech' ),
			'menu_name'         => __( 'Project Category', 'wpnitech' ),
		);
		$args   = array(
			'hierarchical'       => true,
			'labels'             => $labels,
			'show_ui'            => true,
			'show_admin_column'  => true,
			'query_var'          => true,
			'public'             => true,
			'publicly_queryable' => true,
			'rewrite'            => array( 'slug' => 'project_cat' ),
		);

		register_taxonomy( 'project_cat', 'project', $args );
		
		//Services Taxonomy Start
		$labels = array(
			'name'              => _x( 'Service Category', 'wpnitech' ),
			'singular_name'     => _x( 'Service Category', 'wpnitech' ),
			'search_items'      => __( 'Search Category', 'wpnitech' ),
			'all_items'         => __( 'All Categories', 'wpnitech' ),
			'parent_item'       => __( 'Parent Category', 'wpnitech' ),
			'parent_item_colon' => __( 'Parent Category:', 'wpnitech' ),
			'edit_item'         => __( 'Edit Category', 'wpnitech' ),
			'update_item'       => __( 'Update Category', 'wpnitech' ),
			'add_new_item'      => __( 'Add New Category', 'wpnitech' ),
			'new_item_name'     => __( 'New Category Name', 'wpnitech' ),
			'menu_name'         => __( 'Service Category', 'wpnitech' ),
		);
		$args   = array(
			'hierarchical'       => true,
			'labels'             => $labels,
			'show_ui'            => true,
			'show_admin_column'  => true,
			'query_var'          => true,
			'public'             => true,
			'publicly_queryable' => true,
			'rewrite'            => array( 'slug' => 'service_cat' ),
		);


		register_taxonomy( 'service_cat', 'service', $args );
		
		//Testimonials Taxonomy Start
		$labels = array(
			'name'              => _x( 'Testimonials Category', 'wpnitech' ),
			'singular_name'     => _x( 'Testimonials Category', 'wpnitech' ),
			'search_items'      => __( 'Search Category', 'wpnitech' ),
			'all_items'         => __( 'All Categories', 'wpnitech' ),
			'parent_item'       => __( 'Parent Category', 'wpnitech' ),
			'parent_item_colon' => __( 'Parent Category:', 'wpnitech' ),
			'edit_item'         => __( 'Edit Category', 'wpnitech' ),
			'update_item'       => __( 'Update Category', 'wpnitech' ),
			'add_new_item'      => __( 'Add New Category', 'wpnitech' ),
			'new_item_name'     => __( 'New Category Name', 'wpnitech' ),
			'menu_name'         => __( 'Testimonials Category', 'wpnitech' ),
		);
		$args   = array(
			'hierarchical'       => true,
			'labels'             => $labels,
			'show_ui'            => true,
			'show_admin_column'  => true,
			'query_var'          => true,
			'public'             => true,
			'publicly_queryable' => true,
			'rewrite'            => array( 'slug' => 'testimonials_cat' ),
		);


		register_taxonomy( 'testimonials_cat', 'testimonials', $args );
		
		
		//Team Taxonomy Start
		$labels = array(
			'name'              => _x( 'Team Category', 'wpnitech' ),
			'singular_name'     => _x( 'Team Category', 'wpnitech' ),
			'search_items'      => __( 'Search Category', 'wpnitech' ),
			'all_items'         => __( 'All Categories', 'wpnitech' ),
			'parent_item'       => __( 'Parent Category', 'wpnitech' ),
			'parent_item_colon' => __( 'Parent Category:', 'wpnitech' ),
			'edit_item'         => __( 'Edit Category', 'wpnitech' ),
			'update_item'       => __( 'Update Category', 'wpnitech' ),
			'add_new_item'      => __( 'Add New Category', 'wpnitech' ),
			'new_item_name'     => __( 'New Category Name', 'wpnitech' ),
			'menu_name'         => __( 'Team Category', 'wpnitech' ),
		);
		$args   = array(
			'hierarchical'       => true,
			'labels'             => $labels,
			'show_ui'            => true,
			'show_admin_column'  => true,
			'query_var'          => true,
			'public'             => true,
			'publicly_queryable' => true,
			'rewrite'            => array( 'slug' => 'team_cat' ),
		);


		register_taxonomy( 'team_cat', 'team', $args );
		
		//Faqs Taxonomy Start
		$labels = array(
			'name'              => _x( 'Faqs Category', 'wpnitech' ),
			'singular_name'     => _x( 'Faq Category', 'wpnitech' ),
			'search_items'      => __( 'Search Category', 'wpnitech' ),
			'all_items'         => __( 'All Categories', 'wpnitech' ),
			'parent_item'       => __( 'Parent Category', 'wpnitech' ),
			'parent_item_colon' => __( 'Parent Category:', 'wpnitech' ),
			'edit_item'         => __( 'Edit Category', 'wpnitech' ),
			'update_item'       => __( 'Update Category', 'wpnitech' ),
			'add_new_item'      => __( 'Add New Category', 'wpnitech' ),
			'new_item_name'     => __( 'New Category Name', 'wpnitech' ),
			'menu_name'         => __( 'Faq Category', 'wpnitech' ),
		);
		$args   = array(
			'hierarchical'       => true,
			'labels'             => $labels,
			'show_ui'            => true,
			'show_admin_column'  => true,
			'query_var'          => true,
			'public'             => true,
			'publicly_queryable' => true,
			'rewrite'            => array( 'slug' => 'faqs_cat' ),
		);


		register_taxonomy( 'faqs_cat', 'faqs', $args );
	}
	
}
