<?php
return array(
	'id'     => 'nitech_banner_settings',
	'title'  => esc_html__( "Nitech Banner Settings", "konia" ),
	'fields' => array(
		array(
			'id'      => 'banner_source_type',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Banner Source Type', 'nitech' ),
			'options' => array(
				'd' => esc_html__( 'Default', 'nitech' ),
				'e' => esc_html__( 'Elementor', 'nitech' ),
			),
			'default' => '',
		),
		array(
			'id'       => 'banner_elementor_template',
			'type'     => 'select',
			'title'    => __( 'Template', 'viral-buzz' ),
			'data'     => 'posts',
			'args'     => [
				'post_type' => [ 'elementor_library' ],
				'posts_per_page'=> -1,
			],
			'required' => [ 'banner_source_type', '=', 'e' ],
		),
		array(
			'id'       => 'banner_page_banner',
			'type'     => 'switch',
			'title'    => esc_html__( 'Show Banner', 'nitech' ),
			'default'  => false,
			'required' => [ 'banner_source_type', '=', 'd' ],
		),
		array(
			'id'       => 'banner_banner_title',
			'type'     => 'text',
			'title'    => esc_html__( 'Banner Section Title', 'nitech' ),
			'desc'     => esc_html__( 'Enter the title to show in banner section', 'nitech' ),
			'required' => array( 'banner_page_banner', '=', true ),
		),
	),
);